/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.transaction;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellEdit {
    static Logger log = LoggerFactory.getLogger(CellEdit.class);
    private byte x;
    private byte y;
    private byte z;
    private int value;
    private int oldValue;

    public CellEdit(byte x, byte y, byte z, int value, int oldValue) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.value = value;
        this.oldValue = oldValue;
    }

    public final boolean apply(DataType dataType, CellData cells) {
        int existing = cells.getCell((int)this.x, (int)this.y, (int)this.z, this.value);
        if (existing == this.value) {
            return false;
        }
        int result = this.value;
        if (log.isTraceEnabled()) {
            log.trace("apply(" + this.x + ", " + this.y + ", " + this.z + ", " + (Object)((Object)dataType) + ")");
        }
        switch (dataType) {
            case Block: {
                int mask;
                int type;
                int oldType = MaskUtils.getType((int)this.oldValue);
                int oldMask = MaskUtils.getSideMask((int)this.oldValue);
                int newType = MaskUtils.getType((int)this.value);
                int newMask = MaskUtils.getSideMask((int)this.value);
                if (oldType != newType) {
                    type = newType;
                    if (log.isTraceEnabled()) {
                        log.trace("   changing type to:" + type);
                    }
                } else {
                    type = MaskUtils.getType((int)existing);
                }
                if (oldMask != newMask) {
                    mask = newMask;
                    if (log.isTraceEnabled()) {
                        log.trace("   changing mask to:" + Integer.toHexString(mask));
                    }
                } else {
                    mask = MaskUtils.getSideMask((int)existing);
                }
                result = MaskUtils.setSideMask((int)type, (int)mask);
                break;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)((Object)dataType) + " setCell(" + this.x + ", " + this.y + ", " + this.z + ", " + result + ")  existing:" + existing);
        }
        cells.setCell((int)this.x, (int)this.y, (int)this.z, result);
        return true;
    }

    public final byte getX() {
        return this.x;
    }

    public final byte getY() {
        return this.y;
    }

    public final byte getZ() {
        return this.z;
    }

    public final Vec3i getCellLocation() {
        return new Vec3i((int)this.x, (int)this.y, (int)this.z);
    }

    public final int getValue() {
        return this.value;
    }

    public final int getOldValue() {
        return this.oldValue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[cellLocation=" + this.getCellLocation() + ", value=" + this.value + ", oldValue=" + this.oldValue + "]";
    }
}

