/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.CommandMap;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.DefaultMouseListener;
import com.simsilica.lemur.event.FocusMouseListener;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.event.MouseListener;
import com.simsilica.lemur.focus.FocusChangeEvent;
import com.simsilica.lemur.focus.FocusChangeListener;
import com.simsilica.lemur.focus.FocusNavigationFunctions;
import com.simsilica.lemur.focus.FocusTraversal;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;
import com.simsilica.lemur.value.DefaultValueRenderer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spinner<T>
extends Panel {
    static Logger log = LoggerFactory.getLogger(Spinner.class);
    public static final String ELEMENT_ID = "spinner";
    public static final String VALUE_ID = "value";
    public static final String EDITOR_ID = "editor";
    public static final String BUTTON_PANEL_ID = "buttons.container";
    public static final String UP_ID = "up.button";
    public static final String DOWN_ID = "down.button";
    public static final String EFFECT_NEXT = "next";
    public static final String EFFECT_PREVIOUS = "previous";
    public static final String EFFECT_ACTIVATE = "activate";
    public static final String EFFECT_DEACTIVATE = "deactivate";
    public static final String EFFECT_START_EDIT = "startEdit";
    public static final String EFFECT_STOP_EDIT = "stopEdit";
    public static final String EFFECT_FOCUS = "focus";
    public static final String EFFECT_UNFOCUS = "unfocus";
    public static final String EFFECT_ENABLE = "enable";
    public static final String EFFECT_DISABLE = "disable";
    private SequenceModel<T> model;
    private VersionedReference<T> modelRef;
    private ValueRenderer<T> valueRenderer;
    private ValueEditor<T> valueEditor;
    private SpringGridLayout layout;
    private Panel view;
    private Panel edit;
    private Button previous;
    private Button next;
    private FocusObserver focusObserver = new FocusObserver();
    private SpinnerMouseHandler mouseHandler = new SpinnerMouseHandler();
    private boolean enabled = true;
    private CommandMap<Spinner, SpinnerAction> commandMap = new CommandMap((Object)this);

    public Spinner(SequenceModel<T> model) {
        this(true, model, null, new ElementId(ELEMENT_ID), null);
    }

    public Spinner(SequenceModel<T> model, ValueRenderer<T> valueRenderer) {
        this(true, model, valueRenderer, new ElementId(ELEMENT_ID), null);
    }

    public Spinner(SequenceModel<T> model, String style) {
        this(true, model, null, new ElementId(ELEMENT_ID), style);
    }

    public Spinner(SequenceModel<T> model, ValueRenderer<T> valueRenderer, String style) {
        this(true, model, valueRenderer, new ElementId(ELEMENT_ID), style);
    }

    public Spinner(SequenceModel<T> model, ValueRenderer<T> valueRenderer, ElementId elementId, String style) {
        this(true, model, valueRenderer, elementId, style);
    }

    protected Spinner(boolean applyStyles, SequenceModel<T> model, ValueRenderer<T> valueRenderer, ElementId elementId, String style) {
        super(false, elementId, style);
        this.layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.ForcedEven, FillMode.First);
        ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)this.layout);
        if (valueRenderer == null) {
            valueRenderer = new DefaultValueRenderer(elementId.child(VALUE_ID), style);
        } else {
            valueRenderer.configureStyle(elementId.child(VALUE_ID), style);
        }
        this.valueRenderer = valueRenderer;
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId, style);
        }
        Container buttons = (Container)this.layout.addChild((Node)new Container(elementId.child(BUTTON_PANEL_ID), style), new Object[]{0, 1});
        this.next = (Button)buttons.addChild((Node)new Button(null, elementId.child(UP_ID), style), new Object[0]);
        this.previous = (Button)buttons.addChild((Node)new Button(null, elementId.child(DOWN_ID), style), new Object[0]);
        ((GuiControl)this.next.getControl(GuiControl.class)).setFocusable(false);
        this.next.addClickCommands((Command)new Command<Button>(){

            public void execute(Button source) {
                Spinner.this.nextValue();
            }
        });
        ((GuiControl)this.previous.getControl(GuiControl.class)).setFocusable(false);
        this.previous.addClickCommands((Command)new Command<Button>(){

            public void execute(Button source) {
                Spinner.this.previousValue();
            }
        });
        this.setModel(model);
    }

    @StyleDefaults(value="spinner")
    public static void initializeDefaultStyles(Styles styles, Attributes attrs) {
        ElementId parent = new ElementId(ELEMENT_ID);
        styles.getSelector(parent.child(UP_ID), null).set("text", (Object)"+", false);
        styles.getSelector(parent.child(UP_ID), null).set("insets", (Object)new Insets3f(0.0f, 0.0f, 0.0f, 0.0f), false);
        styles.getSelector(parent.child(DOWN_ID), null).set("text", (Object)"-", false);
        styles.getSelector(parent.child(DOWN_ID), null).set("insets", (Object)new Insets3f(0.0f, 0.0f, 0.0f, 0.0f), false);
        styles.getSelector(parent.child(VALUE_ID), null).set("textVAlignment", (Object)VAlignment.Center, false);
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.modelRef == null || this.modelRef.update()) {
            this.resetValue();
        }
        if (this.valueEditor != null && this.edit != null && !this.valueEditor.updateState(tpf)) {
            this.stopEditing();
        }
    }

    public void setModel(SequenceModel<T> model) {
        if (this.model == model) {
            return;
        }
        this.model = model;
        this.modelRef = null;
    }

    public SequenceModel<T> getModel() {
        return this.model;
    }

    public void setValueEditor(ValueEditor<T> valueEditor) {
        if (Objects.equals(this.valueEditor, valueEditor)) {
            return;
        }
        this.stopEditing();
        this.valueEditor = valueEditor;
    }

    public ValueEditor<T> getValueEditor() {
        return this.valueEditor;
    }

    public void setValue(T value) {
        this.getModel().setObject(value);
    }

    public T getValue() {
        if (this.model == null) {
            return null;
        }
        return this.getModel().getObject();
    }

    public void nextValue() {
        if (this.model == null) {
            return;
        }
        this.model.setObject(this.model.getNextObject());
        this.commandMap.runCommands((Object)SpinnerAction.NextValue);
        this.runEffect(EFFECT_NEXT);
    }

    public void previousValue() {
        if (this.model == null) {
            return;
        }
        this.model.setObject(this.model.getPreviousObject());
        this.commandMap.runCommands((Object)SpinnerAction.PreviousValue);
        this.runEffect(EFFECT_PREVIOUS);
    }

    public void setEnabled(boolean b) {
        if (this.enabled == b) {
            return;
        }
        this.enabled = b;
        this.previous.setEnabled(b);
        this.next.setEnabled(b);
        if (this.isEnabled()) {
            this.commandMap.runCommands((Object)SpinnerAction.Enabled);
            this.runEffect(EFFECT_ENABLE);
        } else {
            this.commandMap.runCommands((Object)SpinnerAction.Disabled);
            this.runEffect(EFFECT_DISABLE);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void startEditing() {
        Panel newEdit;
        if (this.valueEditor == null) {
            return;
        }
        this.commandMap.runCommands((Object)SpinnerAction.StartEdit);
        this.runEffect(EFFECT_START_EDIT);
        if (this.view != null) {
            this.layout.removeChild((Node)this.view);
        }
        if ((newEdit = this.valueEditor.startEditing(this.model.getObject())) != this.edit) {
            this.layout.removeChild((Node)this.edit);
        }
        this.edit = newEdit;
        this.layout.addChild((Node)this.edit, new Object[]{0, 0});
        GuiGlobals.getInstance().requestFocus((Spatial)this.edit);
    }

    public void stopEditing() {
        if (this.valueEditor == null) {
            return;
        }
        this.model.setObject(this.valueEditor.getObject());
        this.commandMap.runCommands((Object)SpinnerAction.StopEdit);
        this.runEffect(EFFECT_STOP_EDIT);
        boolean navigateNext = ((GuiControl)this.edit.getControl(GuiControl.class)).isFocused();
        this.layout.removeChild((Node)this.edit);
        this.edit = null;
        if (this.view != null) {
            this.layout.addChild((Node)this.view, new Object[]{0, 0});
        }
        if (navigateNext) {
            GuiGlobals.getInstance().getFocusNavigationState().requestChangeFocus((Spatial)this, FocusTraversal.TraversalDirection.Next);
        }
    }

    public boolean isEditing() {
        return this.edit != null;
    }

    protected void setView(Panel view) {
        if (this.view == view) {
            return;
        }
        if (this.view != null) {
            ((GuiControl)this.view.getControl(GuiControl.class)).removeFocusChangeListener((FocusChangeListener)this.focusObserver);
            MouseEventControl.removeListenersFromSpatial((Spatial)this.view, (MouseListener[])new MouseListener[]{FocusMouseListener.INSTANCE, this.mouseHandler});
            this.layout.removeChild((Node)this.view);
        }
        this.view = view;
        if (this.view != null) {
            ((GuiControl)this.view.getControl(GuiControl.class)).addFocusChangeListener((FocusChangeListener)this.focusObserver);
            ((GuiControl)this.view.getControl(GuiControl.class)).setFocusable(true);
            MouseEventControl.addListenersToSpatial((Spatial)this.view, (MouseListener[])new MouseListener[]{FocusMouseListener.INSTANCE, this.mouseHandler});
            if (!this.isEditing()) {
                this.layout.addChild((Node)this.view, new Object[]{0, 0});
            }
        }
    }

    protected void resetValue() {
        if (this.modelRef == null) {
            this.modelRef = this.model.createReference();
        }
        this.setView(this.valueRenderer.getView(this.modelRef.get(), false, this.view));
    }

    protected class SpinnerMouseHandler
    extends DefaultMouseListener {
        protected SpinnerMouseHandler() {
        }

        protected void click(MouseButtonEvent event, Spatial target, Spatial capture) {
        }

        public void mouseButtonEvent(MouseButtonEvent event, Spatial target, Spatial capture) {
            event.setConsumed();
            if (!Spinner.this.isEnabled()) {
                return;
            }
        }

        public void mouseEntered(MouseMotionEvent event, Spatial target, Spatial capture) {
            if (!Spinner.this.isEnabled()) {
                return;
            }
            if (capture == Spinner.this || target == Spinner.this && capture == null) {
                Spinner.this.commandMap.runCommands((Object)SpinnerAction.HighlightOn);
                Spinner.this.runEffect(Spinner.EFFECT_ACTIVATE);
            }
        }

        public void mouseExited(MouseMotionEvent event, Spatial target, Spatial capture) {
            Spinner.this.commandMap.runCommands((Object)SpinnerAction.HighlightOff);
            Spinner.this.runEffect(Spinner.EFFECT_DEACTIVATE);
        }

        public void mouseMoved(MouseMotionEvent event, Spatial target, Spatial capture) {
            Spinner.this.commandMap.runCommands((Object)SpinnerAction.Hover);
        }
    }

    protected class FocusObserver
    implements FocusChangeListener,
    StateFunctionListener {
        protected FocusObserver() {
        }

        public void focusGained(FocusChangeEvent event) {
            if (!Spinner.this.isEnabled()) {
                return;
            }
            Spinner.this.commandMap.runCommands((Object)SpinnerAction.FocusGained);
            Spinner.this.runEffect(Spinner.EFFECT_FOCUS);
            GuiGlobals.getInstance().getInputMapper().addStateListener((StateFunctionListener)this, new FunctionId[]{FocusNavigationFunctions.F_ACTIVATE});
            Spinner.this.startEditing();
        }

        public void focusLost(FocusChangeEvent event) {
            GuiGlobals.getInstance().getInputMapper().removeStateListener((StateFunctionListener)this, new FunctionId[]{FocusNavigationFunctions.F_ACTIVATE});
            Spinner.this.commandMap.runCommands((Object)SpinnerAction.FocusLost);
            Spinner.this.runEffect(Spinner.EFFECT_UNFOCUS);
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
        }
    }

    public static enum SpinnerAction {
        PreviousValue,
        NextValue,
        StartEdit,
        StopEdit,
        HighlightOn,
        HighlightOff,
        FocusGained,
        FocusLost,
        Hover,
        Enabled,
        Disabled;

    }
}

