/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class VersionedList<T>
extends AbstractList<T>
implements VersionedObject<List<T>> {
    private long version = 0L;
    private List<T> list;

    protected VersionedList(List<T> items, boolean copy) {
        if (copy) {
            this.list = new ArrayList<T>();
            this.list.addAll(items);
        } else {
            this.list = items;
        }
    }

    public VersionedList() {
        this(new ArrayList(), false);
    }

    public VersionedList(List<T> items) {
        this(items, true);
    }

    public static <T> VersionedList<T> wrap(List<T> list) {
        return new VersionedList<T>(list, false);
    }

    protected void incrementVersion() {
        ++this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public List<T> getObject() {
        return this;
    }

    public VersionedReference<List<T>> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    @Override
    public T get(int i) {
        return this.list.get(i);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public T set(int i, T val) {
        T result = this.list.set(i, val);
        this.incrementVersion();
        return result;
    }

    @Override
    public void add(int i, T val) {
        this.list.add(i, val);
        this.incrementVersion();
    }

    @Override
    public T remove(int i) {
        T result = this.list.remove(i);
        this.incrementVersion();
        return result;
    }
}

