/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationRelationship
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(LocationRelationship.class);
    private EntityId source;
    private EntityId target;
    private Vec3d location;
    private int typeId;

    private LocationRelationship() {
    }

    public LocationRelationship(EntityId source, EntityId target, Vec3d location, int typeId) {
        this.source = source;
        this.target = target;
        this.location = location;
        this.typeId = typeId;
    }

    public static ComponentFilter<LocationRelationship> sourceFilter(EntityId source) {
        return Filters.fieldEquals(LocationRelationship.class, (String)"source", (Object)source);
    }

    public static LocationRelationship create(EntityId source, Vec3d location, String type, EntityData ed) {
        int id = ed.getStrings().getStringId(type, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(type, true);
        }
        return new LocationRelationship(source, null, location, id);
    }

    public EntityId getSource() {
        return this.source;
    }

    public EntityId getTarget() {
        return this.target;
    }

    public Vec3d getLocation() {
        return this.location;
    }

    public EntityId getAdjacent(EntityId start) {
        if (start.getId() == this.target.getId()) {
            return this.source;
        }
        if (start.getId() == this.source.getId()) {
            return this.target;
        }
        return null;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getType(EntityData ed) {
        if (this.typeId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.typeId);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)this.getClass().getSimpleName());
        if (ed == null) {
            helper.add("typeId", this.typeId);
        } else {
            helper.add("type", (Object)this.getType(ed));
        }
        return helper.add("source", (Object)this.source).add("target", (Object)this.target).add("typeId", this.typeId).toString();
    }
}

