/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.google.common.base.Function;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.ControlDriver;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import mythruna.es.AgentType;
import mythruna.sim.ai.AgentChatProvider;
import mythruna.sim.ai.AgentDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(AgentSystem.class);
    private EntityData ed;
    private ChatHostedService chatService;
    private MPhysSystem<MBlockShape> physics;
    private AgentContainer agents;
    private AgentBodyInitializer initializer = new AgentBodyInitializer();
    private PhysicsSpace<EntityId, MBlockShape> space;

    public AgentSystem(ChatHostedService chatService) {
        this.chatService = chatService;
    }

    public RigidBody<EntityId, MBlockShape> getBody(EntityId id) {
        return this.space.getBinIndex().getRigidBody((Object)id);
    }

    public AgentDriver getAgentDriver(EntityId id) {
        return (AgentDriver)this.agents.getObject(id);
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class);
        if (this.ed == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " system requires an EntityData object.");
        }
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class);
        if (this.physics == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " system requires the MPhysSystem system.");
        }
        this.space = this.physics.getPhysicsSpace();
        this.physics.getBodyFactory().addDynamicInitializer((Function)this.initializer);
    }

    protected void terminate() {
    }

    public void start() {
        this.agents = new AgentContainer(this.ed);
        this.agents.start();
    }

    public void update(SimTime time) {
        this.agents.update();
    }

    public void stop() {
        this.agents.stop();
        this.agents = null;
    }

    private class AgentContainer
    extends EntityContainer<AgentDriver> {
        public AgentContainer(EntityData ed) {
            super(ed, new Class[]{AgentType.class});
            this.setFilter(AgentType.levelFilter(0));
        }

        public AgentDriver[] getArray() {
            return (AgentDriver[])super.getArray();
        }

        protected AgentDriver addObject(Entity e) {
            log.info("addObject(" + e + ")");
            AgentDriver result = new AgentDriver((MPhysSystem<MBlockShape>)AgentSystem.this.physics, new AgentChatProvider(e.getId(), AgentSystem.this.chatService), e.getId());
            RigidBody body = AgentSystem.this.space.getBinIndex().getRigidBody((Object)e.getId());
            log.info("existing body:" + body);
            if (body != null) {
                body.setControlDriver((ControlDriver)result);
                body.wakeUp();
            }
            this.updateObject(result, e);
            return result;
        }

        protected void updateObject(AgentDriver driver, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
            AgentType type = (AgentType)e.get(AgentType.class);
            driver.changeAgentType(type);
        }

        protected void removeObject(AgentDriver driver, Entity e) {
            log.info("removeObject(" + e + ")");
        }
    }

    private class AgentBodyInitializer
    implements Function<RigidBody<EntityId, MBlockShape>, Void> {
        private AgentBodyInitializer() {
        }

        public Void apply(RigidBody<EntityId, MBlockShape> body) {
            AgentDriver driver = (AgentDriver)AgentSystem.this.agents.getObject((EntityId)body.id);
            log.info("MovementBodyInitializer.apply(" + body + ")  driver:" + driver);
            if (driver != null) {
                body.setControlDriver((ControlDriver)driver);
            }
            return null;
        }
    }
}

