/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.google.common.base.Supplier;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Server;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.sim.GameSystemManager;
import java.io.IOException;
import java.net.InetAddress;
import mythruna.client.MythrunaConfig;
import mythruna.server.GameServer;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostedGameState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(HostedGameState.class);
    private WorldManager worldManager;
    private GameServer gameServer;
    private int port;
    private boolean singlePlayer;
    private Supplier<String> tokenSupplier;
    private GameSystemManager systems;
    private EntityData ed;
    private VersionedHolder<String> hostingState = new VersionedHolder((Object)"");
    private VersionedHolder<String> connectionCount = new VersionedHolder((Object)"");
    private ConnectionListener connectionListener = new ConnectionObserver();
    private Runnable startedCallback;

    public HostedGameState(WorldManager worldManager, int port, String description, boolean singlePlayer, Supplier<String> tokenSupplier) {
        try {
            this.worldManager = worldManager;
            this.singlePlayer = singlePlayer;
            this.port = port;
            this.tokenSupplier = tokenSupplier;
            InetAddress address = null;
            worldManager.getModManager().setGlobalBinding("singlePlayer", (Object)singlePlayer);
            this.gameServer = new GameServer(worldManager, tokenSupplier, address, port, description, MythrunaConfig.getInstance().getStartupSettings());
            this.systems = this.gameServer.getSystems();
            this.ed = worldManager.getEntityData();
            this.gameServer.getServer().addConnectionListener(this.connectionListener);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating server", e);
        }
    }

    public HostedGameState onStarted(Runnable startedCallback) {
        this.startedCallback = startedCallback;
        return this;
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer;
    }

    public int getPort() {
        return this.port;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public GameSystemManager getSystems() {
        return this.systems;
    }

    public GameServer getGameServer() {
        return this.gameServer;
    }

    public VersionedObject<String> getHostingState() {
        return this.hostingState;
    }

    public VersionedObject<String> getConnectionCount() {
        return this.connectionCount;
    }

    public void startGame() {
        log.info("startGame()");
    }

    public void close() {
        this.close("Shutting down.");
    }

    public void close(String message) {
        if (this.gameServer == null) {
            return;
        }
        this.gameServer.close(message);
        this.hostingState.setObject((Object)"Offline");
        this.gameServer = null;
        this.worldManager.close();
    }

    protected void initialize(Application app) {
        if (this.getState(HostedGameState.class) != this) {
            throw new RuntimeException("More than one HostState is not allowed.");
        }
        Thread thread = new Thread(() -> {
            this.gameServer.start();
            app.enqueue(() -> {
                this.hostingState.setObject((Object)"Online");
                this.resetConnectionCount();
            });
            if (this.startedCallback != null) {
                app.enqueue(this.startedCallback);
            }
        }, "Host Startup");
        thread.setDaemon(true);
        thread.start();
    }

    protected void cleanup(Application app) {
        this.close();
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    protected void resetConnectionCount() {
        this.connectionCount.setObject((Object)String.valueOf(this.gameServer.getServer().getConnections().size()));
    }

    private class ConnectionObserver
    implements ConnectionListener {
        private ConnectionObserver() {
        }

        public void connectionAdded(Server server, HostedConnection conn) {
            HostedGameState.this.resetConnectionCount();
        }

        public void connectionRemoved(Server server, HostedConnection conn) {
            HostedGameState.this.resetConnectionCount();
        }
    }
}

