/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vec3dEditor
extends Container
implements VersionedObject<Vec3d> {
    static Logger log = LoggerFactory.getLogger(Vec3dEditor.class);
    public static final String ELEMENT_ID = "vec3dEditor";
    private VersionedHolder<Vec3d> value = new VersionedHolder();
    private Spinner<Double> xSpinner;
    private VersionedReference<Double> xRef;
    private Spinner<Double> ySpinner;
    private VersionedReference<Double> yRef;
    private Spinner<Double> zSpinner;
    private VersionedReference<Double> zRef;

    public Vec3dEditor(SequenceModel<Double> xModel, SequenceModel<Double> yModel, SequenceModel<Double> zModel, String format, float minSpinnerWidth, float textSpacing) {
        super((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.None, FillMode.None), true, new ElementId(ELEMENT_ID).child("container"), null);
        ElementId labelId = this.getElementId().child("label");
        ((Label)this.addChild((Node)new Label("x:", labelId), new Object[0])).setInsets(new Insets3f(0.0f, textSpacing, 0.0f, 0.0f));
        this.xSpinner = (Spinner)this.addChild((Node)Vec3dEditor.createDoubleSpinner(xModel, format), new Object[0]);
        Vector3f pref = this.xSpinner.getPreferredSize();
        pref.x = Math.max(minSpinnerWidth, pref.x);
        this.xSpinner.setPreferredSize(pref);
        this.xRef = this.xSpinner.getModel().createReference();
        ((Label)this.addChild((Node)new Label("y:", labelId), new Object[0])).setInsets(new Insets3f(0.0f, textSpacing, 0.0f, 0.0f));
        this.ySpinner = (Spinner)this.addChild((Node)Vec3dEditor.createDoubleSpinner(yModel, format), new Object[0]);
        pref = this.ySpinner.getPreferredSize();
        pref.x = Math.max(minSpinnerWidth, pref.x);
        this.ySpinner.setPreferredSize(pref);
        this.yRef = this.ySpinner.getModel().createReference();
        ((Label)this.addChild((Node)new Label("z:", labelId), new Object[0])).setInsets(new Insets3f(0.0f, textSpacing, 0.0f, 0.0f));
        this.zSpinner = (Spinner)this.addChild((Node)Vec3dEditor.createDoubleSpinner(zModel, format), new Object[0]);
        pref = this.zSpinner.getPreferredSize();
        pref.x = Math.max(minSpinnerWidth, pref.x);
        this.zSpinner.setPreferredSize(pref);
        this.zRef = this.zSpinner.getModel().createReference();
    }

    public static Spinner<Double> createDoubleSpinner(double min, double max, double step, double precision, double initialValue, String format) {
        SequenceModel model = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(min, max, initialValue), (double)step, (double)precision);
        DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)format, (String)"error");
        Spinner result = new Spinner(model, (ValueRenderer)renderer);
        result.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)format));
        return result;
    }

    public static SequenceModel<Double> createModel(double min, double max, double step, double precision, double initialValue) {
        return SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(min, max, initialValue), (double)step, (double)precision);
    }

    public static Spinner<Double> createDoubleSpinner(SequenceModel<Double> model, String format) {
        DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)format, (String)"error");
        Spinner result = new Spinner(model, (ValueRenderer)renderer);
        result.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)format));
        return result;
    }

    public void setObject(Vec3d value) {
        if (this.value.getObject() != value) {
            this.value.setObject((Object)value);
            this.resetSpinners(value);
        }
    }

    public Vec3d getObject() {
        return (Vec3d)this.value.getObject();
    }

    public VersionedReference<Vec3d> createReference() {
        return this.value.createReference();
    }

    public long getVersion() {
        return this.value.getVersion();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.value.getObject() == null) {
            return;
        }
        Vec3d val = (Vec3d)this.value.getObject();
        boolean changed = false;
        if (this.xRef.update()) {
            val.x = (Double)this.xRef.get();
            changed = true;
        }
        if (this.yRef.update()) {
            val.y = (Double)this.yRef.get();
            changed = true;
        }
        if (this.zRef.update()) {
            val.z = (Double)this.zRef.get();
            changed = true;
        }
        if (changed) {
            this.value.incrementVersion();
        }
    }

    protected void resetSpinners(Vec3d val) {
        this.xSpinner.setValue((Object)val.x);
        this.ySpinner.setValue((Object)val.y);
        this.zSpinner.setValue((Object)val.z);
    }
}

