/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.WatchedEntity;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.DynArray;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.view.AreaField;
import mythruna.client.view.AvatarState;
import mythruna.client.view.Model;
import mythruna.client.view.ModelViewState;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimMarker;
import mythruna.es.ClaimPermissions;
import mythruna.es.OwnedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClaimViewState.class);
    private static ClaimPermissions DEFAULT_PERMS = new ClaimPermissions(null, new int[]{4, 2, 8, 16, 32, 64, 128, 256, 512, 1024});
    private ModelViewState models;
    private EntityData ed;
    private VersionedReference<Vec3d> posRef;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private Node root;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private MarkerContainer markers;
    private Map<EntityId, AreaView> areas = new HashMap<EntityId, AreaView>();
    private DynArray<AreaView> areaList = new DynArray(AreaView.class);
    private Vec3i markerCenter = new Vec3i();
    private int markerGridRadius = 2;
    private ComponentFilter[][] gridFilters;

    public ClaimViewState() {
        this.setEnabled(false);
    }

    public ClaimPermissions getPerms(Vec3i loc) {
        if (!this.isEnabled()) {
            this.update(0.0f);
        }
        for (AreaView view : (AreaView[])this.areaList.getArray()) {
            if (view.area == null || !view.area.contains(loc)) continue;
            if (Objects.equals(view.owner, ((AvatarState)this.getState(AvatarState.class)).getAvatarId())) {
                return ClaimPermissions.createOwnerPermissions((EntityId)view.entityId);
            }
            return ClaimPermissions.createNoAccess((EntityId)view.entityId);
        }
        return DEFAULT_PERMS;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.root = new Node("areaRoot");
        this.models = (ModelViewState)this.getState(ModelViewState.class, true);
        this.markers = new MarkerContainer(this.ed);
        this.resetModelFilter();
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
        this.markers.start();
    }

    protected void cleanup(Application app) {
        this.markers.stop();
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.root);
        for (Marker marker : this.markers.getArray()) {
            marker.resetVisibility();
        }
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.markers.update();
        for (AreaView view : (AreaView[])this.areaList.getArray()) {
            view.update();
        }
    }

    protected void onDisable() {
        this.root.removeFromParent();
        for (Marker marker : this.markers.getArray()) {
            marker.resetVisibility();
        }
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        log.info("centerWorld:" + this.centerWorld);
        this.resetRelativeCoordinates();
        if (this.markerCenter.x != this.centerCell.x || this.markerCenter.z != this.centerCell.z) {
            this.markerCenter.x = this.centerCell.x;
            this.markerCenter.z = this.centerCell.z;
            this.resetModelFilter();
        }
    }

    protected void resetRelativeCoordinates() {
        for (AreaView view : (AreaView[])this.areaList.getArray()) {
            view.updateRelativePosition();
        }
    }

    protected void resetModelFilter() {
        int size = this.markerGridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.markerCenter.x - this.markerGridRadius;
        int zOffset = this.markerCenter.z - this.markerGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.markers.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
    }

    protected AreaView acquireAreaView(EntityId id) {
        AreaView result = this.areas.get(id);
        if (result == null) {
            result = new AreaView(id);
            this.areas.put(id, result);
            this.areaList.add((Object)result);
        }
        result.acquire();
        return result;
    }

    protected void releaseAreaView(EntityId id) {
        AreaView result = this.areas.get(id);
        if (result != null) {
            result.release();
            this.areaList.remove((Object)result);
        }
    }

    private class AreaView {
        private EntityId entityId;
        private WatchedEntity entity;
        private SpawnPosition pos;
        private ColorRGBA color;
        private ClaimArea area;
        private EntityId owner;
        private Vec3i basePos;
        private int yBase;
        private int useCount;
        private AreaField areaGeom;
        private boolean invalid = true;

        public AreaView(EntityId entityId) {
            this.entityId = entityId;
            this.entity = ClaimViewState.this.ed.watchEntity(entityId, new Class[]{SpawnPosition.class, ClaimArea.class, OwnedBy.class});
            log.info("Created AreaView(" + entityId + "):" + this.entity);
            this.updateFields();
        }

        public void update() {
            if (this.entity.applyChanges()) {
                log.info("Area changed:" + this.entity);
                this.updateFields();
            }
            if (this.invalid) {
                this.updateGeometry();
            }
        }

        protected void updateFields() {
            SpawnPosition newPos = (SpawnPosition)this.entity.get(SpawnPosition.class);
            int y = (int)Math.floor(newPos.getLocation().y);
            if (y != this.yBase) {
                this.invalid = true;
            }
            this.pos = newPos;
            this.yBase = y;
            ClaimArea newArea = (ClaimArea)this.entity.get(ClaimArea.class);
            if (!Objects.equals(newArea, this.area)) {
                this.area = newArea;
                this.invalid = true;
            }
            this.color = ColorRGBA.Red;
            OwnedBy owned = (OwnedBy)this.entity.get(OwnedBy.class);
            if (owned != null && Objects.equals(owned.getOwner(), ((AvatarState)ClaimViewState.this.getState(AvatarState.class)).getAvatarId())) {
                this.color = ColorRGBA.Cyan;
                this.owner = owned.getOwner();
            } else {
                this.owner = null;
            }
            if (this.areaGeom != null) {
                this.areaGeom.setColor(this.color);
            }
        }

        protected void updateGeometry() {
            if (this.area == null) {
                log.warn("area is null for:" + this.entityId);
                return;
            }
            this.basePos = this.area.getMin().clone();
            Vec3i min = new Vec3i();
            Vec3i max = this.area.getMax().subtract(this.basePos);
            this.basePos.y = this.yBase;
            if (this.areaGeom == null) {
                this.areaGeom = new AreaField(ClaimViewState.this.getApplication().getAssetManager(), min, max);
                this.areaGeom.setColor(this.color);
                ClaimViewState.this.root.attachChild((Spatial)this.areaGeom);
            } else {
                this.areaGeom.setArea(min, max);
            }
            log.info("Updated geomtry for:" + this.entityId + " to:" + this.basePos + " -> + " + max);
            this.updateRelativePosition();
            this.invalid = false;
        }

        protected void acquire() {
            ++this.useCount;
        }

        protected void release() {
            --this.useCount;
            if (this.useCount <= 0) {
                log.info("Releasing AreaView(" + this.entityId + ")");
                ClaimViewState.this.areas.remove(this.entityId);
                if (this.areaGeom == null) {
                    log.warn("Removing area view that never had geometry:" + this.entityId);
                } else {
                    this.areaGeom.removeFromParent();
                }
            }
        }

        public void updateRelativePosition() {
            Vec3i loc = this.basePos.clone();
            loc.subtractLocal(ClaimViewState.this.centerWorld);
            this.areaGeom.setLocalTranslation(loc.toVector3f());
        }
    }

    private class MarkerContainer
    extends EntityContainer<Marker> {
        public MarkerContainer(EntityData ed) {
            super(ed, new Class[]{ClaimMarker.class, SpawnPosition.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public Marker[] getArray() {
            return (Marker[])super.getArray();
        }

        protected Marker addObject(Entity e) {
            log.info("add marker for:" + e.getId() + "  e:" + e);
            Marker object = new Marker(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(Marker object, Entity e) {
            log.info("updateMarker(" + e.getId() + ") pos:" + e.get(SpawnPosition.class));
            object.update();
        }

        protected void removeObject(Marker object, Entity e) {
            log.info("remove marker for:" + e.getId());
            object.release();
        }
    }

    private class Marker {
        private Entity entity;
        private Model model;
        private ClaimMarker claimMarker;
        private AreaView area;

        public Marker(Entity entity) {
            this.entity = entity;
            this.model = ClaimViewState.this.models.getStandIn(entity.getId(), true);
            this.model.setVisible(ClaimViewState.this.isEnabled());
            this.claimMarker = (ClaimMarker)entity.get(ClaimMarker.class);
            this.area = ClaimViewState.this.acquireAreaView(this.claimMarker.getClaim());
            this.model.setShape(ShapeInfo.create((String)this.claimMarker.getTypeName(ClaimViewState.this.ed), (double)0.25, (EntityData)ClaimViewState.this.ed));
        }

        public void resetVisibility() {
            this.model.setVisible(ClaimViewState.this.isEnabled());
        }

        public void update() {
            SpawnPosition pos = (SpawnPosition)this.entity.get(SpawnPosition.class);
            this.model.setPosition(pos);
        }

        public void release() {
            ClaimViewState.this.releaseAreaView(this.claimMarker.getClaim());
            ClaimViewState.this.models.releaseStandIn(this.entity.getId());
        }
    }
}

