/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import com.jme3.network.HostedConnection;
import com.jme3.network.MessageListener;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.serializers.FieldSerializer;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.util.SessionDataDelegator;
import com.simsilica.ethereal.NanoTimeSource;
import com.simsilica.ethereal.NetworkStateListener;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ethereal.net.ClientStateMessage;
import com.simsilica.ethereal.net.ObjectStateMessage;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import com.simsilica.ethereal.zone.StateCollector;
import com.simsilica.ethereal.zone.StateListener;
import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.ethereal.zone.ZoneManager;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.bits.QuatBits;
import com.simsilica.mathd.bits.Vec3Bits;

public class EtherealHost
extends AbstractHostedConnectionService {
    private ZoneGrid grid;
    private ZoneManager zones;
    private StateCollector stateCollector;
    private ObjectStateProtocol objectProtocol;
    private Vec3i clientZoneExtents;
    private long stateCollectionInterval;
    private long stateCollectionSleepTime = 1L;
    private SessionDataDelegator delegator;
    private TimeSource timeSource = new NanoTimeSource();

    public EtherealHost() {
        this(new ObjectStateProtocol(8, 64, new Vec3Bits(-10.0f, 42.0f, 16), new QuatBits(12)), new ZoneGrid(32), new Vec3i(1, 1, 1));
    }

    public EtherealHost(ZoneGrid grid) {
        this(new ObjectStateProtocol(8, 64, new Vec3Bits(-10.0f, 42.0f, 16), new QuatBits(12)), grid, new Vec3i(1, 1, 1));
    }

    public EtherealHost(ObjectStateProtocol objectProtocol, ZoneGrid grid, Vec3i clientZoneExtents) {
        super(false);
        this.objectProtocol = objectProtocol;
        this.grid = grid;
        this.clientZoneExtents = clientZoneExtents;
        this.zones = new ZoneManager(grid);
        Serializer.registerClasses((Class[])new Class[]{ClientStateMessage.class, ObjectStateMessage.class});
        Serializer.registerClass(Vec3d.class, (Serializer)new FieldSerializer());
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource == null ? new NanoTimeSource() : timeSource;
    }

    public ZoneManager getZones() {
        return this.zones;
    }

    public void setObjectProtocol(ObjectStateProtocol objectProtocol) {
        this.objectProtocol = objectProtocol;
    }

    public ObjectStateProtocol getObjectProtocol() {
        return this.objectProtocol;
    }

    public void addListener(StateListener l) {
        this.stateCollector.addListener(l);
    }

    public void removeListener(StateListener l) {
        this.stateCollector.removeListener(l);
    }

    public void setStateCollectionInterval(long nanos) {
        if (this.stateCollector != null) {
            throw new RuntimeException("The state collection interval cannot be set once the service is initialized.");
        }
        this.stateCollectionInterval = nanos;
    }

    public long getStateCollectionInterval() {
        return this.stateCollectionInterval;
    }

    public void setStateCollectionSleepTime(long millis) {
        this.stateCollectionSleepTime = millis;
        if (this.stateCollector != null) {
            this.stateCollector.setIdleSleepTime(millis);
        }
    }

    public long getStateCollectionSleepTime() {
        return this.stateCollectionSleepTime;
    }

    protected void onInitialize(HostedServiceManager s) {
        this.stateCollector = new StateCollector(this.zones, this.stateCollectionInterval);
        this.stateCollector.setIdleSleepTime(this.stateCollectionSleepTime);
        this.delegator = new SessionDataDelegator(NetworkStateListener.class, "networkStateListener", true);
        this.getServer().addMessageListener((MessageListener)this.delegator, this.delegator.getMessageTypes());
    }

    public void terminate(HostedServiceManager serviceManager) {
        this.getServer().removeMessageListener((MessageListener)this.delegator, this.delegator.getMessageTypes());
    }

    public void start() {
        this.stateCollector.start();
    }

    public void stop() {
        this.stateCollector.shutdown();
    }

    public NetworkStateListener getStateListener(HostedConnection hc) {
        return (NetworkStateListener)hc.getAttribute("networkStateListener");
    }

    public void startHostingOnConnection(HostedConnection hc) {
        NetworkStateListener nsl = (NetworkStateListener)hc.getAttribute("networkStateListener");
        if (nsl != null) {
            return;
        }
        nsl = new NetworkStateListener(this, hc, this.grid, this.clientZoneExtents);
        hc.setAttribute("networkStateListener", (Object)nsl);
        this.stateCollector.addListener(nsl);
    }

    public void setConnectionObject(HostedConnection hc, Long selfId, Vec3d initialPosition) {
        this.getStateListener(hc).setSelf(selfId, initialPosition);
    }

    public void stopHostingOnConnection(HostedConnection hc) {
        NetworkStateListener nsl = (NetworkStateListener)hc.getAttribute("networkStateListener");
        if (nsl == null) {
            return;
        }
        this.stateCollector.removeListener(nsl);
        hc.setAttribute("networkStateListener", null);
    }
}

