/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rpc;

import com.jme3.network.Client;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rpc.RpcConnection;
import com.jme3.network.service.rpc.RpcHandler;
import com.jme3.network.util.ObjectMessageDelegator;

public class RpcClientService
extends AbstractClientService {
    private RpcConnection rpc;
    private ObjectMessageDelegator delegator;

    public RpcConnection getRpcConnection() {
        return this.rpc;
    }

    @Override
    protected void onInitialize(ClientServiceManager serviceManager) {
        Client client = serviceManager.getClient();
        this.rpc = new RpcConnection(client);
        this.delegator = new ObjectMessageDelegator(this.rpc, true);
        client.addMessageListener(this.delegator, this.delegator.getMessageTypes());
    }

    @Override
    public void terminate(ClientServiceManager serviceManager) {
        Client client = serviceManager.getClient();
        client.removeMessageListener(this.delegator, this.delegator.getMessageTypes());
    }

    public Object callAndWait(byte channel, short objId, short procId, Object ... args) {
        return this.rpc.callAndWait(channel, objId, procId, args);
    }

    public void callAsync(byte channel, short objId, short procId, Object ... args) {
        this.rpc.callAsync(channel, objId, procId, args);
    }

    public void registerHandler(short objId, RpcHandler handler) {
        this.rpc.registerHandler(objId, handler);
    }

    public void removeHandler(short objId, RpcHandler handler) {
        this.rpc.removeHandler(objId, handler);
    }
}

