/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.FilteredContactListener;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.sim.AbstractGameSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(ContactSystem.class);
    private MPhysSystem<MBlockShape> physics;
    private PhysicsSpace<EntityId, MBlockShape> space;
    private ContactObserver observer = new ContactObserver();
    private FilteredContactListener<EntityId, MBlockShape> filter;
    private boolean[] ignore;

    protected void initialize() {
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class, true);
        this.space = this.physics.getPhysicsSpace();
        if (this.space.getContactDispatcher() != null) {
            this.filter = new FilteredContactListener((ContactListener)this.observer, this.space.getContactDispatcher());
            this.space.setContactDispatcher(this.filter);
        } else {
            this.space.setContactDispatcher((ContactListener)this.observer);
        }
    }

    public void start() {
        BlockType[] types = BlockTypeIndex.getTypes();
        this.ignore = new boolean[types.length];
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null) continue;
            BlockName name = type.getName();
            String base = name.getBase();
            if ("magic-white".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("magic-red".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("magic-green".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("magic-blue".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if ("fire".equals(base)) {
                this.ignore[i] = true;
                continue;
            }
            if (!"flora".equals(base)) continue;
            this.ignore[i] = true;
        }
    }

    protected void terminate() {
        if (this.filter != null) {
            this.space.setContactDispatcher(this.filter.getDelegate());
        } else {
            this.space.setContactDispatcher(null);
        }
    }

    private class ContactObserver
    implements ContactListener<EntityId, MBlockShape> {
        private ContactObserver() {
        }

        public void newContact(Contact<EntityId, MBlockShape> contact) {
            if (log.isTraceEnabled()) {
                log.trace("newContact(" + contact + ")");
            }
            MBlockContact mc = (MBlockContact)contact;
            if (mc.type1 > 0 && ContactSystem.this.ignore[mc.type1]) {
                mc.disable();
                return;
            }
            if (mc.type2 > 0 && ContactSystem.this.ignore[mc.type2]) {
                mc.disable();
                return;
            }
        }
    }
}

