/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.EntityData;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.Mob;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowBehavior
extends AbstractBehavior {
    static Logger log = LoggerFactory.getLogger(FollowBehavior.class);
    private EntityData ed;
    private Brain brain;
    private String defaultAction;
    private Mob follow;
    private double maxWait;
    private double timeout;
    private SteeringPrimitives.Arrive arrive;

    public FollowBehavior(EntityData ed, Brain brain, String defaultAction, double maxWait) {
        super(brain);
        this.ed = ed;
        this.brain = brain;
        this.defaultAction = defaultAction;
        this.maxWait = maxWait;
    }

    public void setFollow(Mob follow) {
        this.follow = follow;
        this.arrive = SteeringPrimitives.arrive(this.brain.getAgent(), follow.getLocation(), 1.0);
        this.timeout = this.maxWait;
        if (this.isRunning()) {
            this.brain.getAgent().setSteering(this.arrive);
        }
    }

    public Mob getFollow() {
        return this.follow;
    }

    @Override
    protected void onStart() {
        log.info("onStart()");
        this.brain.getAgent().setDefaultAction(this.defaultAction);
        if (this.arrive == null) {
            this.brain.getAgent().setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
        } else {
            this.brain.getAgent().setSteering(this.arrive);
        }
    }

    @Override
    public boolean update(long frameTime, double step) {
        if (this.follow == null) {
            return false;
        }
        this.timeout -= step;
        if (this.timeout < 0.0) {
            log.info("Got tired of following.");
            this.follow = null;
            return false;
        }
        this.brain.getAgent().setSteering(this.arrive);
        this.arrive.setTarget(this.follow.getLocation());
        return true;
    }

    @Override
    protected void onStop() {
        log.info("onStop()");
    }
}

