/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.trigger;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.DynArray;
import com.simsilica.mworld.TileId;
import com.simsilica.thread.IterationProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.OwnedBy;
import mythruna.es.StructureInfo;
import mythruna.es.TriggerActive;
import mythruna.es.TriggerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerProcessor
implements IterationProcessor {
    static Logger log = LoggerFactory.getLogger(TriggerProcessor.class);
    private EntityData ed;
    private PlayerContainer players;
    private int activationRadius = 1;
    private Map<TileId, ActiveTile> tileIndex = new HashMap<TileId, ActiveTile>();
    private DynArray<ActiveTile> activeTiles = new DynArray(ActiveTile.class);
    private Set<ActiveTile> pendingDeactivate = new HashSet<ActiveTile>();
    private Multimap<TileId, Trigger> triggerIndex = MultimapBuilder.hashKeys().hashSetValues().build();
    private int count = 0;
    private LoadingCache<List<EntityId>, EntityId> triggerActiveEntities;

    public TriggerProcessor(final EntityData ed) {
        this.ed = ed;
        this.triggerActiveEntities = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<List<EntityId>, EntityId>(){

            public EntityId load(List<EntityId> key) {
                EntityId activator = key.get(0);
                EntityId trigger = key.get(1);
                ComponentFilter<TriggerActive> filter = TriggerActive.filter(activator, trigger);
                EntityId result = ed.findEntity(filter, new Class[]{TriggerActive.class});
                if (result == null) {
                    result = ed.createEntity();
                    if (log.isTraceEnabled()) {
                        log.trace("Created TriggerActive entity:" + result + " for:" + key);
                    }
                }
                return result;
            }
        });
    }

    public void onStart() {
        this.players = new PlayerContainer(this.ed);
        this.players.start();
    }

    public void onIterate() {
        try {
            this.iterate();
        }
        catch (RuntimeException e) {
            log.error("Error during iteration", (Throwable)e);
        }
    }

    protected void iterate() {
        this.players.update();
        for (Player player : this.players.getArray()) {
            player.update();
        }
        for (ActiveTile tile : this.pendingDeactivate) {
            if (tile.useCount > 0) continue;
            this.removeTile(tile);
        }
        this.pendingDeactivate.clear();
        for (ActiveTile activeTile : (ActiveTile[])this.activeTiles.getArray()) {
            activeTile.update();
        }
        for (Player player : this.players.getArray()) {
            player.checkTriggers();
        }
    }

    public void onStop() {
        this.players.stop();
        this.players = null;
    }

    protected ActiveTile getTile(TileId tileId, boolean create) {
        ActiveTile result = this.tileIndex.get(tileId);
        if (result == null && create) {
            log.info("creating tile for:" + tileId);
            result = new ActiveTile(tileId);
            this.tileIndex.put(tileId, result);
            this.activeTiles.add((Object)result);
        }
        return result;
    }

    protected void removeTile(ActiveTile tile) {
        log.info("removing tile for:" + tile.tileId);
        this.tileIndex.remove(tile.tileId);
        this.activeTiles.remove((Object)tile);
    }

    protected void activateTile(TileId tileId) {
        log.info("activateTile(" + tileId + ")");
        tileId.visitNeighbors(this.activationRadius, neighbor -> {
            ActiveTile at = this.getTile((TileId)neighbor, true);
            at.activate();
            if (at.useCount == 1) {
                this.pendingDeactivate.remove(at);
            }
        });
    }

    protected void deactivateTile(TileId tileId) {
        log.info("deactivateTile(" + tileId + ")");
        tileId.visitNeighbors(this.activationRadius, neighbor -> {
            ActiveTile at = this.getTile((TileId)neighbor, false);
            if (at == null) {
                log.warn("No active tile found at:" + neighbor + " (" + neighbor.getWorld(null) + ") to deactivate.");
            } else {
                at.deactivate();
                if (at.useCount == 0) {
                    this.pendingDeactivate.add(at);
                }
            }
        });
    }

    protected TriggerShape createShape(SpawnPosition pos, TriggerInfo info) {
        Vec3i loc = pos.getLocation().floor();
        if (info.getZSize() == 0) {
            return new RadiusShape(loc, info.getXSize(), info.getApproachDistance());
        }
        return new BoxShape(loc, info.getSize(), info.getApproachDistance());
    }

    protected void updateTrigger(TriggerActive event) {
        List<EntityId> pair = Arrays.asList(event.getActivator(), event.getTrigger());
        EntityId entity = (EntityId)this.triggerActiveEntities.getUnchecked(pair);
        if (log.isTraceEnabled()) {
            log.trace("Updating trigger active:" + event + " for:" + entity);
        }
        this.ed.setComponent(entity, (EntityComponent)event);
    }

    protected void removeTrigger(EntityId activator, EntityId trigger) {
        List<EntityId> pair = Arrays.asList(activator, trigger);
        EntityId entity = (EntityId)this.triggerActiveEntities.getIfPresent(pair);
        if (entity != null) {
            this.ed.removeEntity(entity);
            if (log.isTraceEnabled()) {
                log.trace("Removed TriggerActive entity:" + entity + " for:" + pair);
            }
        } else {
            log.warn("Trying to remove trigger for:" + pair + " but no trigger entity exists");
        }
    }

    private class ActiveTile {
        private TileId tileId;
        private int useCount;
        private TriggerContainer triggers;

        public ActiveTile(TileId tileId) {
            this.tileId = tileId;
            this.triggers = new TriggerContainer(tileId, TriggerProcessor.this.ed);
        }

        public void activate() {
            ++this.useCount;
            if (this.useCount == 1) {
                log.info("starting trigger container for:" + this.tileId);
                this.triggers.start();
            }
        }

        public void deactivate() {
            --this.useCount;
            if (this.useCount == 0) {
                log.info("stopping trigger container for:" + this.tileId);
                this.triggers.stop();
            }
        }

        public void update() {
            if (this.useCount > 0) {
                this.triggers.update();
            }
        }
    }

    private class PlayerContainer
    extends EntityContainer<Player> {
        public PlayerContainer(EntityData ed) {
            super(ed, new Class[]{ObjectTypeInfo.class, BodyPosition.class});
            this.setFilter(ObjectTypeInfo.typeFilter("PlayerCharacter", ed));
        }

        public Player[] getArray() {
            return (Player[])super.getArray();
        }

        protected Player addObject(Entity e) {
            log.info("addObject(" + e.getId() + ")");
            Player player = new Player(e);
            this.updateObject(player, e);
            return player;
        }

        protected void updateObject(Player player, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e.getId() + ")");
            }
        }

        protected void removeObject(Player player, Entity e) {
            log.info("removeObject(" + e.getId() + ")");
            player.release();
        }
    }

    private class Player {
        private EntityId entityId;
        private BodyPosition pos;
        private Vec3i loc;
        private TileId tileId;
        private Set<Trigger> inside = new HashSet<Trigger>();
        private Set<Trigger> approaching = new HashSet<Trigger>();

        public Player(Entity entity) {
            this.entityId = entity.getId();
            this.pos = (BodyPosition)entity.get(BodyPosition.class);
        }

        protected void updateTileId(TileId tileId) {
            if (tileId == null) {
                return;
            }
            if (this.tileId != null && this.tileId.getId() == tileId.getId()) {
                return;
            }
            TileId oldTileId = this.tileId;
            this.tileId = tileId;
            TriggerProcessor.this.activateTile(tileId);
            if (oldTileId != null) {
                TriggerProcessor.this.deactivateTile(oldTileId);
            }
        }

        public void update() {
            Vec3d loc = this.pos.getLastLocation();
            if (loc == null) {
                return;
            }
            Vec3i newLoc = loc.floor();
            if (newLoc.equals((Object)loc)) {
                return;
            }
            this.loc = newLoc;
            this.updateTileId(TileId.fromWorld((double)loc.x, (double)loc.y, (double)loc.z));
        }

        public void checkTriggers() {
            HashSet<Trigger> newInside = new HashSet<Trigger>();
            HashSet<Trigger> newApproaching = new HashSet<Trigger>();
            for (Trigger trigger : TriggerProcessor.this.triggerIndex.get((Object)this.tileId)) {
                boolean isApproaching;
                boolean debug = trigger.debug;
                if (!trigger.isVisibleTo(this.entityId)) {
                    if (!debug) continue;
                    log.info("Trigger:" + trigger + " is not visible to:" + this.entityId);
                    continue;
                }
                TriggerHit hit = trigger.shape.checkHit(this.loc);
                if (debug) {
                    log.info("Checking trigger:" + trigger + "  hit:" + (Object)((Object)hit));
                }
                boolean isInside = hit == TriggerHit.Inside;
                boolean bl = isApproaching = hit == TriggerHit.Approaching;
                if (isInside && trigger.info.getApproachDistance() > 0) {
                    isApproaching = true;
                }
                if (isApproaching) {
                    newApproaching.add(trigger);
                    if (!this.approaching.remove(trigger)) {
                        log.info("TRIGGER: Approaching:" + trigger);
                        TriggerProcessor.this.updateTrigger(new TriggerActive(this.entityId, trigger.entityId, TriggerActive.Type.Approaching));
                    }
                }
                if (!isInside) continue;
                newInside.add(trigger);
                if (this.inside.remove(trigger)) continue;
                log.info("TRIGGER: Entering:" + trigger);
                TriggerProcessor.this.updateTrigger(new TriggerActive(this.entityId, trigger.entityId, TriggerActive.Type.Entered));
            }
            for (Trigger trigger : this.inside) {
                log.info("TRIGGER: Exiting:" + trigger);
                TriggerProcessor.this.updateTrigger(new TriggerActive(this.entityId, trigger.entityId, TriggerActive.Type.Exited));
                if (trigger.info.getApproachDistance() > 0) continue;
                log.info("TRIGGER: Removing because exit is also leaving:" + trigger);
                TriggerProcessor.this.removeTrigger(this.entityId, trigger.entityId);
            }
            for (Trigger trigger : this.approaching) {
                log.info("TRIGGER: Leaving:" + trigger);
                TriggerProcessor.this.removeTrigger(this.entityId, trigger.entityId);
            }
            this.inside = newInside;
            this.approaching = newApproaching;
        }

        public void release() {
            if (this.tileId != null) {
                TriggerProcessor.this.deactivateTile(this.tileId);
            }
            for (Trigger trigger : this.inside) {
                log.info("TRIGGER: release() Exiting:" + trigger);
                TriggerProcessor.this.updateTrigger(new TriggerActive(this.entityId, trigger.entityId, TriggerActive.Type.Exited));
                if (trigger.info.getApproachDistance() > 0) continue;
                log.info("TRIGGER: release() Removing because exit is also leaving:" + trigger);
                TriggerProcessor.this.removeTrigger(this.entityId, trigger.entityId);
            }
            for (Trigger trigger : this.approaching) {
                log.info("TRIGGER: release() Leaving:" + trigger);
                TriggerProcessor.this.removeTrigger(this.entityId, trigger.entityId);
            }
            this.inside.clear();
            this.approaching.clear();
        }
    }

    private class RadiusShape
    extends TriggerShape {
        private Vec3i pos;
        private int radiusSq;
        private int approachingSq;

        public RadiusShape(Vec3i pos, int radius, int approaching) {
            this.pos = pos;
            this.radiusSq = radius * radius;
            this.approachingSq = radius + approaching;
            this.approachingSq *= this.approachingSq;
            HashSet<TileId> ids = new HashSet<TileId>();
            int r = radius + approaching;
            ids.add(TileId.fromWorld((Vec3i)pos.add(r, 0, r)));
            ids.add(TileId.fromWorld((Vec3i)pos.add(-r, 0, r)));
            ids.add(TileId.fromWorld((Vec3i)pos.add(r, 0, -r)));
            ids.add(TileId.fromWorld((Vec3i)pos.add(-r, 0, -r)));
            this.setAffectedTiles(ids.toArray(new TileId[0]));
        }

        @Override
        public TriggerHit checkHit(Vec3i loc) {
            double dSq = this.pos.distanceSq(loc);
            if (this.debug) {
                log.info("shape pos:" + this.pos + " loc:" + loc + " distSq:" + dSq + " radiusSq:" + this.radiusSq);
            }
            if (dSq <= (double)this.radiusSq) {
                return TriggerHit.Inside;
            }
            if (dSq <= (double)this.approachingSq) {
                return TriggerHit.Approaching;
            }
            return TriggerHit.Outside;
        }
    }

    private class BoxShape
    extends TriggerShape {
        private Vec3i pos;
        private Vec3i size;
        private int approaching;

        public BoxShape(Vec3i pos, Vec3i size, int approaching) {
            this.pos = pos;
            this.size = size;
            this.approaching = approaching;
            HashSet<TileId> ids = new HashSet<TileId>();
            ids.add(TileId.fromWorld((Vec3i)pos.add(-approaching, 0, -approaching)));
            ids.add(TileId.fromWorld((Vec3i)pos.add(size.x + approaching, 0, -approaching)));
            ids.add(TileId.fromWorld((Vec3i)pos.add(-approaching, 0, size.z + approaching)));
            ids.add(TileId.fromWorld((Vec3i)pos.add(size.x + approaching, 0, size.z + approaching)));
            this.setAffectedTiles(ids.toArray(new TileId[0]));
        }

        @Override
        public TriggerHit checkHit(Vec3i loc) {
            if (loc.x < this.pos.x - this.approaching || loc.x > this.pos.x + this.size.x + this.approaching) {
                return TriggerHit.Outside;
            }
            if (loc.y < this.pos.y - this.approaching || loc.y > this.pos.y + this.size.y + this.approaching) {
                return TriggerHit.Outside;
            }
            if (loc.z < this.pos.z - this.approaching || loc.z > this.pos.z + this.size.z + this.approaching) {
                return TriggerHit.Outside;
            }
            if (loc.x < this.pos.x || loc.x > this.pos.x + this.size.x) {
                return TriggerHit.Approaching;
            }
            if (loc.y < this.pos.y || loc.y > this.pos.y + this.size.y) {
                return TriggerHit.Approaching;
            }
            if (loc.z < this.pos.z || loc.z > this.pos.z + this.size.z) {
                return TriggerHit.Approaching;
            }
            return TriggerHit.Inside;
        }
    }

    private class TriggerContainer
    extends EntityContainer<Trigger> {
        private TileId tileId;

        public TriggerContainer(TileId tileId, EntityData ed) {
            super(ed, new Class[]{TriggerInfo.class, SpawnPosition.class});
            this.tileId = tileId;
            this.setFilter(TriggerInfo.tileFilter(tileId));
        }

        public Trigger[] getArray() {
            return (Trigger[])super.getArray();
        }

        protected Trigger addObject(Entity e) {
            Trigger object = new Trigger(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(Trigger object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateTrigger(" + e + ")");
            }
            object.updatePosition();
        }

        protected void removeObject(Trigger object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("removeTrigger(" + e + ")");
            }
            object.release();
        }
    }

    private class Trigger {
        private EntityId entityId;
        private Entity entity;
        private SpawnPosition pos;
        private TriggerInfo info;
        private TriggerShape shape;
        private String name;
        private OwnedBy ownedBy;
        private boolean debug;

        public Trigger(Entity entity) {
            this.entityId = entity.getId();
            this.entity = entity;
        }

        public boolean isVisibleTo(EntityId entityId) {
            if (this.info.getVisibleTo() == null) {
                return true;
            }
            return this.info.getVisibleTo().getId() == entityId.getId();
        }

        public void updatePosition() {
            Name nameComponent;
            ObjectTypeInfo type;
            this.clearFromIndex();
            this.pos = (SpawnPosition)this.entity.get(SpawnPosition.class);
            this.info = (TriggerInfo)this.entity.get(TriggerInfo.class);
            this.shape = TriggerProcessor.this.createShape(this.pos, this.info);
            this.shape.debug = this.debug;
            StructureInfo si = (StructureInfo)TriggerProcessor.this.ed.getComponent(this.entity.getId(), StructureInfo.class);
            if (si != null) {
                this.name = si.getFactory(TriggerProcessor.this.ed);
            }
            if (this.name == null && (type = (ObjectTypeInfo)TriggerProcessor.this.ed.getComponent(this.entity.getId(), ObjectTypeInfo.class)) != null) {
                this.name = type.getTypeName(TriggerProcessor.this.ed);
            }
            if ((nameComponent = (Name)TriggerProcessor.this.ed.getComponent(this.entity.getId(), Name.class)) != null) {
                this.name = this.name + " name:" + nameComponent.getName();
            }
            this.ownedBy = (OwnedBy)TriggerProcessor.this.ed.getComponent(this.entity.getId(), OwnedBy.class);
            if (this.ownedBy != null) {
                this.name = this.name + " ownedBy:" + this.ownedBy.getOwner();
            }
            if (this.debug) {
                log.info("indexing:" + this);
            }
            for (TileId id : this.shape.getAffectedTiles()) {
                if (this.debug) {
                    log.info("Adding it to tile:" + id + " " + id.getWorld(null));
                }
                TriggerProcessor.this.triggerIndex.put((Object)id, (Object)this);
            }
        }

        protected void clearFromIndex() {
            if (this.shape == null) {
                return;
            }
            for (TileId id : this.shape.getAffectedTiles()) {
                TriggerProcessor.this.triggerIndex.remove((Object)id, (Object)this);
            }
        }

        public void release() {
            this.clearFromIndex();
        }

        public String toString() {
            return "Trigger[" + this.entity.getId() + "(" + this.name + ")]";
        }
    }

    private abstract class TriggerShape {
        private TileId[] affectedTiles;
        protected boolean debug;

        protected void setAffectedTiles(TileId[] affectedTiles) {
            if (affectedTiles == null) {
                throw new IllegalArgumentException("Affected tiles cannot be null");
            }
            this.affectedTiles = affectedTiles;
        }

        public TileId[] getAffectedTiles() {
            return this.affectedTiles;
        }

        public abstract TriggerHit checkHit(Vec3i var1);
    }

    private static enum TriggerHit {
        Approaching,
        Inside,
        Outside;

    }
}

