/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.simsilica.mblock.phys.MassUtils;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.DynArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group
extends Part {
    static Logger log = LoggerFactory.getLogger(Group.class);
    private DynArray<Part> children = new DynArray(Part.class);
    private DynArray<Part> traversed = null;

    public Group(String name) {
        super(name);
    }

    @Override
    public Part[] traverse() {
        if (this.traversed != null) {
            return (Part[])this.traversed.getArray();
        }
        if (this.getParent() != null) {
            throw new UnsupportedOperationException("traverse() can only be called from root part");
        }
        this.traversed = new DynArray(Part.class);
        log.info("new DynArray");
        this.addNonGroups(this.traversed, this.children);
        return (Part[])this.traversed.getArray();
    }

    protected void addNonGroups(DynArray<Part> target, DynArray<Part> source) {
        for (Part p : (Part[])source.getArray()) {
            if (p instanceof Group) {
                this.addNonGroups(target, ((Group)p).getChildren());
                continue;
            }
            target.add((Object)p);
        }
    }

    @Override
    protected void updateMass() {
        this.setMass(MassUtils.calculateBodyMass(this));
    }

    @Override
    protected void markForRefresh(int flag) {
        super.markForRefresh(flag);
        if ((flag & 2) != 0) {
            for (Part child : (Part[])this.children.getArray()) {
                child.markForRefresh(flag);
            }
        }
    }

    @Override
    protected void setParent(Group parent) {
        super.setParent(parent);
        this.traversed = null;
    }

    public void addChild(Part part) {
        if (part == null) {
            throw new IllegalArgumentException("Part cannot be null");
        }
        if (part.getParent() == this) {
            return;
        }
        if (part.getParent() != null) {
            part.getParent().removeChild(part);
        }
        this.children.add((Object)part);
        part.setParent(this);
        this.markForRefresh(1);
        this.traversed = null;
    }

    public boolean removeChild(Part part) {
        if (part == null) {
            throw new IllegalArgumentException("Part cannot be null");
        }
        if (part.getParent() != this) {
            throw new IllegalArgumentException("Part:" + part + " is not a child of:" + this);
        }
        if (this.children.remove((Object)part)) {
            part.setParent(null);
            this.markForRefresh(1);
            this.traversed = null;
            return true;
        }
        return false;
    }

    public DynArray<Part> getChildren() {
        return this.children;
    }
}

