/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

import com.google.common.base.MoreObjects;
import com.simsilica.sim.BlackboardListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blackboard {
    static Logger log = LoggerFactory.getLogger(Blackboard.class);
    private Map<Key, Object> index = new ConcurrentHashMap<Key, Object>();
    private List<BlackboardListener> listeners = new CopyOnWriteArrayList<BlackboardListener>();

    public <T> T get(Class<T> type) {
        return type.cast(this.get(new Key(type)));
    }

    public <T> T get(String id, Class<T> type) {
        return type.cast(this.get(new Key(id, type)));
    }

    public Object get(String id) {
        return this.get(new Key(id));
    }

    protected Object get(Key key) {
        Object result = this.index.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Value does not exist for:" + key);
        }
        return result;
    }

    public <T> T get(Class<T> type, Callable<T> initialValue) {
        return type.cast(this.get(new Key(type), initialValue));
    }

    public <T> T get(String id, Class<T> type, Callable<T> initialValue) {
        return type.cast(this.get(new Key(id, type), initialValue));
    }

    public <T> T get(String id, Callable<T> initialValue) {
        return (T)this.get(new Key(id), initialValue);
    }

    protected Object get(Key key, Callable initialValue) {
        Object existing = this.index.get(key);
        if (existing != null) {
            return existing;
        }
        Blackboard blackboard = this;
        synchronized (blackboard) {
            try {
                Object newValue = initialValue.call();
                existing = this.index.putIfAbsent(key, newValue);
                if (existing == null) {
                    return newValue;
                }
                return existing;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception running:" + initialValue, e);
            }
        }
    }

    public void set(String id, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.set(new Key(id), value);
    }

    public <T> void set(String id, Class<? super T> type, T value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.set(new Key(id, type), value);
    }

    public <T> void set(Class<? super T> type, T value) {
        this.set(new Key(type), value);
    }

    protected void set(Key key, Object value) {
        Object existing = this.index.get(key);
        if (existing != null && !Objects.equals(value, existing)) {
            throw new IllegalArgumentException("There is already a value set for:" + key);
        }
        this.index.put(key, value);
        this.fireUpdate(key, value);
    }

    public void update(String id, Object value) {
        this.update(new Key(id), value);
    }

    public <T> void update(String id, Class<? super T> type, T value) {
        this.update(new Key(id, type), value);
    }

    public <T> void update(Class<? super T> type, T value) {
        this.update(new Key(type), value);
    }

    protected void update(Key key, Object value) {
        if (value == null) {
            this.index.remove(key);
        } else {
            this.index.put(key, value);
        }
        this.fireUpdate(key, value);
    }

    public void addBlackboardListener(BlackboardListener l) {
        this.listeners.add(l);
    }

    public void removeBlackboardListener(BlackboardListener l) {
        this.listeners.remove(l);
    }

    public <T> Consumer<T> watch(String id, Consumer<T> consumer) {
        this.watch(new Key(id), consumer);
        return consumer;
    }

    public <T> Consumer<T> watch(String id, Class<T> type, Consumer<T> consumer) {
        this.watch(new Key(id, type), consumer);
        return consumer;
    }

    protected void watch(Key key, Consumer consumer) {
        this.listeners.add(new ValueObserver(key, consumer));
        Object existing = this.index.get(key);
        if (existing != null) {
            consumer.accept(existing);
        }
    }

    public <T> void unwatch(String id, Consumer<T> consumer) {
        this.unwatch(new Key(id), consumer);
    }

    public <T> void unwatch(String id, Class<T> type, Consumer<T> consumer) {
        this.unwatch(new Key(id, type), consumer);
    }

    protected void unwatch(Key key, Consumer consumer) {
        for (BlackboardListener l : this.listeners) {
            ValueObserver observer;
            if (!(l instanceof ValueObserver) || (observer = (ValueObserver)l).consumer != consumer || !observer.filter.equals(key)) continue;
            this.listeners.remove(l);
        }
    }

    public <T> void onInitialize(Class<T> type, Consumer<T> consumer) {
        this.onInitialize(new Key(type), consumer);
    }

    public <T> void onInitialize(String id, Class<T> type, Consumer<T> consumer) {
        this.onInitialize(new Key(id, type), consumer);
    }

    public void onInitialize(String id, Consumer consumer) {
        this.onInitialize(new Key(id), consumer);
    }

    protected void onInitialize(Key key, Consumer consumer) {
        Object existing = this.index.get(key);
        if (existing != null) {
            consumer.accept(existing);
            return;
        }
        this.addBlackboardListener(new OnInitialize(key, consumer));
    }

    protected void fireUpdate(Key key, Object value) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (BlackboardListener l : this.listeners) {
            l.valueSet(key.id, key.type, value);
        }
    }

    protected class ValueObserver
    implements BlackboardListener {
        private Key filter;
        private Consumer consumer;

        public ValueObserver(Key filter, Consumer consumer) {
            this.filter = filter;
            this.consumer = consumer;
        }

        @Override
        public void valueSet(String id, Class type, Object value) {
            if (!Objects.equals(new Key(id, type), this.filter)) {
                return;
            }
            this.consumer.accept(value);
        }
    }

    protected class OnInitialize
    implements BlackboardListener {
        private Key filter;
        private Consumer consumer;

        public OnInitialize(Key filter, Consumer consumer) {
            this.filter = filter;
            this.consumer = consumer;
        }

        @Override
        public void valueSet(String id, Class type, Object value) {
            if (!Objects.equals(new Key(id, type), this.filter)) {
                return;
            }
            this.consumer.accept(value);
            Blackboard.this.removeBlackboardListener(this);
        }
    }

    private static class Key {
        String id;
        Class type;

        public Key(Class type) {
            this(type.getName(), type);
        }

        public Key(String id) {
            this(id, Object.class);
        }

        public Key(String id, Class type) {
            this.id = id;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Key other = (Key)o;
            if (!Objects.equals(other.id, this.id)) {
                return false;
            }
            return Objects.equals(other.type, this.type);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("id", (Object)this.id).add("type", (Object)this.type).toString();
        }
    }
}

