/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Sphere;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.Frustum;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.SphereVolume;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.GameSystem;
import com.simsilica.sim.SimTime;
import mythruna.client.net.HostedGameState;
import mythruna.es.AgentType;
import mythruna.sim.ai.AgentDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeDebugState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ProbeDebugState.class);
    private EntityData ed;
    private HostedGameState host;
    private Grid grid;
    private PhysicsSpace<EntityId, MBlockShape> space;
    private AgentContainer agents;
    private AgentListenerSystem listenerSystem = new AgentListenerSystem();
    private Node objectRoot;
    private Vec3i lastCenter = new Vec3i();
    private Vec3i lastCenterWorld = new Vec3i();
    private Vec3d viewOrigin = new Vec3d();
    private Camera camera;
    private Vec3d eyeLocation = new Vec3d();

    public ProbeDebugState(HostedGameState host) {
        this.host = host;
        this.space = (PhysicsSpace)host.getSystems().get(PhysicsSpace.class);
        this.grid = this.space.getGrid();
        this.setEnabled(false);
    }

    public void setViewOrigin(double x, double y, double z) {
        this.viewOrigin.set(x, y, z);
    }

    public void setViewOrigin(Vec3d origin) {
        this.setViewOrigin(origin.x, origin.y, origin.z);
    }

    public Vec3d getViewOrigin() {
        return this.viewOrigin;
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected Camera getCamera() {
        if (this.camera == null) {
            this.camera = this.getApplication().getCamera();
        }
        return this.camera;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        this.objectRoot = new Node("objectRoot");
        this.ed = (EntityData)this.host.getSystems().get(EntityData.class);
        this.agents = new AgentContainer(this.ed);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.agents.start();
        this.host.getSystems().addSystem((GameSystem)this.listenerSystem);
        this.getRoot().attachChild((Spatial)this.objectRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(float tpf) {
        this.updateCenter();
        AgentContainer agentContainer = this.agents;
        synchronized (agentContainer) {
            this.agents.update();
            for (ProbeDebugView view : this.agents.getArray()) {
                view.updatePosition();
            }
        }
    }

    protected void updateCenter() {
        Vector3f cameraPos = this.getCamera().getLocation();
        Vec3d world = this.viewOrigin.add(new Vec3d(cameraPos));
        this.eyeLocation.set(world);
        Vec3i center = this.grid.worldToCell(world.x, 0.0, world.z);
        if (!center.equals((Object)this.lastCenter)) {
            this.lastCenter.set(center);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDisable() {
        this.agents.stop();
        this.host.getSystems().removeSystem((GameSystem)this.listenerSystem);
        this.objectRoot.removeFromParent();
        AgentContainer agentContainer = this.agents;
        synchronized (agentContainer) {
            for (ProbeDebugView view : this.agents.getArray()) {
                view.release();
            }
        }
    }

    private class AgentContainer
    extends EntityContainer<ProbeDebugView> {
        public AgentContainer(EntityData ed) {
            super(ed, new Class[]{AgentType.class});
        }

        protected ProbeDebugView[] getArray() {
            return (ProbeDebugView[])super.getArray();
        }

        protected ProbeDebugView addObject(Entity e) {
            log.info("addObject(" + e + ")");
            ProbeDebugView object = new ProbeDebugView(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(ProbeDebugView object, Entity e) {
            log.info("updateObject(" + object + ", " + e + ")");
        }

        protected void removeObject(ProbeDebugView object, Entity e) {
            log.info("removeObject(" + object + ", " + e + ")");
            object.release();
        }
    }

    private class AgentListenerSystem
    extends AbstractGameSystem {
        private AgentListenerSystem() {
        }

        protected void initialize() {
        }

        protected void terminate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(SimTime time) {
            AgentContainer agentContainer = ProbeDebugState.this.agents;
            synchronized (agentContainer) {
                for (ProbeDebugView view : ProbeDebugState.this.agents.getArray()) {
                    view.acquire();
                }
            }
        }
    }

    private class ProbeDebugView {
        private Entity entity;
        private RigidBody<EntityId, MBlockShape> body;
        private AgentDriver driver;
        private Vec3d pos = new Vec3d();
        private Quatd orient = new Quatd();
        private Node view;
        private Node orientedView;
        private Sphere probeSphere;
        private Geometry probeGeom;
        private Frustum frustum;
        private Geometry frustumGeom;
        private Mesh frustumMesh;
        private SphereVolume perception;
        private Sphere perceptionMesh;
        private Geometry perceptionGeom;

        public ProbeDebugView(Entity entity) {
            this.entity = entity;
            this.view = new Node("probeDebug:" + entity.getId());
            this.probeSphere = new Sphere(6, 8, 0.25f);
            this.probeGeom = new Geometry("probeDebug:" + entity.getId(), (Mesh)this.probeSphere);
            this.probeGeom.setMaterial(GuiGlobals.getInstance().createMaterial(new ColorRGBA(1.0f, 0.0f, 0.0f, 0.25f), true).getMaterial());
            this.probeGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
            this.probeGeom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            this.orientedView = new Node();
            this.view.attachChild((Spatial)this.orientedView);
            this.orientedView.attachChild((Spatial)this.probeGeom);
        }

        public void acquire() {
            if (this.driver != null) {
                return;
            }
            this.body = ProbeDebugState.this.space.getBinIndex().getRigidBody((Object)this.entity.getId());
            if (this.body == null) {
                return;
            }
            this.driver = (AgentDriver)this.body.getControlDriver();
            if (this.driver == null) {
                log.warn("No driver yet for:" + this.entity);
                return;
            }
            log.info("Got driver:" + this.driver + " for:" + this.entity);
            Vec3d offset = this.driver.getProbeOffset();
            this.probeGeom.setLocalTranslation(offset.toVector3f());
            double radius = this.driver.getProbeRadius();
            this.probeSphere.updateGeometry(6, 8, (float)radius);
            this.perception = this.driver.getPersonalSpaceVolume();
            if (this.perception != null) {
                this.perceptionMesh = new Sphere(6, 8, (float)this.perception.getRadius());
                this.perceptionGeom = new Geometry("perceptionDebug:" + this.entity.getId(), (Mesh)this.perceptionMesh);
                this.perceptionGeom.setMaterial(GuiGlobals.getInstance().createMaterial(new ColorRGBA(0.1f, 1.0f, 0.1f, 0.25f), false).getMaterial());
                this.perceptionGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
                this.perceptionGeom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                this.perceptionGeom.getMaterial().getAdditionalRenderState().setWireframe(true);
                this.orientedView.attachChild((Spatial)this.perceptionGeom);
            }
            this.frustum = this.driver.getSightVolume();
            if (this.frustum != null) {
                double yFov = this.frustum.getVerticalFov() * 0.5;
                double xFov = this.frustum.getHorizontalFov() * 0.5;
                Vec3d cornerOffset = new Vec3d();
                cornerOffset.z = this.frustum.getFar();
                cornerOffset.x = Math.tan(xFov) * cornerOffset.z;
                cornerOffset.y = Math.tan(yFov) * cornerOffset.z;
                Vector3f ul = cornerOffset.toVector3f();
                Vector3f ur = new Vector3f(-ul.x, ul.y, ul.z);
                Vector3f ll = new Vector3f(ul.x, -ul.y, ul.z);
                Vector3f lr = new Vector3f(-ul.x, -ul.y, ul.z);
                Mesh mesh = new Mesh();
                mesh.setMode(Mesh.Mode.Lines);
                mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, ul.x, ul.y, ul.z, 0.0f, 0.0f, 0.0f, ur.x, ur.y, ur.z, 0.0f, 0.0f, 0.0f, ll.x, ll.y, ll.z, 0.0f, 0.0f, 0.0f, lr.x, lr.y, lr.z, ul.x, ul.y, ul.z, ur.x, ur.y, ur.z, ur.x, ur.y, ur.z, lr.x, lr.y, lr.z, lr.x, lr.y, lr.z, ll.x, ll.y, ll.z, ll.x, ll.y, ll.z, ul.x, ul.y, ul.z});
                mesh.updateBound();
                this.frustumGeom = new Geometry(this.body.id + ".frustum", mesh);
                this.frustumGeom.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.Red, false).getMaterial());
                Vec3d local = this.body.worldToLocal(this.frustum.getPosition(), null);
                this.frustumGeom.setLocalTranslation(local.toVector3f());
                this.frustumGeom.setLocalRotation(this.frustum.getOrientation().toQuaternion());
                this.frustumGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
                this.frustumGeom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                this.orientedView.attachChild((Spatial)this.frustumGeom);
            }
        }

        public void release() {
            this.view.removeFromParent();
        }

        public void updatePosition() {
            Vec3d local;
            if (this.driver == null) {
                return;
            }
            if (this.view.getParent() == null) {
                log.info("attaching debug view for:" + this.entity);
                ProbeDebugState.this.objectRoot.attachChild((Spatial)this.view);
            }
            this.pos.set(this.body.position);
            this.orient.set(this.body.orientation);
            float x = (float)(this.pos.x - ((ProbeDebugState)ProbeDebugState.this).viewOrigin.x);
            float y = (float)(this.pos.y - ((ProbeDebugState)ProbeDebugState.this).viewOrigin.y);
            float z = (float)(this.pos.z - ((ProbeDebugState)ProbeDebugState.this).viewOrigin.z);
            this.view.setLocalTranslation(x, y, z);
            this.orientedView.setLocalRotation(this.orient.toQuaternion());
            if (this.frustum != null) {
                local = this.body.worldToLocal(this.frustum.getPosition(), null);
                Quatd rot = this.body.orientation.inverse().mult(this.frustum.getOrientation());
                this.frustumGeom.setLocalTranslation(local.toVector3f());
                this.frustumGeom.setLocalRotation(rot.toQuaternion());
            }
            if (this.perception != null) {
                if (Math.abs(this.perception.getRadius() - (double)this.perceptionMesh.getRadius()) > 1.0E-4) {
                    this.perceptionMesh.updateGeometry(6, 8, (float)this.perception.getRadius());
                    this.perceptionMesh.updateBound();
                    this.perceptionGeom.updateModelBound();
                }
                local = this.body.worldToLocal(this.perception.getPosition(), null);
                this.perceptionGeom.setLocalTranslation(local.toVector3f());
            }
        }
    }
}

