/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import java.util.Objects;
import mythruna.client.view.object.Model;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModel
implements Model {
    private static Logger log = LoggerFactory.getLogger(AbstractModel.class);
    private EntityId entityId;
    private ShapeName shapeName;
    private ShapeInfo shapeInfo;
    private VersionedHolder<Spatial> spatialHolder = new VersionedHolder();

    protected AbstractModel(EntityId entityId, ShapeName shapeName, ShapeInfo shapeInfo) {
        this.entityId = entityId;
        this.shapeName = shapeName;
        this.shapeInfo = shapeInfo;
    }

    @Override
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Override
    public ShapeName getShapeName() {
        return this.shapeName;
    }

    @Override
    public ShapeInfo getShapeInfo() {
        return this.shapeInfo;
    }

    @Override
    public void updateAddOns(ShapeName shapeName) {
        if (Objects.equals(this.shapeName, shapeName)) {
            return;
        }
        log.info("update addOns(" + shapeName.getAddOns());
        this.shapeName = shapeName;
        this.onAddOnUpdate(shapeName);
    }

    protected void onAddOnUpdate(ShapeName shapeName) {
    }

    protected void updateSpatial(Spatial spatial) {
        this.spatialHolder.setObject((Object)spatial);
    }

    protected VersionedHolder<Spatial> getSpatialHolder() {
        return this.spatialHolder;
    }

    @Override
    public VersionedReference<Spatial> createSpatialRef() {
        return this.spatialHolder.createReference();
    }

    @Override
    public Spatial getSpatial() {
        return (Spatial)this.spatialHolder.getObject();
    }

    @Override
    public void setVisible(boolean visible) {
        Spatial s = (Spatial)this.spatialHolder.getObject();
        if (s == null) {
            return;
        }
        if (visible) {
            s.setCullHint(Spatial.CullHint.Inherit);
        } else {
            s.setCullHint(Spatial.CullHint.Never);
        }
    }

    @Override
    public abstract void setLighting(int var1);

    @Override
    public void updateRelativePosition(Vector3f pos, Quaternion rot) {
        Spatial s = (Spatial)this.spatialHolder.getObject();
        if (s == null) {
            return;
        }
        s.setLocalTranslation(pos);
        s.setLocalRotation(rot);
    }

    @Override
    public abstract Vec3d getCenterOffset();

    @Override
    public void attachChild(Spatial child) {
        Spatial s = (Spatial)this.spatialHolder.getObject();
        if (!(s instanceof Node)) {
            return;
        }
        ((Node)s).attachChild(child);
    }

    @Override
    public void removeFromParent() {
        Spatial s = (Spatial)this.spatialHolder.getObject();
        if (s == null) {
            return;
        }
        s.removeFromParent();
    }

    @Override
    public void release() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[entityId:" + this.entityId + "]";
    }
}

