/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Map;

public class SkeletonWire
extends Mesh {
    private int numConnections;
    private Skeleton skeleton;
    private Map<Integer, Float> boneLengths;

    public SkeletonWire(Skeleton skeleton) {
        this(skeleton, null);
    }

    public SkeletonWire(Skeleton skeleton, Map<Integer, Float> boneLengths) {
        this.skeleton = skeleton;
        for (Bone bone : skeleton.getRoots()) {
            this.countConnections(bone);
        }
        this.setMode(Mesh.Mode.Lines);
        int lineVerticesCount = skeleton.getBoneCount();
        if (boneLengths != null) {
            this.boneLengths = boneLengths;
            lineVerticesCount *= 2;
        }
        VertexBuffer pb = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer fpb = BufferUtils.createFloatBuffer(lineVerticesCount * 3);
        pb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, fpb);
        this.setBuffer(pb);
        VertexBuffer ib = new VertexBuffer(VertexBuffer.Type.Index);
        ShortBuffer sib = BufferUtils.createShortBuffer(boneLengths != null ? lineVerticesCount : this.numConnections * 2);
        ib.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.UnsignedShort, sib);
        this.setBuffer(ib);
        if (boneLengths != null) {
            for (int i = 0; i < lineVerticesCount; ++i) {
                sib.put((short)i);
            }
        } else {
            for (Bone bone : skeleton.getRoots()) {
                this.writeConnections(sib, bone);
            }
        }
        sib.flip();
        this.updateCounts();
    }

    public void updateGeometry() {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer posBuf = this.getFloatBuffer(VertexBuffer.Type.Position);
        posBuf.clear();
        for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
            Bone bone = this.skeleton.getBone(i);
            Vector3f head = bone.getModelSpacePosition();
            posBuf.put(head.getX()).put(head.getY()).put(head.getZ());
            if (this.boneLengths == null) continue;
            Vector3f tail = head.add(bone.getModelSpaceRotation().mult(Vector3f.UNIT_Y.mult(this.boneLengths.get(i).floatValue())));
            posBuf.put(tail.getX()).put(tail.getY()).put(tail.getZ());
        }
        posBuf.flip();
        vb.updateData(posBuf);
        this.updateBound();
    }

    private void countConnections(Bone bone) {
        for (Bone child : bone.getChildren()) {
            ++this.numConnections;
            this.countConnections(child);
        }
    }

    private void writeConnections(ShortBuffer indexBuf, Bone bone) {
        for (Bone child : bone.getChildren()) {
            indexBuf.put((short)this.skeleton.getBoneIndex(bone));
            indexBuf.put((short)this.skeleton.getBoneIndex(child));
            this.writeConnections(indexBuf, child);
        }
    }
}

