/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

public enum Resolution {
    High(1024),
    Medium(128),
    Low(64);

    private int size;

    private Resolution(int size) {
        this.size = size;
    }

    public static Resolution fromSamples(int samples) {
        for (Resolution res : Resolution.values()) {
            if (res.getSamples() != samples) continue;
            return res;
        }
        throw new IllegalArgumentException("Invalid samples:" + samples);
    }

    public int getSamples() {
        return this.size;
    }

    public boolean isLowerThan(Resolution res) {
        return this.size < res.size;
    }

    public Resolution getLowerResolution() {
        switch (this) {
            case High: {
                return Medium;
            }
            case Medium: {
                return Low;
            }
            case Low: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unhandled resolution:" + (Object)((Object)this));
    }

    public Resolution[] affectedResolutions() {
        switch (this) {
            case High: {
                return Resolution.values();
            }
            case Medium: {
                return new Resolution[]{Medium, Low};
            }
            case Low: {
                return new Resolution[]{Low};
            }
        }
        throw new UnsupportedOperationException("Unhandled resolution:" + (Object)((Object)this));
    }
}

