/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mythruna.world.cave.CaveEdge;
import mythruna.world.cave.CaveNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveGraph
implements Serializable {
    static Logger log = LoggerFactory.getLogger(CaveGraph.class);
    private static final long serialVersionUID = 42L;
    private Set<CaveNode> nodes = new HashSet<CaveNode>();
    private SetMultimap<CaveNode, CaveEdge> inEdges = MultimapBuilder.hashKeys().hashSetValues().build();
    private SetMultimap<CaveNode, CaveEdge> outEdges = MultimapBuilder.hashKeys().hashSetValues().build();

    public boolean addNode(CaveNode node) {
        return this.nodes.add(node);
    }

    public void addEdge(CaveEdge edge) {
        this.addNode(edge.getEnd1());
        this.addNode(edge.getEnd2());
        this.outEdges.put((Object)edge.getEnd1(), (Object)edge);
        this.inEdges.put((Object)edge.getEnd2(), (Object)edge);
    }

    public Set<CaveNode> getNodes() {
        return this.nodes;
    }

    public Collection<CaveEdge> getEdges() {
        return this.inEdges.values();
    }

    public Set<CaveEdge> outEdges(CaveNode node) {
        return this.outEdges.get((Object)node);
    }

    public Set<CaveEdge> inEdges(CaveNode node) {
        return this.inEdges.get((Object)node);
    }

    public Set<CaveEdge> incident(CaveNode node) {
        Set<CaveEdge> set1 = this.outEdges(node);
        Set<CaveEdge> set2 = this.inEdges(node);
        if (set1.size() < set2.size()) {
            return Sets.union(set1, set2);
        }
        return Sets.union(set2, set1);
    }
}

