/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class BufferedHashSet<E>
implements Set<E> {
    private HashSet<E> buffer = new HashSet();
    private volatile HashSet<E> delegate = new HashSet();
    private Thread writer = null;

    private boolean checkThread() {
        if (this.writer == null) {
            this.writer = Thread.currentThread();
            return true;
        }
        return this.writer == Thread.currentThread();
    }

    private String badThreadMessage() {
        return "Non-write thread:" + Thread.currentThread() + " accessing as writer:" + this.writer;
    }

    public Set<E> getTransaction() {
        assert (this.checkThread()) : this.badThreadMessage();
        return this.buffer;
    }

    public void commit() {
        assert (this.checkThread()) : this.badThreadMessage();
        this.delegate = this.buffer;
        this.buffer = (HashSet)this.delegate.clone();
    }

    public Set<E> getSnapshot() {
        return Collections.unmodifiableSet(this.delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(E e) {
        assert (this.checkThread()) : this.badThreadMessage();
        return this.buffer.add(e);
    }

    @Override
    public boolean remove(Object o) {
        assert (this.checkThread()) : this.badThreadMessage();
        return this.buffer.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.buffer.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        assert (this.checkThread()) : this.badThreadMessage();
        return this.buffer.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        assert (this.checkThread()) : this.badThreadMessage();
        return this.buffer.removeAll(c);
    }

    @Override
    public void clear() {
        assert (this.checkThread()) : this.badThreadMessage();
        this.buffer.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BufferedHashSet other = (BufferedHashSet)o;
        return Objects.equals(this.delegate, other.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

