/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.google.common.base.Joiner;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.filter.AndFilter;
import com.simsilica.es.filter.FieldFilter;
import com.simsilica.es.filter.OrFilter;
import com.simsilica.es.sql.DefaultComponentFactory;
import com.simsilica.es.sql.FieldType;
import com.simsilica.es.sql.SqlComponentFactory;
import com.simsilica.es.sql.SqlSession;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTable<T extends EntityComponent> {
    static Logger log = LoggerFactory.getLogger(ComponentTable.class);
    private final boolean cached = true;
    private final SqlComponentFactory<T> componentFactory;
    private final FieldType[] fields;
    private final String tableName;
    private String[] dbFieldNames;
    private final String insertSql;
    private final String updateSql;

    protected ComponentTable(Class<T> type, SqlComponentFactory<T> factory) {
        this.componentFactory = factory;
        this.fields = factory.getFieldTypes();
        this.tableName = type.getSimpleName().toUpperCase();
        ArrayList<String> names = new ArrayList<String>();
        for (FieldType t : this.fields) {
            t.addFields("", names);
        }
        this.dbFieldNames = new String[names.size()];
        this.dbFieldNames = names.toArray(this.dbFieldNames);
        this.insertSql = this.createInsertSql();
        this.updateSql = this.createUpdateSql();
    }

    public static <T extends EntityComponent> ComponentTable<T> create(SqlSession session, Class<T> type) throws SQLException {
        ComponentTable<T> result = new ComponentTable<T>(type, new DefaultComponentFactory<T>(type));
        result.initialize(session);
        return result;
    }

    protected String createUpdateSql() {
        StringBuilder sql = new StringBuilder("UPDATE " + this.tableName);
        sql.append(" SET (");
        Joiner.on((String)", ").appendTo(sql, (Object[])this.dbFieldNames);
        sql.append(")");
        sql.append(" = ");
        sql.append("(");
        for (int i = 0; i < this.dbFieldNames.length; ++i) {
            sql.append((i > 0 ? ", " : "") + "?");
        }
        sql.append(")");
        sql.append(" WHERE entityId = ?");
        return sql.toString();
    }

    protected String createInsertSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.tableName);
        sql.append(" (");
        Joiner.on((String)", ").appendTo(sql, (Object[])this.dbFieldNames);
        if (this.dbFieldNames.length > 0) {
            sql.append(", ");
        }
        sql.append("entityId");
        sql.append(")");
        sql.append(" VALUES ");
        sql.append("(");
        for (int i = 0; i < this.dbFieldNames.length; ++i) {
            sql.append((i > 0 ? ", " : "") + "?");
        }
        if (this.dbFieldNames.length > 0) {
            sql.append(", ");
        }
        sql.append("?");
        sql.append(")");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(SqlSession session) throws SQLException {
        DatabaseMetaData md = session.getConnection().getMetaData();
        log.info("Checking for table:" + this.tableName);
        HashMap<String, Integer> dbFields = new HashMap<String, Integer>();
        try (ResultSet rs = md.getColumns(null, "PUBLIC", this.tableName, null);){
            while (rs.next()) {
                if (log.isTraceEnabled()) {
                    log.trace(rs.getString("TABLE_NAME") + " :" + rs.getString("COLUMN_NAME"));
                }
                dbFields.put(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("TABLE:" + this.tableName);
            for (Map.Entry entry : dbFields.entrySet()) {
                log.trace("    " + entry);
            }
        }
        rs = md.getIndexInfo(null, "PUBLIC", this.tableName, false, false);
        HashSet<String> indexedFields = new HashSet<String>();
        try {
            while (rs.next()) {
                indexedFields.add(rs.getString("COLUMN_NAME"));
            }
        }
        finally {
            rs.close();
        }
        if (log.isTraceEnabled()) {
            log.trace("INDEXED FIELDS:");
            for (String string : indexedFields) {
                log.trace("    " + string);
            }
        }
        LinkedHashMap<String, FieldType> linkedHashMap = new LinkedHashMap<String, FieldType>();
        for (FieldType t : this.fields) {
            t.addFieldDefinitions("", linkedHashMap);
        }
        if (!dbFields.isEmpty()) {
            dbFields.remove("ENTITYID");
            this.checkStructure(session, this.tableName, linkedHashMap, dbFields, indexedFields);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("CREATE");
        stringBuilder.append(" CACHED");
        stringBuilder.append(" TABLE");
        stringBuilder.append(" " + this.tableName + "\n");
        stringBuilder.append("(\n");
        stringBuilder.append("  entityId BIGINT PRIMARY KEY");
        for (Map.Entry e : linkedHashMap.entrySet()) {
            stringBuilder.append(",\n  " + (String)e.getKey() + " " + ((FieldType)e.getValue()).getDbType());
        }
        stringBuilder.append("\n)");
        log.info("Create statement:\n" + stringBuilder);
        Statement st = session.getConnection().createStatement();
        int i = st.executeUpdate(stringBuilder.toString());
        st.close();
        log.info("Result:" + i);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (!((FieldType)entry.getValue()).isIndexed()) continue;
            this.createIndex(session, this.tableName, (String)entry.getKey());
        }
    }

    protected void createIndex(SqlSession session, String tableName, String column) throws SQLException {
        log.info("creating index for:" + tableName + " column:" + column);
        StringBuilder sb = new StringBuilder("CREATE");
        sb.append(" INDEX");
        sb.append(" " + tableName + "_" + column + "_IDX");
        sb.append(" ON " + tableName);
        sb.append(" (" + column + ")");
        log.info("Create index statement:" + sb);
        Statement st = session.getConnection().createStatement();
        int i = st.executeUpdate(sb.toString());
        st.close();
        log.info("Result:" + i);
    }

    protected void checkStructure(SqlSession session, String tableName, Map<String, FieldType> defs, Map<String, Integer> dbFields, Set<String> indexedFields) throws SQLException {
        log.info("Table fields:" + dbFields);
        log.info("Object fields:" + defs);
        HashSet<String> newFields = new HashSet<String>();
        HashSet<String> removedFields = new HashSet<String>();
        HashSet newIndex = new HashSet();
        for (String string : dbFields.keySet()) {
            if (defs.containsKey(string)) continue;
            removedFields.add(string);
        }
        for (String string : defs.keySet()) {
            if (dbFields.containsKey(string)) continue;
            newFields.add(string);
        }
        for (Map.Entry entry : dbFields.entrySet()) {
            FieldType ft = defs.get(entry.getKey());
            if (ft != null) continue;
        }
        for (Map.Entry entry : defs.entrySet()) {
            if (!((FieldType)entry.getValue()).isIndexed() || indexedFields.contains(entry.getKey())) continue;
            newIndex.add(entry.getKey());
        }
        log.info("New fields:" + newFields);
        log.info("Removed fields:" + removedFields);
        log.info("New index fields:" + newIndex);
        if (!newIndex.isEmpty()) {
            for (String string : newIndex) {
                this.createIndex(session, tableName, string);
            }
        }
        if (newFields.isEmpty() && removedFields.isEmpty()) {
            return;
        }
        if (!newFields.isEmpty() || !removedFields.isEmpty()) {
            throw new RuntimeException("Schema mismatch, table fields:" + dbFields + " object fields:" + defs.keySet());
        }
    }

    protected FieldType getFieldType(String field) {
        for (FieldType t : this.fields) {
            if (!t.getFieldName().equals(field)) continue;
            return t;
        }
        return null;
    }

    public void setComponent(SqlSession session, EntityId entityId, T component) throws SQLException {
        int result;
        int index;
        PreparedStatement st;
        if (this.fields.length > 0) {
            st = session.prepareStatement(this.updateSql);
            index = 1;
            for (FieldType t : this.fields) {
                index = t.store(component, st, index);
            }
            st.setObject(index++, entityId.getId());
            result = st.executeUpdate();
            if (result > 0) {
                return;
            }
        }
        st = session.prepareStatement(this.insertSql);
        index = 1;
        for (FieldType t : this.fields) {
            index = t.store(component, st, index);
        }
        st.setObject(index++, entityId.getId());
        result = st.executeUpdate();
    }

    public boolean removeComponent(SqlSession session, EntityId entityId) throws SQLException {
        String sql = "DELETE FROM " + this.tableName + " WHERE entityId=" + entityId.getId();
        PreparedStatement st = session.prepareStatement(sql.toString());
        int result = st.executeUpdate();
        return result > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getComponent(SqlSession session, EntityId entityId) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.dbFieldNames.length > 0) {
            Joiner.on((String)", ").appendTo(sql, (Object[])this.dbFieldNames);
        } else {
            sql.append("entityId");
        }
        sql.append(" FROM " + this.tableName);
        sql.append(" WHERE entityId=?");
        PreparedStatement st = session.prepareStatement(sql.toString());
        st.setObject(1, entityId.getId());
        try (ResultSet rs = st.executeQuery();){
            if (rs.next()) {
                EntityComponent entityComponent = (EntityComponent)this.componentFactory.createComponent(rs);
                return (T)entityComponent;
            }
            T t = null;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntityId> getEntityIds(SqlSession session) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(" entityId");
        sql.append(" FROM " + this.tableName);
        HashSet<EntityId> results = new HashSet<EntityId>();
        PreparedStatement st = session.prepareStatement(sql.toString());
        try (ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                Long entityId = rs.getLong(1);
                results.add(new EntityId(entityId));
            }
        }
        return results;
    }

    protected int appendFilter(FieldFilter f, StringBuilder where, List<Object> parms) {
        Object dbValue;
        FieldType ft = this.getFieldType(f.getFieldName());
        if (where.length() > 0) {
            where.append(" AND ");
        }
        if ((dbValue = ft.toDbValue(f.getValue())) == null) {
            where.append(f.getFieldName() + " IS NULL");
        } else {
            where.append(f.getFieldName() + " = ?");
            parms.add(dbValue);
        }
        return 1;
    }

    protected int appendFilter(OrFilter f, StringBuilder where, List<Object> parms) {
        if (where.length() > 0) {
            where.append(" AND ");
        }
        int count = 0;
        StringBuilder sub = new StringBuilder();
        for (ComponentFilter op : f.getOperands()) {
            int nested;
            if (count > 0) {
                where.append(" OR ");
            }
            if ((nested = this.appendFilter(op, sub, parms)) > 1) {
                where.append("(" + sub + ")");
            } else {
                where.append((CharSequence)sub);
            }
            sub.setLength(0);
            count += nested;
        }
        return count;
    }

    protected int appendFilter(AndFilter f, StringBuilder where, List<Object> parms) {
        if (where.length() > 0) {
            where.append(" AND ");
        }
        int count = 0;
        StringBuilder sub = new StringBuilder();
        for (ComponentFilter op : f.getOperands()) {
            int nested;
            if (count > 0) {
                where.append(" AND ");
            }
            if ((nested = this.appendFilter(op, sub, parms)) > 1) {
                where.append("(" + sub + ")");
            } else {
                where.append((CharSequence)sub);
            }
            sub.setLength(0);
            count += nested;
        }
        return count;
    }

    protected int appendFilter(ComponentFilter f, StringBuilder where, List<Object> parms) {
        if (f instanceof FieldFilter) {
            return this.appendFilter((FieldFilter)f, where, parms);
        }
        if (f instanceof OrFilter) {
            return this.appendFilter((OrFilter)f, where, parms);
        }
        if (f instanceof AndFilter) {
            return this.appendFilter((AndFilter)f, where, parms);
        }
        throw new IllegalArgumentException("Cannot handle filter:" + f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntityId> getEntityIds(SqlSession session, ComponentFilter filter) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(" entityId");
        sql.append(" FROM " + this.tableName);
        ArrayList<Object> parms = new ArrayList<Object>();
        StringBuilder where = new StringBuilder();
        this.appendFilter(filter, where, parms);
        if (where.length() > 0) {
            sql.append(" WHERE " + where);
        }
        try {
            PreparedStatement st = session.prepareStatement(sql.toString());
            int index = 1;
            for (Object e : parms) {
                st.setObject(index++, e);
            }
            HashSet<EntityId> results = new HashSet<EntityId>();
            try (ResultSet resultSet = st.executeQuery();){
                while (resultSet.next()) {
                    Long entityId = resultSet.getLong(1);
                    results.add(new EntityId(entityId));
                }
            }
            return results;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing sql:" + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityId getEntityId(SqlSession session, ComponentFilter filter) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(" entityId");
        sql.append(" FROM " + this.tableName);
        ArrayList<Object> parms = new ArrayList<Object>();
        StringBuilder where = new StringBuilder();
        this.appendFilter(filter, where, parms);
        if (where.length() > 0) {
            sql.append(" WHERE " + where);
        }
        PreparedStatement st = session.prepareStatement(sql.toString());
        int index = 1;
        for (Object e : parms) {
            st.setObject(index++, e);
        }
        try (ResultSet rs = st.executeQuery();){
            if (rs.next()) {
                Long l = rs.getLong(1);
                EntityId entityId = new EntityId(l);
                return entityId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Map.Entry<EntityId, T>> components(SqlSession session) throws SQLException {
        ArrayList<ComponentReference<EntityComponent>> results = new ArrayList<ComponentReference<EntityComponent>>();
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.dbFieldNames.length > 0) {
            Joiner.on((String)", ").appendTo(sql, (Object[])this.dbFieldNames);
            sql.append(", entityId");
        } else {
            sql.append("entityId");
        }
        sql.append(" FROM " + this.tableName);
        PreparedStatement st = session.prepareStatement(sql.toString());
        try (ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                EntityComponent target = (EntityComponent)this.componentFactory.createComponent(rs);
                Long entityId = rs.getLong("entityId");
                results.add(new ComponentReference<EntityComponent>(new EntityId(entityId), target));
            }
        }
        return results.iterator();
    }

    private class ComponentReference<T>
    implements Map.Entry<EntityId, T> {
        private EntityId entityId;
        private T component;

        public ComponentReference(EntityId entityId, T component) {
            this.entityId = entityId;
            this.component = component;
        }

        @Override
        public EntityId getKey() {
            return this.entityId;
        }

        @Override
        public T getValue() {
            return this.component;
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException("Cannot set the component on a reference.");
        }
    }
}

