/*
 * $Id$
 *
 * Copyright (c) 2024, Simsilica, LLC
 * All rights reserved.
 */

package mythruna.triggers;

// Predefined triggers for world-generated structures

// A trigger type that will announce when players approach/enter/exit/etc.
createType("AnnounceTrigger").with {

    // The triggering entity is passed along in case it's not the player
    // someday.
    addAction("onTriggerApproached") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerApproached() self:" + self.name);
        echo("You are approaching " + self.name);
        return true;
    }

    addAction("onTriggerEntered") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerEntered() self:" + self.name);
        echo("You have entered " + self.name);
        return true;
    }

    addAction("onTriggerExited") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerExited() self:" + self.name);
        echo("You have exited " + self.name);
        return true;
    }

    addAction("onTriggerLeft") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerLeft() self:" + self.name);
        echo("You are leaving " + self.name);
        return true;
    }
}

createType("Town").with {
    supertypes("AnnounceTrigger");

    addGetter("name") { ->
        def n = self[Name];
        if( n != null ) {
            return n.getName();
        }
        def on = self[ObjectName];
        if( on != null ) {
            return on.getName(entityData);
        }
        return "Entity@" + self?.getId();
    }

    addAction("onTriggerApproached") { EntityId mob ->
        // For the time being, let's create a quest-giver NPC in
        // every town we visit
        superRun(mob);
        //townApproached.call(session, self, mob);
        generateTownQuestGiver(self);
    }
}

createType("PoiLimits").with {

    addGetter("name") { ->
        def parent = self[StructureInfo]?.parentId;
        if( parent ) {
            return "Boundary for:" + parent.name;
        }
        def n = self[Name];
        if( n != null ) {
            return n.getName();
        }
        def on = self[ObjectName];
        if( on != null ) {
            return on.getName(entityData);
        }
        return "Entity@" + self?.getId();
    }

    addAction("onTriggerApproached") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerApproached() self:" + self.name);
        // Notify the owner if it has one
        def owner = self[OwnedBy]?.owner;
        if( owner ) {
            return owner.runIfExists("onTriggerApproached", mob);
        }
        return false;
    }

    addAction("onTriggerEntered") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerEntered() self:" + self.name);
        // Notify the owner if it has one
        def owner = self[OwnedBy]?.owner;
        if( owner ) {
            return owner.runIfExists("onTriggerEntered", mob);
        }
        return false;
    }

    addAction("onTriggerExited") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerExited() self:" + self.name);
        // Notify the owner if it has one
        def owner = self[OwnedBy]?.owner;
        if( owner ) {
            return owner.runIfExists("onTriggerExited", mob);
        }
        return false;
    }

    addAction("onTriggerLeft") { EntityId mob ->
log.info("TriggerProcessor test: onTriggerLeft() self:" + self.name);
        // Notify the owner if it has one
        def owner = self[OwnedBy]?.owner;
        if( owner ) {
            return owner.runIfExists("onTriggerLeft", mob);
        }
        return false;
    }

}

