/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.core.AbstractGuiControlListener;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;

public class Slider
extends Panel {
    public static final String ELEMENT_ID = "slider";
    public static final String UP_ID = "up.button";
    public static final String DOWN_ID = "down.button";
    public static final String LEFT_ID = "left.button";
    public static final String RIGHT_ID = "right.button";
    public static final String THUMB_ID = "thumb.button";
    public static final String RANGE_ID = "range";
    private BorderLayout layout;
    private Axis axis;
    private Button increment;
    private Button decrement;
    private Panel range;
    private Button thumb;
    private RangedValueModel model;
    private double delta = 1.0;
    private VersionedReference<Double> state;

    public Slider() {
        this(new DefaultRangedValueModel(), Axis.X, true, new ElementId(ELEMENT_ID), null);
    }

    public Slider(Axis axis) {
        this(new DefaultRangedValueModel(), axis, true, new ElementId(ELEMENT_ID), null);
    }

    public Slider(RangedValueModel model) {
        this(model, Axis.X, true, new ElementId(ELEMENT_ID), null);
    }

    public Slider(RangedValueModel model, Axis axis) {
        this(model, axis, true, new ElementId(ELEMENT_ID), null);
    }

    public Slider(String style) {
        this(new DefaultRangedValueModel(), Axis.X, true, new ElementId(ELEMENT_ID), style);
    }

    public Slider(ElementId elementId, String style) {
        this(new DefaultRangedValueModel(), Axis.X, true, elementId, style);
    }

    public Slider(Axis axis, ElementId elementId, String style) {
        this(new DefaultRangedValueModel(), axis, true, elementId, style);
    }

    public Slider(Axis axis, String style) {
        this(new DefaultRangedValueModel(), axis, true, new ElementId(ELEMENT_ID), style);
    }

    public Slider(RangedValueModel model, String style) {
        this(model, Axis.X, true, new ElementId(ELEMENT_ID), style);
    }

    public Slider(RangedValueModel model, ElementId elementId) {
        this(model, Axis.X, true, elementId, null);
    }

    public Slider(RangedValueModel model, Axis axis, String style) {
        this(model, axis, true, new ElementId(ELEMENT_ID), style);
    }

    public Slider(RangedValueModel model, Axis axis, ElementId elementId, String style) {
        this(model, axis, true, elementId, style);
    }

    protected Slider(RangedValueModel model, Axis axis, boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId, style);
        Styles styles = GuiGlobals.getInstance().getStyles();
        styles.initializeStyles(((Object)((Object)this)).getClass());
        this.axis = axis;
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout(this.layout);
        ((GuiControl)this.getControl(GuiControl.class)).addListener(new ReshapeListener());
        this.model = model;
        switch (axis) {
            case X: {
                this.increment = this.layout.addChild(BorderLayout.Position.East, new Button(null, true, elementId.child(RIGHT_ID), style));
                this.decrement = this.layout.addChild(BorderLayout.Position.West, new Button(null, true, elementId.child(LEFT_ID), style));
                this.range = this.layout.addChild(new Panel(true, 50.0f, 2.0f, elementId.child(RANGE_ID), style), new Object[0]);
                break;
            }
            case Y: {
                this.increment = this.layout.addChild(BorderLayout.Position.North, new Button(null, true, elementId.child(UP_ID), style));
                this.decrement = this.layout.addChild(BorderLayout.Position.South, new Button(null, true, elementId.child(DOWN_ID), style));
                this.range = this.layout.addChild(new Panel(true, 2.0f, 50.0f, elementId.child(RANGE_ID), style), new Object[0]);
                break;
            }
            case Z: {
                throw new IllegalArgumentException("Z axis not yet supported.");
            }
        }
        this.setupCommands();
        this.thumb = new Button(null, true, elementId.child(THUMB_ID), style);
        ButtonDragger dragger = new ButtonDragger();
        CursorEventControl.addListenersToSpatial((Spatial)this.thumb, dragger);
        this.attachChild((Spatial)this.thumb);
        ((GuiControl)this.thumb.getControl(GuiControl.class)).setSize(((GuiControl)this.thumb.getControl(GuiControl.class)).getPreferredSize());
        if (applyStyles) {
            styles.applyStyles((Object)this, elementId, style);
        }
    }

    protected final void setupCommands() {
        this.increment.addClickCommands((Command<? super Button>)new ChangeValueCommand(1.0));
        this.decrement.addClickCommands((Command<? super Button>)new ChangeValueCommand(-1.0));
    }

    @StyleDefaults(value="slider")
    public static void initializeDefaultStyles(Styles styles, Attributes attrs) {
        ElementId parent = new ElementId(ELEMENT_ID);
        styles.getSelector(parent.child(UP_ID), null).set("text", "^", false);
        styles.getSelector(parent.child(DOWN_ID), null).set("text", "v", false);
        styles.getSelector(parent.child(LEFT_ID), null).set("text", "<", false);
        styles.getSelector(parent.child(RIGHT_ID), null).set("text", ">", false);
        styles.getSelector(parent.child(THUMB_ID), null).set("text", "#", false);
    }

    public void setModel(RangedValueModel model) {
        if (this.model == model) {
            return;
        }
        this.model = model;
        this.state = null;
    }

    public RangedValueModel getModel() {
        return this.model;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public double getDelta() {
        return this.delta;
    }

    public Button getIncrementButton() {
        return this.increment;
    }

    public Button getDecrementButton() {
        return this.decrement;
    }

    public Panel getRangePanel() {
        return this.range;
    }

    public Button getThumbButton() {
        return this.thumb;
    }

    public double getValueForLocation(Vector3f loc) {
        Vector3f relative = loc.subtract(this.range.getLocalTranslation());
        relative.y *= -1.0f;
        Vector3f axisDir = this.axis.getDirection();
        double projection = relative.dot(axisDir);
        if (projection < 0.0) {
            if (this.axis == Axis.Y) {
                return this.model.getMaximum();
            }
            return this.model.getMinimum();
        }
        Vector3f rangeSize = this.range.getSize().clone();
        double rangeLength = rangeSize.dot(axisDir);
        projection = Math.min(projection, rangeLength);
        double part = projection / rangeLength;
        double rangeDelta = this.model.getMaximum() - this.model.getMinimum();
        if (this.axis == Axis.Y) {
            part = 1.0 - part;
        }
        return this.model.getMinimum() + rangeDelta * part;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.state == null || this.state.update()) {
            this.resetStateView();
        }
    }

    protected void resetStateView() {
        if (this.state == null) {
            this.state = this.model.createReference();
        }
        Vector3f pos = this.range.getLocalTranslation();
        Vector3f rangeSize = this.range.getSize();
        Vector3f thumbSize = this.thumb.getSize();
        Vector3f size = this.getSize();
        switch (this.axis) {
            case X: {
                double visibleRange = rangeSize.x - thumbSize.x;
                double x = (double)pos.x + visibleRange * this.model.getPercent();
                double y = (double)pos.y - (double)rangeSize.y * 0.5;
                this.thumb.setLocalTranslation((float)x, (float)(y + (double)thumbSize.y * 0.5), pos.z + size.z);
                break;
            }
            case Y: {
                double visibleRange = rangeSize.y - thumbSize.y;
                double x = (double)pos.x + (double)rangeSize.x * 0.5;
                double y = (double)(pos.y - rangeSize.y) + visibleRange * this.model.getPercent();
                this.thumb.setLocalTranslation((float)(x - (double)thumbSize.x * 0.5), (float)(y + (double)thumbSize.y), pos.z + size.z);
            }
        }
    }

    private class ButtonDragger
    extends DefaultCursorListener {
        private Vector2f drag = null;
        private double startPercent;

        private ButtonDragger() {
        }

        @Override
        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (event.getButtonIndex() != 0) {
                return;
            }
            event.setConsumed();
            if (event.isPressed()) {
                this.drag = new Vector2f(event.getX(), event.getY());
                this.startPercent = Slider.this.model.getPercent();
            } else {
                this.drag = null;
            }
        }

        @Override
        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            if (this.drag == null) {
                return;
            }
            Vector3f v1 = null;
            Vector3f v2 = null;
            switch (Slider.this.axis) {
                case X: {
                    v1 = new Vector3f(((Slider)Slider.this).thumb.getSize().x * 0.5f, 0.0f, 0.0f);
                    v2 = v1.add(((Slider)Slider.this).range.getSize().x - ((Slider)Slider.this).thumb.getSize().x * 0.5f, 0.0f, 0.0f);
                    break;
                }
                case Y: {
                    v1 = new Vector3f(0.0f, ((Slider)Slider.this).thumb.getSize().y * 0.5f, 0.0f);
                    v2 = v1.add(0.0f, ((Slider)Slider.this).range.getSize().y - ((Slider)Slider.this).thumb.getSize().y * 0.5f, 0.0f);
                }
            }
            v1 = event.getRelativeViewCoordinates((Spatial)Slider.this.range, v1);
            v2 = event.getRelativeViewCoordinates((Spatial)Slider.this.range, v2);
            Vector3f dir = v2.subtract(v1);
            float length = dir.length();
            dir.multLocal(1.0f / length);
            Vector3f cursorDir = new Vector3f(event.getX() - this.drag.x, event.getY() - this.drag.y, 0.0f);
            float dot = cursorDir.dot(dir);
            float percent = dot / length;
            Slider.this.model.setPercent(this.startPercent + (double)percent);
            event.setConsumed();
        }
    }

    private class ReshapeListener
    extends AbstractGuiControlListener {
        private ReshapeListener() {
        }

        @Override
        public void reshape(GuiControl source, Vector3f pos, Vector3f size) {
            Slider.this.resetStateView();
        }
    }

    private class ChangeValueCommand
    implements Command<Button> {
        private double scale;

        public ChangeValueCommand(double scale) {
            this.scale = scale;
        }

        @Override
        public void execute(Button source) {
            Slider.this.model.setValue(Slider.this.model.getValue() + Slider.this.delta * this.scale);
        }
    }
}

