/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.geom;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.simsilica.mblock.geom.ColliderlessMesh;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanMeshBuilder {
    static Logger log = LoggerFactory.getLogger(FanMeshBuilder.class);
    private int xCenter = 512;
    private int zCenter = 512;
    private int near = 0;
    private int far = 512;
    private int radials = 1440;
    private double minStep = 1.0;
    private double growthFactor = 1.0;
    private double skirtSize = 0.0;
    private boolean includeNormals = false;

    public FanMeshBuilder center(int xCenter, int zCenter) {
        this.xCenter = xCenter;
        this.zCenter = zCenter;
        return this;
    }

    public FanMeshBuilder near(int near) {
        this.near = near;
        return this;
    }

    public FanMeshBuilder far(int far) {
        this.far = far;
        return this;
    }

    public FanMeshBuilder radials(int radials) {
        this.radials = radials;
        return this;
    }

    public FanMeshBuilder minStep(double minStep) {
        this.minStep = minStep;
        return this;
    }

    public FanMeshBuilder growthFactor(double growthFactor) {
        this.growthFactor = growthFactor;
        return this;
    }

    public FanMeshBuilder skirtSize(double skirtSize) {
        this.skirtSize = skirtSize;
        return this;
    }

    public FanMeshBuilder includeNormals(boolean f) {
        this.includeNormals = f;
        return this;
    }

    public ColliderlessMesh build() {
        ColliderlessMesh mesh = new ColliderlessMesh("fan[" + this.near + ":" + this.far + "]", false);
        mesh.setMode(Mesh.Mode.Triangles);
        double wedgeAngle = 1.0 / (double)this.radials * Math.PI * 2.0;
        double growth = Math.sin(wedgeAngle * 0.5) * 2.0 * this.growthFactor;
        ArrayList<Double> distances = new ArrayList<Double>();
        distances.add(Double.valueOf(this.near));
        for (double d = (double)this.near; d < (double)this.far; d += Math.max(this.minStep, growth * d)) {
            distances.add(Math.min(d, (double)this.far));
        }
        if (log.isTraceEnabled()) {
            log.trace("Distances count:" + distances.size());
            for (Double d : distances) {
                log.trace(" d:" + d);
            }
        }
        int rings = distances.size();
        if (this.skirtSize > 0.0 && this.near > 0) {
            ++rings;
        }
        int verts = (this.radials + 1) * rings;
        float[] fv = new float[verts * 3];
        float[] fn = this.includeNormals ? new float[verts * 3] : null;
        int vIndex = 0;
        int nIndex = 0;
        boolean vertNum = false;
        if (this.skirtSize > 0.0 && this.near > 0) {
            Double d = (Double)distances.get(0);
            for (int r = 0; r <= this.radials; ++r) {
                double a = (double)r / (double)this.radials * Math.PI * 2.0;
                double x1 = (double)this.xCenter + Math.cos(a) * d;
                double z1 = (double)this.zCenter + Math.sin(a) * d;
                fv[vIndex++] = (float)x1;
                fv[vIndex++] = (float)(-this.skirtSize);
                fv[vIndex++] = (float)z1;
                if (!this.includeNormals) continue;
                fn[nIndex++] = 0.0f;
                fn[nIndex++] = 1.0f;
                fn[nIndex++] = 0.0f;
            }
        }
        for (Double d : distances) {
            for (int r = 0; r <= this.radials; ++r) {
                double a = (double)r / (double)this.radials * Math.PI * 2.0;
                double x1 = (double)this.xCenter + Math.cos(a) * d;
                double z1 = (double)this.zCenter + Math.sin(a) * d;
                fv[vIndex++] = (float)x1;
                fv[vIndex++] = 0.0f;
                fv[vIndex++] = (float)z1;
                if (!this.includeNormals) continue;
                fn[nIndex++] = 0.0f;
                fn[nIndex++] = 1.0f;
                fn[nIndex++] = 0.0f;
            }
        }
        int quads = this.radials * (rings - 1);
        int[] ib = new int[quads * 2 * 3];
        int index = 0;
        int ringStart = 0;
        int ringSize = this.radials + 1;
        for (int i = 1; i < rings; ++i) {
            for (int r = 0; r < this.radials; ++r) {
                ib[index++] = ringStart + r;
                ib[index++] = ringStart + r + 1;
                ib[index++] = ringStart + ringSize + r + 1;
                ib[index++] = ringStart + r;
                ib[index++] = ringStart + ringSize + r + 1;
                ib[index++] = ringStart + ringSize + r;
            }
            ringStart += ringSize;
        }
        mesh.setBuffer(VertexBuffer.Type.Position, 3, fv);
        if (this.includeNormals) {
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, fn);
        }
        mesh.setBuffer(VertexBuffer.Type.Index, 3, ib);
        mesh.updateBound();
        mesh.setStatic();
        return mesh;
    }
}

