/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.io.FluidDataProtocol;
import com.simsilica.mworld.io.LeafDataProtocol;
import com.simsilica.mworld.io.LightDataProtocol;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDataProtocol
implements ObjectProtocol<ColumnData> {
    static Logger log = LoggerFactory.getLogger(ColumnDataProtocol.class);
    private int protocolVersion = 2;
    private LeafDataProtocol leafProtocol = new LeafDataProtocol();
    private LightDataProtocol lightProtocol = new LightDataProtocol();
    private FluidDataProtocol fluidProtocol = new FluidDataProtocol();

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ColumnData col, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(col, out);
        }
    }

    @Override
    public void write(ColumnData col, BitOutputStream out) throws IOException {
        out.writeBits(this.protocolVersion, 16);
        out.writeLongBits(col.getColumnId().getId(), 64);
        out.writeLongBits(col.getVersion().getVersion(), 64);
        out.writeLongBits(col.getGenerationFlags(), 64);
        LeafData[] leafs = col.getLeafs();
        out.writeBits(leafs.length, 8);
        for (LeafData leaf : leafs) {
            this.leafProtocol.write(leaf, out);
        }
        FluidData[] fluid = col.getFluid();
        out.writeBits(fluid.length, 8);
        for (FluidData fluidData : fluid) {
            this.fluidProtocol.write(fluidData, out);
        }
        LightData[] lighting = col.getLighting();
        out.writeBits(lighting.length, 8);
        for (LightData lightData : lighting) {
            this.lightProtocol.write(lightData, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnData read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            ColumnData columnData = this.read(in);
            return columnData;
        }
    }

    @Override
    public ColumnData read(BitInputStream in) throws IOException {
        int version = in.readBits(16);
        ColumnId columnId = new ColumnId(in.readLongBits(64));
        long dataVersion = in.readLongBits(64);
        long generationFlags = in.readLongBits(64);
        int arraySize = in.readBits(8);
        LeafData[] leafs = new LeafData[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            leafs[i] = this.leafProtocol.read(in);
        }
        int fluidSize = in.readBits(8);
        FluidData[] fluid = new FluidData[fluidSize];
        for (int i = 0; i < fluidSize; ++i) {
            fluid[i] = this.fluidProtocol.read(in);
        }
        int lightingSize = in.readBits(8);
        LightData[] lighting = new LightData[lightingSize];
        for (int i = 0; i < lightingSize; ++i) {
            lighting[i] = this.lightProtocol.read(in);
        }
        return new ColumnData(columnId, leafs, fluid, lighting, new DataVersion(dataVersion), generationFlags);
    }
}

