/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.bp;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Line;
import com.jme3.scene.shape.Quad;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.focus.FocusChangeEvent;
import com.simsilica.lemur.focus.FocusChangeListener;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.CellUtils;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.io.BlockObject;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mblock.phys.BlockColliderIterator;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mworld.BlockIterator;
import java.io.File;
import java.util.Objects;
import java.util.function.Predicate;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.HelpPopup;
import mythruna.client.ui.bp.AddCellsEdit;
import mythruna.client.ui.bp.BlockTypeSelector;
import mythruna.client.ui.bp.BlueprintFileSelectorDialog;
import mythruna.client.ui.bp.BlueprintFunctions;
import mythruna.client.ui.bp.BlueprintSelectorState;
import mythruna.client.ui.bp.BuildArea;
import mythruna.client.ui.bp.IsCarvedEdit;
import mythruna.client.ui.edit.CellEdit;
import mythruna.client.ui.edit.Edit;
import mythruna.client.ui.edit.EditHistory;
import mythruna.client.ui.edit.TextFieldEdit;
import mythruna.net.BlueprintData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintEditorState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(BlueprintEditorState.class);
    private Node rootNode = new Node("blueprintRoot");
    private Geometry background;
    private BuildArea buildArea;
    private Node platform;
    private Vector2f center = new Vector2f();
    private BlockTypeSelector typeSelector;
    private VersionedReference<BlockType> typeRef;
    private boolean typeInvalid;
    private Container objectSettings;
    private Checkbox isCarved;
    private VersionedReference<Boolean> isCarvedRef;
    private TextField blueprintName;
    private TextField objectName;
    private Label editCount;
    private Container editButtons;
    private CursorHandler cursorHandler = new CursorHandler();
    private InputHandler inputHandler = new InputHandler();
    private float yaw = 0.7853982f;
    private float pitch = 0.39f;
    private float yOffsetMin = 0.0f;
    private float yOffsetMax = 100.0f;
    private GeometryFactory geomFactory;
    private Collider[] colliders;
    private CellArray blockTypeCells = new CellArray(1);
    private Node typeCursor = new Node("typeCursor");
    private Node typeHolder;
    private float blink = 0.0f;
    private float blinkTime = 0.3f;
    private Vec3i lastAdd = null;
    private Spatial removeCursor;
    private Vec3i lastRemove = null;
    private CellArray objectCells = new CellArray(20);
    private boolean cellsInvalid = false;
    private Node blockObject = new Node("blockObject");
    private int maxSize = 10;
    private boolean carved = false;
    private float carveScale = 0.25f;
    private Predicate<Geometry> carveIncludes;
    private EditHistory history = new EditHistory(50);
    private ActionButton undo;
    private ActionButton redo;
    private int totalEditCount;
    private Geometry testArrow1;
    private Geometry testArrow2;
    private BlueprintData blueprint;
    private HelpPopup help;

    public BlueprintEditorState() {
        this.setEnabled(false);
    }

    public void editBlueprint(BlueprintData blueprint) {
        if (!Objects.equals(this.blueprint, blueprint)) {
            this.blueprint = blueprint;
            if (blueprint.array == null) {
                log.error("Blueprint array is null:" + blueprint);
                ((GuiState)this.getState(GuiState.class)).showError("Invalid Blueprint", "Blueprint data is missing.");
                return;
            }
            this.history.clear();
            this.totalEditCount = 0;
            this.objectCells.clear();
            CellUtils.copyData((CellData)blueprint.array, (int)0, (int)0, (int)0, (CellData)this.objectCells, (int)blueprint.offset.x, (int)blueprint.offset.y, (int)blueprint.offset.z, (int)blueprint.array.getSizeX(), (int)blueprint.array.getSizeY(), (int)blueprint.array.getSizeZ());
            this.setCarved(blueprint.carved);
            this.cellsInvalid = true;
            this.blueprintName.setText(blueprint.name);
            this.objectName.setText(blueprint.objectName);
        }
        this.setEnabled(true);
    }

    public void setCell(int x, int y, int z, int type) {
        int val = this.objectCells.getCell(x, y, z);
        int existing = MaskUtils.getType((int)val);
        if (type == existing) {
            return;
        }
        this.addEdit(new CellEdit((CellData)this.objectCells, new Vec3i(x, y, z), type), true);
    }

    protected void addEdit(Edit edit, boolean invalidateCells) {
        this.history.addEdit(edit);
        ++this.totalEditCount;
        this.cellsInvalid = invalidateCells;
        this.resetHistoryButtons();
    }

    public boolean undo() {
        log.info("undo()");
        if (this.history.undo()) {
            --this.totalEditCount;
            this.cellsInvalid = true;
            this.resetHistoryButtons();
            return true;
        }
        return false;
    }

    public boolean redo() {
        log.info("redo()");
        if (this.history.redo()) {
            ++this.totalEditCount;
            this.cellsInvalid = true;
            this.resetHistoryButtons();
            return true;
        }
        return false;
    }

    protected void setCarved(boolean carved) {
        if (this.carved == carved) {
            return;
        }
        this.carved = carved;
        this.isCarved.setChecked(carved);
        this.cellsInvalid = true;
        this.typeInvalid = true;
    }

    public boolean isCarved() {
        return this.carved;
    }

    protected void save() {
        Vec3i offset;
        this.blueprint.name = this.blueprintName.getText();
        this.blueprint.objectName = this.objectName.getText();
        this.blueprint.carved = this.carved;
        Vec3i[] range = CellUtils.calculateSize((CellArray)this.objectCells);
        this.blueprint.offset = offset = range[0];
        Vec3i size = range[1].subtract(range[0]);
        size.addLocal(1, 1, 1);
        this.blueprint.array = new CellArray(size.x, size.y, size.z);
        CellUtils.copyData((CellData)this.objectCells, (int)offset.x, (int)offset.y, (int)offset.z, (CellData)this.blueprint.array, (int)0, (int)0, (int)0, (int)size.x, (int)size.y, (int)size.z);
        ((BlueprintSelectorState)this.getState(BlueprintSelectorState.class)).saveEdit(this.blueprint, true);
    }

    protected void back() {
        if (this.totalEditCount > 0) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Abandon Changes?", "Really lose changes?  Or Save?", new Action[]{new CallMethodAction("Save Changes", (Object)this, "save"), new CallMethodAction("Discard Changes", (Object)this, "doBack"), new EmptyAction("Cancel")});
        } else {
            this.doBack();
        }
    }

    protected void doBack() {
        ((BlueprintSelectorState)this.getState(BlueprintSelectorState.class)).cancelEdit();
    }

    protected void resetHistoryButtons() {
        this.undo.setEnabled(this.history.canUndo());
        this.redo.setEnabled(this.history.canRedo());
        this.editCount.setText("Total Edits:" + this.totalEditCount);
    }

    protected void validateCells() {
        this.cellsInvalid = false;
        MaskUtils.calculateSideMasks((CellArray)this.objectCells);
        this.geomFactory.generateBlocks(this.blockObject, this.objectCells, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        if (this.carved) {
            this.blockObject.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf(1.0f / this.carveScale)));
        } else {
            for (MatParamOverride mp : this.blockObject.getLocalMatParamOverrides()) {
                if (!"CarveScale".equals(mp.getName())) continue;
                this.blockObject.removeMatParamOverride(mp);
            }
        }
        this.blockObject.setLocalTranslation(this.buildArea.getOriginLocation());
    }

    protected void updateRotation() {
        Quaternion rot = new Quaternion().fromAngles(this.pitch, 0.0f, 0.0f);
        rot.multLocal(new Quaternion().fromAngles(0.0f, this.yaw, 0.0f));
        this.platform.setLocalRotation(rot);
        float yOffset = 1.0f - this.pitch / 1.5707964f;
        yOffset = this.yOffsetMin + yOffset * (this.yOffsetMax - this.yOffsetMin);
        this.platform.setLocalTranslation(this.center.x, this.center.y + yOffset, 0.0f);
    }

    protected void initialize(Application app) {
        this.colliders = new ColliderFactories(true).createColliders(BlockTypeIndex.getTypes());
        this.center.set(((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize()).multLocal(0.5f);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        BlueprintFunctions.initializeDefaultMappings(inputMapper);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{BlueprintFunctions.F_PAN, BlueprintFunctions.F_CRANE, BlueprintFunctions.F_ZOOM, BlueprintFunctions.F_ROTATE_BLOCK});
        inputMapper.addStateListener((StateFunctionListener)this.inputHandler, new FunctionId[]{BlueprintFunctions.F_UNDO, BlueprintFunctions.F_REDO, BlueprintFunctions.F_CHOOSE, BlueprintFunctions.F_IMPORT, BlueprintFunctions.F_EXPORT});
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
        this.carveIncludes = ((GameSessionState)this.getState(GameSessionState.class, true)).getCarveIncludes();
        this.buildArea = new BuildArea(app.getAssetManager());
        this.buildArea.center();
        this.platform = new Node("blueprintPlatform");
        this.rootNode.attachChild((Spatial)this.platform);
        this.platform.attachChild((Spatial)this.buildArea);
        this.platform.setLocalScale(5.0f);
        CursorEventControl.addListenersToSpatial((Spatial)this.buildArea, (CursorListener[])new CursorListener[]{this.cursorHandler});
        this.updateRotation();
        this.buildArea.attachChild((Spatial)this.blockObject);
        this.blockObject.setLocalTranslation(this.buildArea.getOriginLocation());
        this.typeSelector = new BlockTypeSelector();
        this.typeRef = this.typeSelector.createSelectedTypeRef();
        this.objectSettings = new Container(new ElementId("window"));
        this.objectSettings.addChild((Node)new Label("Object Settings:"), new Object[0]);
        Container properties = (Container)this.objectSettings.addChild((Node)new Container(), new Object[0]);
        properties.addChild((Node)new Label("Blueprint:"), new Object[0]);
        this.blueprintName = (TextField)properties.addChild((Node)new TextField("Unnamed"), new Object[]{1});
        ((GuiControl)this.blueprintName.getControl(GuiControl.class)).addFocusChangeListener((FocusChangeListener)new TextFieldListener("Blueprint", this.blueprintName));
        properties.addChild((Node)new Label("Object Name:"), new Object[0]);
        this.objectName = (TextField)properties.addChild((Node)new TextField("Object"), new Object[]{1});
        ((GuiControl)this.objectName.getControl(GuiControl.class)).addFocusChangeListener((FocusChangeListener)new TextFieldListener("Object Name", this.objectName));
        this.isCarved = (Checkbox)this.objectSettings.addChild((Node)new Checkbox("Carved Materials"), new Object[0]);
        this.isCarvedRef = this.isCarved.getModel().createReference();
        this.objectSettings.addChild((Node)new Label("Edit History:"), new Object[0]);
        this.editCount = (Label)this.objectSettings.addChild((Node)new Label("Total Edits:0"), new Object[0]);
        this.undo = (ActionButton)this.objectSettings.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "undo")), new Object[0]);
        this.redo = (ActionButton)this.objectSettings.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "redo")), new Object[0]);
        this.editButtons = new Container(new ElementId("popup"));
        this.editButtons.addChild((Node)new ActionButton((Action)new CallMethodAction("Save Blueprint", (Object)this, "save")), new Object[0]);
        this.editButtons.addChild((Node)new ActionButton((Action)new CallMethodAction("Back to Selection", (Object)this, "back")), new Object[0]);
        this.typeHolder = new Node("typeHolder"){

            public int collideWith(Collidable other, CollisionResults results) {
                return 0;
            }
        };
        this.typeHolder.attachChild((Spatial)this.typeCursor);
        this.resetType();
        Texture xBlock = app.getAssetManager().loadTexture("Interface/x-block.png");
        Geometry geom = new Geometry("removeCursor", (Mesh)new Box(0.51f, 0.51f, 0.51f)){

            public int collideWith(Collidable other, CollisionResults results) {
                return 0;
            }
        };
        Material mat = GuiGlobals.getInstance().createMaterial(xBlock, true).getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        LayerComparator.setLayer((Spatial)geom, (int)9);
        this.removeCursor = geom;
        Texture blur = app.getAssetManager().loadTexture("Interface/radial-blur128.png");
        int backgroundWidth = 3000;
        int backgroundHeight = 2000;
        Quad big = new Quad((float)backgroundWidth, (float)backgroundHeight);
        geom = new Geometry("background", (Mesh)big);
        mat = GuiGlobals.getInstance().createMaterial(blur, false).getMaterial();
        mat.setColor("Color", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.5f));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.background = geom;
        this.rootNode.attachChild((Spatial)this.background);
        Vector2f offset = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getGuiSize().mult(0.5f);
        this.background.setLocalTranslation(offset.x - (float)(backgroundWidth / 2), offset.y - (float)(backgroundHeight / 2), -450.0f);
        Line line = new Line(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f));
        this.testArrow1 = new Geometry("testArrow1", (Mesh)line);
        mat = GuiGlobals.getInstance().createMaterial(ColorRGBA.Red, false).getMaterial();
        this.testArrow1.setMaterial(mat);
        line = new Line(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f));
        this.testArrow2 = new Geometry("testArrow2", (Mesh)line);
        mat = GuiGlobals.getInstance().createMaterial(ColorRGBA.Green, false).getMaterial();
        this.testArrow2.setMaterial(mat);
        this.help = new HelpPopup(null, v -> {
            Vector2f size = ((GuiState)this.getState(GuiState.class)).getGuiSize();
            return new Vector3f(50.0f, size.y * 0.6f, 0.0f);
        }, "Blueprint Editing");
        this.help.setText("The 'w','a','s', and 'd' keys rotate the build area.", "The right mouse button places a block where", "the flashing cursor indicates.", "The left mouse button removes the block", "where the 'X' cursor indicates.", "", "The block type can be changed in the 'Block", "Palette' in the upper right or by pressing 'c'", "over a block in the build area.", "", "Edit blueprint properties in the 'Object", "Settings' panel.  'Blueprint' is the name for", "this blueprint.  'Object Name' is the name of", "the object as it appears in the world.", "", "Ctrl-Z will undo the last edit and Ctrl-Y will", "redo the last edit or the 'Undo' and 'Redo'", "buttons do the same thing.");
    }

    protected void cleanup(Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{BlueprintFunctions.F_PAN, BlueprintFunctions.F_CRANE, BlueprintFunctions.F_ZOOM, BlueprintFunctions.F_ROTATE_BLOCK});
        inputMapper.removeStateListener((StateFunctionListener)this.inputHandler, new FunctionId[]{BlueprintFunctions.F_UNDO, BlueprintFunctions.F_REDO, BlueprintFunctions.F_CHOOSE, BlueprintFunctions.F_IMPORT, BlueprintFunctions.F_EXPORT});
    }

    protected void onEnable() {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup("Blueprint");
        Vector3f pref = this.typeSelector.getPreferredSize();
        Vector2f size = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize();
        this.typeSelector.setLocalTranslation(size.x * 0.95f - pref.x, size.y * 0.9f, 0.0f);
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.typeSelector);
        float y = size.y * 0.9f - pref.y * 2.0f;
        pref = this.objectSettings.getPreferredSize();
        pref.x = Math.max(pref.x, 250.0f);
        this.objectSettings.setPreferredSize(pref);
        this.objectSettings.setLocalTranslation(size.x * 0.95f - pref.x, y, 0.0f);
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.objectSettings);
        this.editButtons.setLocalTranslation(size.x * 0.95f - pref.x, y -= pref.y + 20.0f, 0.0f);
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.editButtons);
        this.resetHistoryButtons();
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.rootNode);
        this.help.attach();
    }

    public void update(float tpf) {
        if (this.typeRef.update() || this.typeInvalid) {
            this.resetType();
        }
        if (this.isCarvedRef.update() && (Boolean)this.isCarvedRef.get() != this.carved) {
            this.addEdit(new IsCarvedEdit(this, (Boolean)this.isCarvedRef.get()), true);
        }
        if (this.cellsInvalid) {
            this.validateCells();
        }
        this.blink += tpf;
        if (this.blink > this.blinkTime) {
            this.blink = 0.0f;
        }
        this.setCursorVisibility(this.blink / this.blinkTime);
    }

    protected void onDisable() {
        this.help.detach();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup("Blueprint");
        this.rootNode.removeFromParent();
        this.typeSelector.removeFromParent();
        this.objectSettings.removeFromParent();
        this.editButtons.removeFromParent();
    }

    protected void setCursorVisibility(float amount) {
        if (amount <= 0.6f) {
            this.typeHolder.setLocalScale(Math.min(1.0f, amount / 0.05f));
            this.typeHolder.setCullHint(Spatial.CullHint.Inherit);
        } else {
            this.typeHolder.setCullHint(Spatial.CullHint.Always);
        }
    }

    protected void setAdd(Vec3i cell) {
        if (Objects.equals(this.lastAdd, cell)) {
            return;
        }
        this.lastAdd = cell;
        if (this.lastAdd != null) {
            Vector3f loc = this.buildArea.getCellLocation(cell, new Vector3f(0.5f, 0.5f, 0.5f));
            this.typeHolder.setLocalTranslation(loc);
            this.buildArea.attachChild((Spatial)this.typeHolder);
        } else {
            this.typeHolder.removeFromParent();
        }
    }

    protected void setRemove(Vec3i cell) {
        if (Objects.equals(this.lastRemove, cell)) {
            return;
        }
        this.lastRemove = cell;
        if (this.lastRemove != null) {
            Vector3f loc = this.buildArea.getCellLocation(cell, new Vector3f(0.5f, 0.5f, 0.5f));
            this.removeCursor.setLocalTranslation(loc);
            this.buildArea.attachChild(this.removeCursor);
        } else {
            this.removeCursor.removeFromParent();
        }
    }

    protected void setSelectedCell(Vec3i add, Vec3i remove) {
        this.setAdd(add);
        this.setRemove(remove);
    }

    protected void resetType() {
        this.typeInvalid = false;
        int type = this.typeSelector.getSelectedType();
        int val = MaskUtils.setSideMask((int)type, (int)63);
        this.blockTypeCells.setCell(0, 0, 0, val);
        this.geomFactory.generateBlocks(this.typeCursor, this.blockTypeCells, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        if (this.carved) {
            this.typeCursor.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf(1.0f / this.carveScale)));
        } else {
            for (MatParamOverride mp : this.typeCursor.getLocalMatParamOverrides()) {
                if (!"CarveScale".equals(mp.getName())) continue;
                this.typeCursor.removeMatParamOverride(mp);
            }
        }
        this.typeCursor.setLocalTranslation(-0.5f, -0.5f, -0.5f);
    }

    protected void chooseType() {
        log.info("Choose type");
        if (this.lastRemove != null) {
            int value = this.objectCells.getCell(this.lastRemove.x, this.lastRemove.y, this.lastRemove.z);
            int type = MaskUtils.getType((int)value);
            this.typeSelector.setSelectedType(type);
        }
    }

    protected void exportCurrent() {
        String name = this.blueprintName.getText() + "-" + this.objectName.getText() + ".blocks";
        log.info("Export current:" + name);
        try {
            File target = new File("blueprints", name);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            BlocksFileFormat.writeBlocks((BlockObject)new BlockObject(this.objectCells, new CellArray(20)), (File)target);
        }
        catch (Exception e) {
            log.error("Error writing:" + name, (Throwable)e);
        }
    }

    protected void selectImport() {
        BlueprintFileSelectorDialog dialog = new BlueprintFileSelectorDialog(new File("blueprints"), file -> this.importFile((File)file));
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)dialog);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)dialog, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
    }

    protected void importFile(File f) {
        log.info("importFile(" + f + ")");
        try {
            BlockObject blocks = BlocksFileFormat.readBlocks((File)f, (boolean)true);
            Vec3i[] range = CellUtils.calculateSize((CellArray)blocks.cells);
            int xs = range[1].x - range[0].x + 1;
            int ys = range[1].y - range[0].y + 1;
            int zs = range[1].z - range[0].z + 1;
            int x = 5 - xs / 2;
            int y = 0;
            int z = 5 - zs / 2;
            CellArray cells = new CellArray(10);
            CellUtils.copyData((CellData)blocks.cells, (int)range[0].x, (int)range[0].y, (int)range[0].z, (CellData)cells, (int)x, (int)y, (int)z, (int)xs, (int)ys, (int)zs);
            this.addEdit(new AddCellsEdit(this.objectCells, f.getName(), cells), true);
        }
        catch (Exception e) {
            log.error("Error reading:" + f, (Throwable)e);
        }
    }

    private class CursorHandler
    extends DefaultCursorListener {
        private CollisionResult lastResult;
        private Vec3i add;
        private Vec3i remove;

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (event.isPressed()) {
                return;
            }
            if (event.getButtonIndex() == 1) {
                if (this.add == null) {
                    return;
                }
                BlueprintEditorState.this.setCell(this.add.x, this.add.y, this.add.z, BlueprintEditorState.this.typeSelector.getSelectedType());
            } else if (event.getButtonIndex() == 0) {
                if (this.remove == null) {
                    return;
                }
                BlueprintEditorState.this.setCell(this.remove.x, this.remove.y, this.remove.z, 0);
            }
        }

        public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.add = null;
            this.remove = null;
            BlueprintEditorState.this.setSelectedCell(this.add, this.remove);
        }

        protected Vec3i clamp(Vec3i cell) {
            if (cell == null) {
                return null;
            }
            if (cell.x < 0 || cell.y < 0 || cell.z < 0) {
                return null;
            }
            if (cell.x >= BlueprintEditorState.this.maxSize || cell.y >= BlueprintEditorState.this.maxSize || cell.z >= BlueprintEditorState.this.maxSize) {
                return null;
            }
            return cell;
        }

        protected boolean isInside(Vec3d v, double min, double max) {
            if (v.x < min || v.x > max) {
                return false;
            }
            if (v.y < min || v.y > max) {
                return false;
            }
            return !(v.z < min) && !(v.z > max);
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            int value;
            BlockIterator worldIterator;
            BlockColliderIterator iterator;
            Vec3d cp;
            this.lastResult = event.getCollision();
            if (this.lastResult == null) {
                return;
            }
            if (BlueprintEditorState.this.buildArea.isBuildArea((Spatial)this.lastResult.getGeometry())) {
                cp = new Vec3d(BlueprintEditorState.this.buildArea.toCell(this.lastResult.getContactPoint()));
                Vec3d cn = new Vec3d(BlueprintEditorState.this.buildArea.toNormal(this.lastResult.getContactNormal()));
                cn.normalizeLocal();
                this.add = cp.add(cn.mult(0.5)).floor();
                this.remove = null;
            } else {
                this.add = null;
                this.remove = null;
            }
            cp = BlueprintEditorState.this.buildArea.toCell(this.lastResult.getContactPoint());
            Vector3f camLoc = ((PerspectiveGuiState)BlueprintEditorState.this.getState(PerspectiveGuiState.class, true)).getGuiCamera().getLocation();
            camLoc = BlueprintEditorState.this.buildArea.toCell(camLoc);
            Vec3d dir = new Vec3d((Vector3f)cp).subtractLocal(new Vec3d(camLoc));
            dir.normalizeLocal();
            Rayd ray = new Rayd(new Vec3d(camLoc), dir);
            if (log.isDebugEnabled()) {
                log.debug("pick:" + ray);
            }
            if ((iterator = new BlockColliderIterator(worldIterator = new BlockIterator((CellData)BlueprintEditorState.this.objectCells, ray, 30.0), BlueprintEditorState.this.colliders)).hasNext()) {
                BlockIterator.Intersection i = iterator.next();
                if (log.isDebugEnabled()) {
                    log.debug("    :" + i);
                }
                this.remove = i.getBlock();
                this.add = this.remove.toVec3d().addLocal(i.getNormal()).floor();
            }
            this.add = this.clamp(this.add);
            this.remove = this.clamp(this.remove);
            if (this.remove != null && MaskUtils.getType((int)(value = BlueprintEditorState.this.objectCells.getCell(this.remove.x, this.remove.y, this.remove.z))) == 0) {
                this.remove = null;
            }
            if (this.add != null) {
                value = BlueprintEditorState.this.objectCells.getCell(this.add.x, this.add.y, this.add.z);
                if (MaskUtils.getType((int)value) != 0) {
                    this.add = null;
                }
                BlueprintEditorState.this.setSelectedCell(this.add, this.remove);
            }
        }
    }

    private class InputHandler
    implements AnalogFunctionListener,
    StateFunctionListener {
        private InputHandler() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
            boolean pressed;
            boolean bl = pressed = value == InputState.Positive;
            if (!pressed) {
                if (func == BlueprintFunctions.F_CHOOSE) {
                    BlueprintEditorState.this.chooseType();
                } else if (func == BlueprintFunctions.F_EXPORT) {
                    BlueprintEditorState.this.exportCurrent();
                } else if (func == BlueprintFunctions.F_IMPORT) {
                    BlueprintEditorState.this.selectImport();
                } else if (func == BlueprintFunctions.F_UNDO) {
                    BlueprintEditorState.this.undo();
                } else if (func == BlueprintFunctions.F_REDO) {
                    BlueprintEditorState.this.redo();
                }
            }
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == BlueprintFunctions.F_PAN) {
                BlueprintEditorState.this.yaw = (float)((double)BlueprintEditorState.this.yaw + -value * tpf);
                if (BlueprintEditorState.this.yaw < 0.0f) {
                    BlueprintEditorState.this.yaw += (float)Math.PI * 2;
                } else if (BlueprintEditorState.this.yaw >= (float)Math.PI * 2) {
                    BlueprintEditorState.this.yaw -= (float)Math.PI * 2;
                }
                BlueprintEditorState.this.updateRotation();
            } else if (func == BlueprintFunctions.F_CRANE) {
                BlueprintEditorState.this.pitch = (float)((double)BlueprintEditorState.this.pitch + value * tpf);
                if (BlueprintEditorState.this.pitch < 0.0f) {
                    BlueprintEditorState.this.pitch = 0.0f;
                } else if (BlueprintEditorState.this.pitch > 1.5707964f) {
                    BlueprintEditorState.this.pitch = 1.5707964f;
                }
                BlueprintEditorState.this.updateRotation();
            } else if (func == BlueprintFunctions.F_ROTATE_BLOCK) {
                BlueprintEditorState.this.typeSelector.adjustRotation((int)value);
            } else {
                log.info("unhandled id:" + func);
            }
        }
    }

    private class TextFieldListener
    implements FocusChangeListener {
        private String name;
        private TextField textField;
        private String lastValue;

        public TextFieldListener(String name, TextField textField) {
            this.name = name;
            this.textField = textField;
        }

        public void focusGained(FocusChangeEvent event) {
            this.lastValue = this.textField.getText();
        }

        public void focusLost(FocusChangeEvent event) {
            String value = this.textField.getText();
            if (!Objects.equals(value, this.lastValue)) {
                log.info(this.name + " changed:" + value);
                BlueprintEditorState.this.addEdit(new TextFieldEdit(this.name, this.textField, value, this.lastValue), false);
            }
        }
    }
}

