/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.common.Decay;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.ObjectStatusListener;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mblock.phys.collision.ColliderUtils;
import com.simsilica.mblock.phys.collision.ShapeSignature;
import com.simsilica.mblock.phys.collision.SimilarShapeIndex;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.StaticBody;
import com.simsilica.mworld.World;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mythruna.GameConstants;
import mythruna.es.DestructibleBlock;
import mythruna.es.ObjectTypeInfo;
import mythruna.sim.DestructibleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestructibleObjectSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(DestructibleObjectSystem.class);
    private EntityData ed;
    private MPhysSystem<MBlockShape> physics;
    private PhysicsSpace<EntityId, MBlockShape> space;
    private Collider[] colliders;
    private SimilarShapeIndex shapeIndex;
    private World world;
    private SimTime time;
    private StaticBodyObserver bodyListener = new StaticBodyObserver();
    private long expiration = 300L;
    private DynArray<DestructibleListener> listeners = new DynArray(DestructibleListener.class);
    private BlockContainer blocks;
    private Map<EntityId, StaticBody<EntityId, MBlockShape>> bodyIndex = new HashMap<EntityId, StaticBody<EntityId, MBlockShape>>();
    private Map<EntityId, Runnable> initializers = new HashMap<EntityId, Runnable>();
    private static final Vec3i MAX_CELL = new Vec3i(3, 3, 3);
    private static final Set<String> IGNORE_BASE_NAMES = new HashSet<String>(Arrays.asList("bladder", "bladder-low", "corn", "fire", "flora", "jack-o-lantern", "light", "log", "magic-blue", "magic-green", "magic-red", "magic-white", "pine", "pumpkin", "thatch", "trunk"));
    private Set<Integer> ignoredTypes = new HashSet<Integer>();

    public void addListener(DestructibleListener l) {
        this.listeners.add((Object)l);
    }

    public void removeListener(DestructibleListener l) {
        this.listeners.remove((Object)l);
    }

    public CellArray getDestructibleCells(EntityId objectId) {
        DestructibleTracker tracker = (DestructibleTracker)this.blocks.getObject(objectId);
        return tracker == null ? null : tracker.cells;
    }

    protected DestructibleTracker findTracker(Vec3d loc) {
        for (DestructibleTracker tracker : this.blocks.getArray()) {
            if (!loc.equals((Object)tracker.pos.getLocation())) continue;
            return tracker;
        }
        return null;
    }

    protected EntityId findBlockEntity(Vec3d loc) {
        DestructibleTracker tracker = this.findTracker(loc);
        if (tracker != null) {
            return tracker.entity.getId();
        }
        long binId = GameConstants.PHYSICS_GRID.worldToId(loc);
        for (EntityId found : this.ed.findEntities(SpawnPosition.binFilter((long)binId), new Class[]{SpawnPosition.class, DestructibleBlock.class})) {
            SpawnPosition pos;
            if (this.blocks.getObject(found) != null || (pos = (SpawnPosition)this.ed.getComponent(found, SpawnPosition.class)) == null || !loc.equals((Object)pos.getLocation())) continue;
            return found;
        }
        return null;
    }

    public void chop(EntityId chopper, EntityId target, Vec3d cp, Vec3d norm, Vec3d vel) {
        if (log.isDebugEnabled()) {
            log.debug("chop(" + chopper + ", " + target + ", " + cp + ", " + norm + ", " + vel + ")");
        }
        if (target == null) {
            Vec3i block = this.onBorder(cp) ? cp.subtract(norm.mult(0.1)).floor() : cp.floor();
            this.chopBlock(cp, block, norm, vel);
            return;
        }
        this.chopObject(target, cp, norm, vel);
    }

    public void chopBlock(Vec3d clickLoc, Vec3i blockLoc, Vec3d normal, Vec3d cVelocity) {
        int cell;
        int type;
        if (log.isDebugEnabled()) {
            log.debug("chopBlock(" + clickLoc + ", " + blockLoc + ", " + cVelocity + ") time:" + this.time);
        }
        if (BlockTypeIndex.get((int)(type = MaskUtils.getType((int)(cell = this.world.getWorldCell(blockLoc.toVec3d()))))) == null || this.ignoredTypes.contains(type)) {
            return;
        }
        Vec3d loc = blockLoc.toVec3d();
        EntityId block = this.findBlockEntity(loc);
        if (block != null) {
            if (log.isDebugEnabled()) {
                log.debug("Already has an object:" + block);
            }
            this.chopObject(block, clickLoc, normal, cVelocity);
            return;
        }
        block = this.ed.createEntity();
        this.ed.setComponents(block, new EntityComponent[]{new SpawnPosition(GameConstants.PHYSICS_GRID, loc, new Quatd()), ShapeInfo.create((String)("c_" + type + ".fax"), (double)0.25, (EntityData)this.ed), ObjectTypeInfo.create("ChopFacsimile", this.ed), new Mass(0.0), new DestructibleBlock(type, this.time.getFutureTime((double)this.expiration)), new Decay(this.time.getFutureTime(600.0))});
        EntityId initId = block;
        this.initializers.put(initId, () -> {
            this.world.setWorldCell(blockLoc.toVec3d(), 0);
            this.chopObject(initId, clickLoc, normal, cVelocity);
        });
    }

    public void chopObject(EntityId objectId, Vec3d loc, Vec3d normal, Vec3d cVelocity) {
        DestructibleTracker tracker;
        if (log.isDebugEnabled()) {
            log.debug("chopObject(" + objectId + ", " + loc + ", " + cVelocity + ") time:" + this.time);
        }
        if ((tracker = (DestructibleTracker)this.blocks.getObject(objectId)) == null) {
            log.warn("No tracker found for:" + objectId);
            return;
        }
        Vec3d relative = loc.subtract(tracker.pos.getLocation());
        if (log.isDebugEnabled()) {
            log.debug("relative:" + relative);
        }
        Vec3d celld = relative.mult(4.0);
        if (log.isDebugEnabled()) {
            log.debug("subcell:" + celld);
        }
        if (this.onBorder(celld)) {
            if (log.isDebugEnabled()) {
                log.debug("on border, adjusting by reverse normal");
            }
            celld.subtractLocal(normal.mult(0.1));
            if (log.isDebugEnabled()) {
                log.debug("new relative:" + celld);
            }
        }
        Vec3i cell = celld.floor();
        if (log.isDebugEnabled()) {
            log.debug("cell:" + cell);
        }
        if (cell.x >= 4 || cell.y >= 4 || cell.z >= 4) {
            log.warn("OVERFLOW:" + cell);
            return;
        }
        if (cell.x < 0 || cell.y < 0 || cell.z < 0) {
            log.warn("UNDERFLOW:" + cell);
            return;
        }
        int newValue = 0;
        int existing = MaskUtils.getType((int)tracker.cells.getCell(cell.x, cell.y, cell.z, 0));
        BlockType blockType = BlockTypeIndex.get((int)existing);
        if (blockType == null) {
            log.warn("Hit empty cell at:" + cell + " for id:" + objectId);
            return;
        }
        Collider collider = this.colliders[existing];
        ShapeSignature sig = ColliderUtils.calculateShapeSignature((Collider)collider, (double)0.125);
        Vec3d subSubCelld = celld.subtract(cell).multLocal(4.0);
        subSubCelld.subtractLocal(normal.mult(0.5));
        Vec3i subSubCell = subSubCelld.floor();
        subSubCell.maxLocal(0, 0, 0);
        subSubCell.minLocal(3, 3, 3);
        ShapeSignature find = sig.clone();
        find.unset(subSubCell.x, subSubCell.y, subSubCell.z);
        int newTypeIndex = this.shapeIndex.findSimilar(blockType, find);
        if (log.isDebugEnabled()) {
            log.debug("newType:" + newTypeIndex + "  type:" + BlockTypeIndex.get((int)newTypeIndex));
        }
        newValue = newTypeIndex;
        tracker.cells.setCell(cell.x, cell.y, cell.z, newValue);
        MaskUtils.calculateSideMasks((CellArray)tracker.cells);
        ShapeSignature newSig = new ShapeSignature(0L);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    int type = MaskUtils.getType((int)tracker.cells.getCell(i, j, k));
                    if (type == 0) continue;
                    newSig.set(i, j, k);
                }
            }
        }
        int newSigType = this.shapeIndex.findSimilar(blockType, newSig);
        if (log.isDebugEnabled()) {
            log.debug("newSigType:" + newSigType);
        }
        tracker.changeSigBlockType(newSigType);
        for (DestructibleListener l : (DestructibleListener[])this.listeners.getArray()) {
            l.cellChanged(objectId, cell.x, cell.y, cell.z, newValue);
        }
    }

    protected boolean onBorder(Vec3d loc) {
        double x = Math.abs(loc.x - (double)((int)loc.x));
        if (x < 0.01 || x > 0.99) {
            return true;
        }
        double y = Math.abs(loc.y - (double)((int)loc.y));
        if (y < 0.01 || y > 0.99) {
            return true;
        }
        double z = Math.abs(loc.z - (double)((int)loc.z));
        return z < 0.01 || z > 0.99;
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.world = (World)this.getSystem(World.class, true);
        this.blocks = new BlockContainer(this.ed);
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class, true);
        this.space = this.physics.getPhysicsSpace();
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).getBinEntityManager().addObjectStatusListener((ObjectStatusListener)this.bodyListener);
        BlockType[] types = BlockTypeIndex.getTypes();
        this.colliders = new ColliderFactories(true).createColliders(types);
        this.shapeIndex = new SimilarShapeIndex(types, this.colliders);
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null || type.getName() == null || !IGNORE_BASE_NAMES.contains(type.getName().getBase())) continue;
            this.ignoredTypes.add(i);
        }
    }

    public void start() {
        this.blocks.start();
    }

    public void update(SimTime time) {
        this.time = time;
        this.blocks.update();
        for (DestructibleTracker tracker : this.blocks.getArray()) {
            tracker.update(time);
        }
    }

    protected void terminate() {
        this.blocks.stop();
        this.physics.getBinEntityManager().removeObjectStatusListener((ObjectStatusListener)this.bodyListener);
    }

    protected boolean isDestructibleObject(StaticBody<EntityId, MBlockShape> body) {
        String name = ((MBlockShape)body.shape).getPart().getName();
        return name != null && name.endsWith(".fax");
    }

    protected void bodyLoaded(EntityId entity, StaticBody<EntityId, MBlockShape> body) {
        if (!this.isDestructibleObject(body)) {
            return;
        }
        log.info("staticObjectLoaded(" + entity + ")");
        this.bodyIndex.put(entity, body);
        DestructibleTracker tracker = (DestructibleTracker)this.blocks.getObject(entity);
        if (tracker != null) {
            tracker.updateBody(body);
        }
    }

    protected void bodyUnloaded(EntityId entity, StaticBody<EntityId, MBlockShape> body) {
        if (!this.isDestructibleObject(body)) {
            return;
        }
        log.info("staticObjectUnloaded(" + entity + ")");
        this.bodyIndex.remove(entity);
        DestructibleTracker tracker = (DestructibleTracker)this.blocks.getObject(entity);
        if (tracker != null) {
            tracker.updateBody(null);
        }
    }

    private class StaticBodyObserver
    extends ObjectStatusAdapter<MBlockShape> {
        private StaticBodyObserver() {
        }

        public void staticObjectLoaded(EntityId entity, StaticBody<EntityId, MBlockShape> body) {
            DestructibleObjectSystem.this.bodyLoaded(entity, body);
        }

        public void staticObjectUnloaded(EntityId entity, StaticBody<EntityId, MBlockShape> body) {
            DestructibleObjectSystem.this.bodyUnloaded(entity, body);
        }
    }

    private class BlockContainer
    extends EntityContainer<DestructibleTracker> {
        public BlockContainer(EntityData ed) {
            super(ed, new Class[]{DestructibleBlock.class, SpawnPosition.class});
        }

        public DestructibleTracker[] getArray() {
            return (DestructibleTracker[])super.getArray();
        }

        protected DestructibleTracker addObject(Entity entity) {
            log.info("addObject(" + entity + ")");
            DestructibleTracker tracker = new DestructibleTracker(entity);
            this.updateObject(tracker, entity);
            return tracker;
        }

        protected void updateObject(DestructibleTracker object, Entity entity) {
            log.info("updateObject(" + entity + ")");
            object.update();
        }

        protected void removeObject(DestructibleTracker object, Entity entity) {
            log.info("removeObject(" + entity + ")");
            object.release();
        }
    }

    private class DestructibleTracker {
        private Entity entity;
        private SpawnPosition pos;
        private DestructibleBlock block;
        private CellArray cells;
        private StaticBody<EntityId, MBlockShape> body;
        private boolean closing;

        public DestructibleTracker(Entity entity) {
            this.entity = entity;
            this.block = (DestructibleBlock)entity.get(DestructibleBlock.class);
            this.cells = DestructibleObjectSystem.this.shapeIndex.createFacsimile(this.block.getBlockType());
            if (this.cells == null) {
                this.cells = new CellArray(4);
                this.cells.clear(BlockTypeIndex.getBadTypeIndex());
            }
            this.updateBody((StaticBody<EntityId, MBlockShape>)((StaticBody)DestructibleObjectSystem.this.bodyIndex.get(entity.getId())));
            Runnable r = (Runnable)DestructibleObjectSystem.this.initializers.remove(entity.getId());
            if (r != null) {
                DestructibleObjectSystem.this.getManager().enqueue(() -> {
                    r.run();
                    return false;
                });
            }
        }

        public void changeSigBlockType(int sigBlockType) {
            if (this.block.getBlockType() == sigBlockType) {
                return;
            }
            this.block = this.block.changeType(sigBlockType, DestructibleObjectSystem.this.time.getFutureTime((double)DestructibleObjectSystem.this.expiration));
            this.entity.set((EntityComponent)this.block);
        }

        public void updateBody(StaticBody<EntityId, MBlockShape> body) {
            log.info("updateBody(" + this.entity.getId() + ")");
            this.body = body;
            this.updateBodyCells();
        }

        public void update(SimTime time) {
            if (time.getTime() > this.block.getExpirationTime()) {
                if (!this.closing) {
                    DestructibleObjectSystem.this.world.setWorldCell(this.pos.getLocation(), this.block.getBlockType());
                    this.closing = true;
                    return;
                }
                DestructibleObjectSystem.this.ed.removeEntity(this.entity.getId());
            }
        }

        public void update() {
            DestructibleBlock newBlock = (DestructibleBlock)this.entity.get(DestructibleBlock.class);
            if (newBlock != this.block) {
                this.block = newBlock;
            }
            this.pos = (SpawnPosition)this.entity.get(SpawnPosition.class);
            this.updateBodyCells();
        }

        protected void updateBodyCells() {
            log.info("updateCells(" + this.entity.getId() + ")");
            if (this.body != null) {
                ((CellArrayPart)((MBlockShape)this.body.shape).getPart()).setCells(this.cells);
            }
        }

        public void release() {
        }
    }
}

