/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import java.util.HashMap;
import java.util.Map;
import mythruna.world.tile.LocalRegion;
import mythruna.world.tile.WorldRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldRegionIndex {
    static Logger log = LoggerFactory.getLogger(WorldRegionIndex.class);
    private Map<Long, WorldRegion> index = new HashMap<Long, WorldRegion>();
    private long nextId;

    public WorldRegion getRegion(long worldRegionId) {
        return this.index.get(worldRegionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldRegion createRegion() {
        Map<Long, WorldRegion> map = this.index;
        synchronized (map) {
            WorldRegion result = new WorldRegion(this.nextId++);
            this.index.put(result.getId(), result);
            return result;
        }
    }

    public LocalRegion merge(LocalRegion region1, LocalRegion region2) {
        Map<Long, WorldRegion> map = this.index;
        synchronized (map) {
            long id1 = region1.getWorldRegionId();
            long id2 = region2.getWorldRegionId();
            if (id1 == id2) {
                log.warn("Regions are already merged, region1:" + region1 + ", region2:" + region2);
                return null;
            }
            WorldRegion world1 = this.index.get(id1);
            if (world1 == null) {
                throw new IllegalArgumentException("No world region found for:" + region1);
            }
            WorldRegion world2 = this.index.get(id2);
            if (world2 == null) {
                throw new IllegalArgumentException("No world region found for:" + region2);
            }
            if (id1 < id2) {
                world2.removeChildRegion(region2);
                world1.addChildRegion(region2);
                if (world2.isEmpty()) {
                    this.index.remove(id2);
                }
                return region2;
            }
            if (id2 < id1) {
                world1.removeChildRegion(region1);
                world2.addChildRegion(region1);
                if (world1.isEmpty()) {
                    this.index.remove(id1);
                }
                return region1;
            }
            throw new IllegalStateException("Somehow we have equals IDs, region1:" + region1 + ", region2:" + region2);
        }
    }
}

