/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.collision.ShapeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderUtils {
    static Logger log = LoggerFactory.getLogger(ColliderUtils.class);

    public static ShapeSignature calculateShapeSignature(Collider collider, double probeRadius) {
        ShapeSignature result = new ShapeSignature(0L);
        double spacing = 0.25;
        double offset = spacing * 0.5;
        Vec3d cellPos = new Vec3d();
        Vec3d pos = new Vec3d();
        for (int i = 0; i < 4; ++i) {
            pos.x = (double)i * spacing + offset;
            for (int j = 0; j < 4; ++j) {
                pos.y = (double)j * spacing + offset;
                for (int k = 0; k < 4; ++k) {
                    pos.z = (double)k * spacing + offset;
                    MBlockContact contact = null;
                    if (collider != null) {
                        contact = collider.getSphereContact(cellPos, pos, probeRadius, 255);
                    }
                    if (contact == null) continue;
                    result.set(i, j, k);
                }
            }
        }
        return result;
    }

    public static long calculateShapeSignatureBits(Collider collider, double probeRadius) {
        double spacing = 0.25;
        long result = 0L;
        long toggleBit = 1L;
        Vec3d cellPos = new Vec3d();
        Vec3d pos = new Vec3d();
        for (int i = 0; i < 4; ++i) {
            pos.x = (double)i * spacing + probeRadius;
            for (int j = 0; j < 4; ++j) {
                pos.y = (double)j * spacing + probeRadius;
                for (int k = 0; k < 4; ++k) {
                    pos.z = (double)k * spacing + probeRadius;
                    MBlockContact contact = null;
                    if (collider != null) {
                        contact = collider.getSphereContact(cellPos, pos, probeRadius, 255);
                    }
                    if (contact != null) {
                        result |= toggleBit;
                    }
                    if ((toggleBit <<= 1) == ColliderUtils.getToggleBit(i, j, k)) continue;
                    log.error("Very bad things:\n" + Long.toBinaryString(toggleBit) + "\n" + ColliderUtils.getToggleBit(i, j, k));
                }
            }
        }
        return result;
    }

    protected static int index(int i, int j, int k) {
        return i * 16 + j * 4 + k;
    }

    protected static long getToggleBit(int i, int j, int k) {
        return 1L << ColliderUtils.index(i, j, k);
    }
}

