/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.insert.BlockInsert;
import com.simsilica.mworld.tile.insert.InsertLayer;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mythruna.GameConstants;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.OwnedBy;
import mythruna.es.StructureInfo;
import mythruna.es.TriggerInfo;
import mythruna.world.BioInfo;
import mythruna.world.WorldFractal;
import mythruna.world.tile.FeatureId;
import mythruna.world.tile.Sedectile;
import mythruna.world.tile.SedectileManager;
import mythruna.world.town.InsertInfo;
import mythruna.world.town.PointOfInterest;
import mythruna.world.town.TestBlockRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPoiTileFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(TestPoiTileFunction.class);
    private static int TYPE_SNOW = 0;
    private static int TYPE_MODERATE = 1;
    private static int TYPE_DESERT = 2;
    private static int MAX_TYPE = 3;
    private static int LEVEL_PROPER_IDS = 1;
    private static String DEFAULT_BLOCKS = "spawn-tower.blocks";
    private static BuildingTypeIndex[] typeIndexes = new BuildingTypeIndex[MAX_TYPE];
    private SedectileManager sedectileManager;
    private EntityData ed;
    private WorldFractal fractal;
    private Vec3d spawnLoc;
    private TileId spawnTileId;
    private TestBlockRegistry blocksRegistry;

    public TestPoiTileFunction(SedectileManager sedectileManager, EntityData ed, TestBlockRegistry blocksRegistry, Vec3d spawnLoc, WorldFractal fractal) {
        this.sedectileManager = sedectileManager;
        this.ed = ed;
        this.blocksRegistry = blocksRegistry;
        this.spawnLoc = spawnLoc;
        this.spawnTileId = TileId.fromWorld((double)spawnLoc.x, (double)spawnLoc.y, (double)spawnLoc.z);
        this.fractal = fractal;
    }

    public void accept(Tile tile) {
        TileId tileId = tile.getTileId();
        if (tile.getResolution() != Resolution.High) {
            this.sedectileManager.getSedectile(tileId.getSedectileId());
            return;
        }
        InsertLayer inserts = (InsertLayer)tile.get(InsertLayer.class);
        int genLevel = inserts.getGenerationLevel();
        boolean upgradeIds = false;
        int upgradeCount = 0;
        if (inserts.getVersion().getLoadVersion() >= 0L) {
            if (genLevel < LEVEL_PROPER_IDS) {
                log.info("Need to upgrade block insert IDs and add structure info to:" + tileId);
                upgradeIds = true;
            } else {
                return;
            }
        }
        genLevel = LEVEL_PROPER_IDS;
        inserts.setGenerationLevel(genLevel);
        TreeLayer trees = (TreeLayer)tile.get(TreeLayer.class);
        if (trees == null) {
            log.warn("Trees have not been generated yet?");
        }
        Vec3i origin = tileId.getWorld(null);
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        Sedectile sedectile = this.sedectileManager.getSedectile(tileId.getSedectileId());
        ListMultimap<Vec3i, EntityId> structureEntities = this.loadTileStructureEntities(tileId);
        ObjectTypeInfo limitsType = ObjectTypeInfo.create("PoiLimits", this.ed);
        for (FeatureId<PointOfInterest> id : sedectile.getFeatureIds(tileId, PointOfInterest.class)) {
            PointOfInterest poi = this.sedectileManager.getFeatures().getFeature(id, PointOfInterest.class);
            if (upgradeIds) {
                log.info("Upgrading:" + poi);
            }
            Random rand = new Random(id.getId());
            EntityId parentEntity = new EntityId(id.getId());
            boolean isIdentityPoi = poi.getChildren().length == 1;
            Vec3i min = new Vec3i();
            Vec3i max = new Vec3i();
            Vec3i center = PointOfInterest.calculateRange(poi.getChildren(), min, max);
            TileId poiTile = TileId.fromWorld((Vec3i)poi.getLocation());
            if (tileId.getId() == poiTile.getId() && !isIdentityPoi) {
                int inner;
                double radius = Math.max(min.distance(poi.getLocation()), max.distance(poi.getLocation()));
                int plus = inner = (int)Math.ceil(radius);
                log.info("Setting POI:" + parentEntity + " trigger for:" + poi.getLocation() + " radius:" + inner);
                this.ed.setComponents(parentEntity, new EntityComponent[]{TriggerInfo.create(tileId, 0, inner + plus), ObjectTypeInfo.create(poi.getType(), this.ed)});
                EntityId limits = this.findTownLimits(parentEntity, limitsType);
                if (limits == null) {
                    log.info("Creating POI limits entity...");
                    limits = this.ed.createEntity();
                }
                Vec3i size = max.subtract(min);
                size.y += 128;
                log.info("Setting POI limits for:" + min + " radius:" + size);
                this.ed.setComponents(limits, new EntityComponent[]{new SpawnPosition(GameConstants.PHYSICS_GRID, min.toVec3d()), TriggerInfo.create(TileId.fromWorld((Vec3i)min), size.x, size.y, size.z, 0), new OwnedBy(parentEntity), limitsType});
            }
            if (trees != null) {
                min.subtractLocal(origin);
                max.subtractLocal(origin);
                List list = trees.getTrees();
                for (int i = 0; i < list.size(); ++i) {
                    Tree tree = (Tree)list.get(i);
                    if (tree.x < min.x || tree.z < min.z || tree.x > max.x || tree.z > max.z || !trees.removeTree(tree)) continue;
                    --i;
                }
            }
            BioInfo bio = new BioInfo();
            for (InsertInfo info : poi.getChildren()) {
                String type = info.getType();
                if (upgradeIds) {
                    log.info("    child:" + info);
                }
                TestBlockRegistry.BuildingFactory factory = null;
                if ("spawn".equals(type)) {
                    factory = this.blocksRegistry.getSpawnTower();
                } else {
                    Vec3i loc = info.getLocation();
                    bio = this.fractal.getBioInfo(loc.x, loc.y, loc.z, bio);
                    int indexType = TYPE_MODERATE;
                    if (bio.vegetationLevel <= 0.1 && bio.temperature > 0.5) {
                        indexType = TYPE_DESERT;
                    } else if (bio.temperature <= 0.2857 && bio.precipitation > 0.167) {
                        indexType = TYPE_SNOW;
                    }
                    BuildingTypeIndex types = typeIndexes[indexType];
                    String factoryId = types.getRandom(type, rand);
                    factory = this.blocksRegistry.getFactory(factoryId);
                    if (factory == null) {
                        log.error("No factory defined for:" + factoryId + " from:" + type);
                        factory = this.blocksRegistry.getFactory(DEFAULT_BLOCKS);
                    }
                }
                BlockDataId blockDataId = info.getFacing() != -1 ? this.blocksRegistry.getRandomFixedFacing(factory.name, info.getFacing(), rand) : this.blocksRegistry.getRandomOrientation(factory.name, rand);
                int carveFlags = 2;
                BlockData data = this.blocksRegistry.apply(blockDataId);
                Vec3i loc = null;
                int xSize = data.getCells().getSizeX();
                int ySize = data.getCells().getSizeY();
                int zSize = data.getCells().getSizeZ();
                loc = "spawn".equals(type) ? info.getLocation() : info.getLocation();
                loc = loc.add(0, -factory.yOffset, 0);
                if (!this.intersects(origin, loc, xSize, zSize)) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Skipping out of tile:" + loc + " size:" + data.getCells().getSize());
                    continue;
                }
                List existing = structureEntities.get((Object)loc);
                EntityId structure = null;
                if (existing.isEmpty()) {
                    if (log.isTraceEnabled()) {
                        log.trace("creating entity for " + factory.name);
                    }
                    structure = this.ed.createEntity();
                } else if (existing.size() == 1) {
                    if (log.isTraceEnabled()) {
                        log.trace("reusing existing entity:" + structure + " for " + factory.name);
                    }
                    structure = (EntityId)existing.get(0);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("disambiguating entity at location:" + loc);
                    }
                    for (EntityId ei : existing) {
                        StructureInfo structurInfo = (StructureInfo)this.ed.getComponent(ei, StructureInfo.class);
                        if (!blockDataId.equals((Object)structurInfo.getBlockDataId())) continue;
                        if (log.isTraceEnabled()) {
                            log.trace("found entity:" + ei);
                        }
                        structure = ei;
                        break;
                    }
                    if (structure == null) {
                        log.warn("Location:" + loc + " has multiple structures but none matched:" + blockDataId);
                        structure = this.ed.createEntity();
                        if (log.isTraceEnabled()) {
                            log.trace("creating another entity for " + factory.name);
                        }
                    }
                }
                int approachDistance = Math.min(xSize, zSize);
                this.ed.setComponents(structure, new EntityComponent[]{new SpawnPosition(GameConstants.PHYSICS_GRID, loc.toVec3d()), StructureInfo.create(factory.name, blockDataId, tileId, parentEntity, this.ed), TriggerInfo.create(tileId, xSize, ySize, zSize, approachDistance), ObjectTypeInfo.create("Structure", this.ed)});
                if (!upgradeIds) {
                    if (log.isDebugEnabled()) {
                        log.debug("Create BlockInsert at:" + loc);
                    }
                    inserts.addInsert(new BlockInsert(loc, blockDataId, carveFlags, xSize, ySize, zSize, factory.aboveGround, factory.groundLevel, structure.getId()));
                    continue;
                }
                log.info("Need to upgrade block insert at:" + loc + "  blockDataId:" + blockDataId);
                List list = inserts.getInserts();
                boolean found = false;
                for (BlockInsert insert : list) {
                    if (!insert.world.equals((Object)loc)) continue;
                    if (Objects.equals(blockDataId, insert.blockDataId)) {
                        log.info("Upgrading:" + insert + " to entityId:" + structure);
                        insert.objectId = structure.getId();
                        found = true;
                        break;
                    }
                    log.warn("Found block data but blockDataId didn't match:" + blockDataId);
                }
                if (!found) {
                    log.warn("Never found an insert for:" + loc + "  blockDataId:" + blockDataId + "  tileOrigin:" + origin + " feature size:" + data.getCells().getSize());
                    continue;
                }
                ++upgradeCount;
            }
        }
        if (upgradeCount > 0) {
            log.info("Upgraded:" + upgradeCount + "inserts, marking layer changed for:" + tileId);
            inserts.getVersion().markChanged();
        }
    }

    protected boolean intersects(Vec3i tileOrigin, Vec3i world, int xSize, int zSize) {
        int xMin = world.x - tileOrigin.x;
        int zMin = world.z - tileOrigin.z;
        int xMax = xMin + xSize;
        int zMax = zMin + zSize;
        if (xMax < 0 || zMax < 0) {
            return false;
        }
        return xMin < 1024 && zMin < 1024;
    }

    protected ListMultimap<Vec3i, EntityId> loadTileStructureEntities(TileId tileId) {
        ListMultimap map = MultimapBuilder.hashKeys().arrayListValues().build();
        for (EntityId id : this.ed.findEntities(StructureInfo.tileFilter(tileId), new Class[]{StructureInfo.class, SpawnPosition.class})) {
            SpawnPosition pos = (SpawnPosition)this.ed.getComponent(id, SpawnPosition.class);
            map.put((Object)pos.getLocation().floor(), (Object)id);
        }
        return map;
    }

    protected EntityId findTownLimits(EntityId townId, ObjectTypeInfo type) {
        int typeId = type.getTypeId();
        for (EntityId id : this.ed.findEntities(OwnedBy.filter(townId), new Class[]{OwnedBy.class, TriggerInfo.class, ObjectTypeInfo.class})) {
            ObjectTypeInfo typeInfo = (ObjectTypeInfo)this.ed.getComponent(id, ObjectTypeInfo.class);
            if (typeInfo.getTypeId() != typeId) continue;
            return id;
        }
        return null;
    }

    static {
        BuildingTypeIndex index = TestPoiTileFunction.typeIndexes[TestPoiTileFunction.TYPE_SNOW] = new BuildingTypeIndex();
        index.map("cliff1", "ruined-cobble-hut.blocks", "small-stone-ruin.blocks", "stone-cairn.blocks");
        index.map("cliff2", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("cliff3", "domed-temple.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks", "giant-skull-insides.blocks");
        index.map("isolated1", "small-stone-ruin.blocks", "test-path1.blocks", "test-path2.blocks", "pumpkin-altar.blocks");
        index.map("isolated2", "stone-cairn.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("isolated3", "domed-temple.blocks", "dungeon-stairs.blocks", "roman-temple2.blocks", "stone-canopy.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks");
        index.map("well", "sm-well1.blocks", "sm-well2.blocks");
        index.map("building1", "test-bldg8.blocks", "test-bldg8-b.blocks");
        index.map("building2", "a-frame-proto.blocks", "a-frame-proto.blocks", "a-frame-proto.blocks", "lg-farmhouse.blocks", "test-bldg1.blocks", "test-bldg2.blocks", "test-bldg7.blocks");
        index.map("building3", "test-bldg5.blocks", "test-bldg6.blocks");
        index.map("garden", "plowed-rows.blocks");
        index.map("corn", "plowed-rows.blocks");
        index.map("gallows", "gallows1.blocks");
        index.map("graves", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("tower1", "keep1.blocks", "single-tower.blocks", "tower2.blocks");
        index.map("airport1", "small-airport.blocks");
        index.map("temple1", "stone-canopy.blocks");
        index.map("temple2", "roman-temple2.blocks", "domed-temple.blocks");
        index.map("farm1", "thatch-cottage.blocks");
        index.map("farm2", "test-bldg3.blocks", "test-bldg4.blocks");
        index.map("farm3", "lg-farmhouse.blocks");
        index = TestPoiTileFunction.typeIndexes[TestPoiTileFunction.TYPE_MODERATE] = new BuildingTypeIndex();
        index.map("cliff1", "ruined-cobble-hut.blocks", "small-stone-ruin.blocks", "stone-cairn.blocks");
        index.map("cliff2", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("cliff3", "domed-temple.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks", "giant-skull-insides.blocks");
        index.map("isolated1", "fence-low.blocks", "fence-tall.blocks", "small-stone-ruin.blocks", "tree-stump.blocks", "tree-stump2.blocks", "sm-well1.blocks", "sm-well2.blocks", "test-path1.blocks", "test-path2.blocks", "pumpkin-altar.blocks");
        index.map("isolated2", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks", "stone-cairn.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("isolated3", "domed-temple.blocks", "dungeon-stairs.blocks", "roman-temple2.blocks", "stone-canopy.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks");
        index.map("well", "sm-well1.blocks", "sm-well2.blocks");
        index.map("building1", "test-bldg3.blocks", "test-bldg4.blocks", "test-bldg7.blocks", "lg-farmhouse.blocks");
        index.map("building2", "test-bldg1.blocks", "test-bldg2.blocks");
        index.map("building3", "test-bldg5.blocks", "test-bldg6.blocks");
        index.map("garden", "corn-rows.blocks");
        index.map("corn", "corn-rows.blocks");
        index.map("gallows", "gallows1.blocks");
        index.map("graves", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("tower1", "keep1.blocks", "single-tower.blocks", "tower2.blocks");
        index.map("airport1", "small-airport.blocks");
        index.map("temple1", "stone-canopy.blocks");
        index.map("temple2", "roman-temple2.blocks", "domed-temple.blocks");
        index.map("farm1", "thatch-cottage.blocks");
        index.map("farm2", "test-bldg3.blocks", "test-bldg4.blocks");
        index.map("farm3", "lg-farmhouse.blocks");
        index = TestPoiTileFunction.typeIndexes[TestPoiTileFunction.TYPE_DESERT] = new BuildingTypeIndex();
        index.map("cliff1", "ruined-cobble-hut.blocks", "small-stone-ruin.blocks", "stone-cairn.blocks");
        index.map("cliff2", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("cliff3", "domed-temple.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks", "giant-skull-insides.blocks");
        index.map("isolated1", "fence-low.blocks", "fence-tall.blocks", "small-stone-ruin.blocks", "sm-well1.blocks", "sm-well2.blocks", "test-path1.blocks", "test-path2.blocks");
        index.map("isolated2", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks", "stone-cairn.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("isolated3", "domed-temple.blocks", "dungeon-stairs.blocks", "roman-temple2.blocks", "stone-canopy.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks");
        index.map("well", "sm-well1.blocks", "sm-well2.blocks");
        index.map("building1", "test-bldg8.blocks", "test-bldg8-b.blocks");
        index.map("building2", "lg-farmhouse.blocks", "test-bldg1.blocks", "test-bldg2.blocks");
        index.map("building3", "test-bldg5.blocks", "test-bldg6.blocks");
        index.map("garden", "plowed-rows.blocks");
        index.map("corn", "plowed-rows.blocks");
        index.map("gallows", "gallows1.blocks");
        index.map("graves", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("tower1", "keep1.blocks", "single-tower.blocks", "tower2.blocks");
        index.map("airport1", "small-airport.blocks");
        index.map("temple1", "stone-canopy.blocks");
        index.map("temple2", "roman-temple2.blocks", "domed-temple.blocks");
        index.map("farm1", "test-bldg8.blocks", "test-bldg8-b.blocks");
        index.map("farm2", "test-bldg3.blocks", "test-bldg4.blocks");
        index.map("farm3", "lg-farmhouse.blocks");
    }

    private static class BuildingTypeIndex {
        private ListMultimap<String, String> index = MultimapBuilder.hashKeys().arrayListValues().build();

        private BuildingTypeIndex() {
        }

        public void map(String type, String ... blocks) {
            for (String b : blocks) {
                this.index.put((Object)type, (Object)b);
            }
        }

        public String getRandom(String type, Random rand) {
            List list = this.index.get((Object)type);
            if (list == null || list.isEmpty()) {
                log.error("Unmapped type:" + type);
                return DEFAULT_BLOCKS;
            }
            int i = rand.nextInt(list.size());
            return (String)list.get(i);
        }
    }
}

