/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import org.progeeks.map.AbstractNoiseElevationGenerator;

public class MultiFractalElevations
extends AbstractNoiseElevationGenerator {
    private int heightScale = 15000;
    private double fractalIncrement = 0.5;
    private double lacunarity = 3.02;
    private int octaves = 6;
    private double offset = 0.31;
    private double gain = 4.0;
    private int maxOctaves = 128;
    private double[] exponents = new double[this.maxOctaves];

    public MultiFractalElevations() {
        super("Multi-Fractal");
        this.setFrequency(512);
        this.setElevationOffset(0);
    }

    @Override
    protected void reinitialize() {
        for (int i = 0; i < this.maxOctaves; ++i) {
            this.exponents[i] = Math.pow(this.lacunarity, (double)(-i) * this.fractalIncrement);
        }
    }

    public void setFractalIncrement(double d) {
        if (this.fractalIncrement == d) {
            return;
        }
        this.fractalIncrement = d;
        this.invalidate();
    }

    public double getFractalIncrement() {
        return this.fractalIncrement;
    }

    public void setLacunarity(double d) {
        if (this.lacunarity == d) {
            return;
        }
        this.lacunarity = d;
        this.invalidate();
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public void setOctaves(int d) {
        if (this.octaves == d) {
            return;
        }
        this.octaves = d;
        this.invalidate();
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setGain(double d) {
        if (this.gain == d) {
            return;
        }
        this.gain = d;
        this.invalidate();
    }

    public double getGain() {
        return this.gain;
    }

    public void setOffset(double d) {
        if (this.offset == d) {
            return;
        }
        this.offset = d;
        this.invalidate();
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    protected double getElevation(double x, double y, double z) {
        int i;
        double value = this.noise.getNoise(x, y, z) + this.offset;
        double weight = this.gain * value;
        x *= this.lacunarity;
        y *= this.lacunarity;
        z *= this.lacunarity;
        for (i = 1; weight > 0.001 && i < this.octaves; ++i) {
            if (weight > 1.0) {
                weight = 1.0;
            }
            double signal = (this.noise.getNoise(x, y, z) + this.offset) * this.exponents[i];
            value += weight * signal;
            weight *= this.gain * signal;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        double remainder = this.octaves - this.octaves;
        if (remainder != 0.0) {
            value += remainder * this.noise.getNoise(x, y, z) * this.exponents[i];
        }
        return value;
    }
}

