/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.Axis;

public enum Direction {
    North(new Vec3i(0, 0, -1), new Vec3i(1, 0, 0), new Vec3i(0, 1, 0), 0, Axis.Z, 1),
    South(new Vec3i(0, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(0, 1, 0), 2, Axis.Z, 2),
    East(new Vec3i(1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, 1, 0), 1, Axis.X, 4),
    West(new Vec3i(-1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 1, 0), 3, Axis.X, 8),
    Up(new Vec3i(0, 1, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, 1), -1, Axis.Y, 16),
    Down(new Vec3i(0, -1, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), -1, Axis.Y, 32);

    private Axis axis;
    private int cardinalDir;
    private int dirMask;
    private Vec3i vec3i;
    private Vec3i right;
    private Vec3i up;
    private static Direction[] cardinalDirections;
    private static final Quatd[] ROT;

    private Direction(Vec3i vec3i, Vec3i right, Vec3i up, int cardinalDir, Axis axis, int dirMask) {
        this.vec3i = vec3i;
        this.right = right;
        this.up = up;
        this.cardinalDir = cardinalDir;
        this.axis = axis;
        this.dirMask = dirMask;
    }

    public Vec3i getVec3i() {
        return this.vec3i;
    }

    public Vec3i getRight() {
        return this.right;
    }

    public Vec3i getUp() {
        return this.up;
    }

    public int getBitMask() {
        return this.dirMask;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getCardinalDirection() {
        return this.cardinalDir;
    }

    public Direction reverse() {
        switch (this) {
            case North: {
                return South;
            }
            case South: {
                return North;
            }
            case East: {
                return West;
            }
            case West: {
                return East;
            }
            case Up: {
                return Down;
            }
            case Down: {
                return Up;
            }
        }
        throw new UnsupportedOperationException("Unhandled type:" + (Object)((Object)this));
    }

    public boolean isCardinal() {
        return this.ordinal() < 4;
    }

    public static Direction cardinalDirection(int d) {
        return cardinalDirections[d];
    }

    public Direction rotate(int dirDelta) {
        if (this == Up || this == Down) {
            return this;
        }
        int d = (this.cardinalDir + dirDelta) % 4;
        if (d < 0) {
            d += 4;
        }
        return cardinalDirections[d];
    }

    public static Quatd getRotation(int dirDelta) {
        if (dirDelta < 0) {
            dirDelta = dirDelta % ROT.length + ROT.length;
        }
        return ROT[dirDelta % ROT.length];
    }

    public boolean matches(Vec3d dir) {
        return this.matches(dir, 0.001);
    }

    public boolean matches(Vec3d dir, double epsilon) {
        if (Math.abs(dir.x - (double)this.vec3i.x) > epsilon) {
            return false;
        }
        if (Math.abs(dir.y - (double)this.vec3i.y) > epsilon) {
            return false;
        }
        return !(Math.abs(dir.z - (double)this.vec3i.z) > epsilon);
    }

    public static Direction findDirection(Vec3d dir, double epsilon) {
        if (North.matches(dir, epsilon)) {
            return North;
        }
        if (South.matches(dir, epsilon)) {
            return South;
        }
        if (East.matches(dir, epsilon)) {
            return East;
        }
        if (West.matches(dir, epsilon)) {
            return West;
        }
        if (Up.matches(dir, epsilon)) {
            return Up;
        }
        if (Down.matches(dir, epsilon)) {
            return Down;
        }
        return null;
    }

    static {
        cardinalDirections = new Direction[]{North, East, South, West};
        ROT = new Quatd[]{new Quatd().fromAngles(0.0, 0.0, 0.0), new Quatd().fromAngles(0.0, -1.5707963267948966, 0.0), new Quatd().fromAngles(0.0, -Math.PI, 0.0), new Quatd().fromAngles(0.0, -4.71238898038469, 0.0)};
    }
}

