/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarFabricIndex {
    static Logger log = LoggerFactory.getLogger(SimilarFabricIndex.class);
    private Map<String, List<Integer>> fabricSets = new HashMap<String, List<Integer>>();

    public SimilarFabricIndex(boolean setupDefaults) {
        if (setupDefaults) {
            this.makeCompatible("linen", "wool", "twill", "burlap");
            this.makeCompatible("plaid");
            this.makeCompatible("leather");
            this.makeCompatible("suede", "fur");
            this.makeCompatible("metal");
            this.makeCompatible("chainmail");
        }
    }

    public void makeCompatible(String ... array) {
        HashSet<String> types = new HashSet<String>(Arrays.asList(array));
        if (log.isTraceEnabled()) {
            log.trace("makeCompatible(" + types + ")");
        }
        ArrayList<Integer> compatible = new ArrayList<Integer>();
        int count = FabricTypeIndex.getTypeCount();
        for (int i = 0; i < count; ++i) {
            FabricType type = FabricTypeIndex.get(i);
            if (type == null || !types.contains(type.getName())) continue;
            if (log.isTraceEnabled()) {
                log.trace("  adding:" + type.getFullName());
            }
            compatible.add(i);
        }
        for (String s : array) {
            this.fabricSets.put(s, compatible);
        }
    }

    public int getRandomType(FabricType type, Random rand) {
        List<Integer> compatible = this.fabricSets.get(type.getName());
        return compatible.get(rand.nextInt(compatible.size()));
    }
}

