/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.RayHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CylinderCollider<K>
implements Collider<K> {
    static Logger log = LoggerFactory.getLogger(CylinderCollider.class);
    private Vec3d center;
    private Vec3d axisDir;
    private Vec3d xDir;
    private Vec3d yDir;
    private double extent;
    private double cylinderRadius;
    private double cylinderRadiusSq;
    private int axisPosMask;
    private int axisNegMask;

    public CylinderCollider(Vec3d center, Vec3d axisDir, Vec3d xDir, Vec3d yDir, double extent, double cylinderRadius) {
        this.center = center;
        this.axisDir = axisDir;
        this.xDir = xDir;
        this.yDir = yDir;
        this.extent = extent;
        this.cylinderRadius = cylinderRadius;
        this.cylinderRadiusSq = cylinderRadius * cylinderRadius;
        Direction axis = Direction.findDirection((Vec3d)axisDir, (double)0.001);
        if (axis != null) {
            this.axisPosMask = axis.getBitMask();
            this.axisNegMask = axis.reverse().getBitMask();
        }
    }

    @Override
    public MBlockContact<K> getSphereContact(Vec3d cellPos, Vec3d pos, double radius, int dirMask) {
        double d;
        Vec3d worldCenter = cellPos.add(this.center);
        Vec3d centerRelative = pos.subtract(worldCenter);
        double x = this.xDir.dot(centerRelative);
        double y = this.yDir.dot(centerRelative);
        double z = this.axisDir.dot(centerRelative);
        double zAbs = Math.abs(z);
        if (zAbs - radius > this.extent) {
            return null;
        }
        double dSq = x * x + y * y;
        double rSq = this.cylinderRadius + radius;
        if (dSq > (rSq *= rSq)) {
            return null;
        }
        Vec3d cp = null;
        Vec3d norm = null;
        double penetration = 0.0;
        if (Math.abs(z) < this.extent && dSq < this.cylinderRadiusSq) {
            d = Math.sqrt(dSq);
            double sidePen = this.cylinderRadius - (d - radius);
            double posPen = this.extent - z;
            double negPen = this.extent + z;
            if (z > 0.0 && (dirMask & this.axisPosMask) != 0 && posPen < sidePen) {
                cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(this.extent));
                cp = cp.addLocal(this.center);
                penetration = this.extent - (z - radius);
                norm = this.axisDir.clone();
            } else if (z < 0.0 && (dirMask & this.axisPosMask) != 0 && negPen < sidePen) {
                cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(-this.extent));
                cp = cp.addLocal(this.center);
                penetration = this.extent + (z + radius);
                norm = this.axisDir.mult(-1.0);
            } else if (d == 0.0) {
                cp = this.center.add(this.axisDir.mult(z));
                norm = this.xDir;
            } else {
                x = x / d * this.cylinderRadius;
                y = y / d * this.cylinderRadius;
                cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(z));
                cp = cp.addLocal(this.center);
                penetration = this.cylinderRadius - (d - radius);
                norm = this.xDir.mult(x).addLocal(this.yDir.mult(y));
            }
        } else if (z > this.extent && (dirMask & this.axisPosMask) != 0) {
            if (dSq <= this.cylinderRadiusSq) {
                cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(this.extent));
                cp = cp.addLocal(this.center);
                penetration = this.extent - (z - radius);
                norm = this.axisDir.clone();
            } else {
                d = Math.sqrt(dSq);
                x = x / d * this.cylinderRadius;
                y = y / d * this.cylinderRadius;
                cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(this.extent));
                norm = centerRelative.subtractLocal(cp);
                cp = cp.addLocal(this.center);
                double cpDist = norm.length();
                norm.multLocal(1.0 / cpDist);
                penetration = radius - cpDist;
            }
        } else if (z < -this.extent && (dirMask & this.axisNegMask) != 0) {
            if (dSq <= this.cylinderRadiusSq) {
                cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(-this.extent));
                cp = cp.addLocal(this.center);
                penetration = this.extent + (z + radius);
                norm = this.axisDir.mult(-1.0);
            } else {
                d = Math.sqrt(dSq);
                x = x / d * this.cylinderRadius;
                y = y / d * this.cylinderRadius;
                cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(-this.extent));
                norm = centerRelative.subtractLocal(cp);
                cp = cp.addLocal(this.center);
                double cpDist = norm.length();
                norm.multLocal(1.0 / cpDist);
                penetration = radius - cpDist;
            }
        } else if (zAbs <= this.extent) {
            d = Math.sqrt(dSq);
            x = x / d * this.cylinderRadius;
            y = y / d * this.cylinderRadius;
            cp = this.xDir.mult(x).addLocal(this.yDir.mult(y)).addLocal(this.axisDir.mult(z));
            cp = cp.addLocal(this.center);
            penetration = this.cylinderRadius - (d - radius);
            norm = this.xDir.mult(x).addLocal(this.yDir.mult(y));
        }
        if (cp == null) {
            return null;
        }
        MBlockContact result = new MBlockContact();
        result.contactPoint = cp.addLocal(cellPos);
        result.contactNormal = norm;
        result.penetration = penetration;
        return result;
    }

    @Override
    public MBlockContact<K> getCubeContact(Vec3d cellOrigin, Vec3d pos, double radius, int dirMask) {
        return this.getSphereContact(cellOrigin, pos, radius, dirMask);
    }

    @Override
    public RayHit getHit(Vec3d origin, Vec3d dir, int dirMask, RayHit store) {
        int i;
        int i2;
        Vec3d min = this.center.subtract(this.cylinderRadius, this.extent, this.cylinderRadius);
        Vec3d max = this.center.add(this.cylinderRadius, this.extent, this.cylinderRadius);
        boolean inside = true;
        int[] quadrant = new int[3];
        double[] maxT = new double[3];
        double[] candidatePlane = new double[3];
        for (i2 = 0; i2 < 3; ++i2) {
            if (origin.get(i2) < min.get(i2)) {
                quadrant[i2] = 1;
                candidatePlane[i2] = min.get(i2);
                inside = false;
                continue;
            }
            if (origin.get(i2) > max.get(i2)) {
                quadrant[i2] = 0;
                candidatePlane[i2] = max.get(i2);
                inside = false;
                continue;
            }
            quadrant[i2] = 2;
        }
        if (inside) {
            return null;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            maxT[i2] = quadrant[i2] != 2 && dir.get(i2) != 0.0 ? (candidatePlane[i2] - origin.get(i2)) / dir.get(i2) : -1.0;
        }
        int whichPlane = 0;
        for (i = 1; i < 3; ++i) {
            if (!(maxT[i] > maxT[whichPlane])) continue;
            whichPlane = i;
        }
        if (maxT[whichPlane] < 0.0) {
            return null;
        }
        if (store == null) {
            store = new RayHit();
        }
        for (i = 0; i < 3; ++i) {
            if (whichPlane != i) {
                store.point.set(i, origin.get(i) + maxT[whichPlane] * dir.get(i));
                store.normal.set(i, 0.0);
                if (!(store.point.get(i) < min.get(i)) && !(store.point.get(i) > max.get(i))) continue;
                return null;
            }
            store.point.set(i, candidatePlane[i]);
            store.normal.set(i, quadrant[i] == 0 ? 1.0 : -1.0);
        }
        return store;
    }
}

