/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeSignature {
    static Logger log = LoggerFactory.getLogger(ShapeSignature.class);
    private long bits;

    public ShapeSignature(long bits) {
        this.bits = bits;
    }

    public ShapeSignature clone() {
        return new ShapeSignature(this.bits);
    }

    public void clear() {
        this.bits = 0L;
    }

    public long getBits() {
        return this.bits;
    }

    protected int index(int i, int j, int k) {
        return i * 16 + j * 4 + k;
    }

    protected long getToggleBit(int i, int j, int k) {
        return 1L << this.index(i, j, k);
    }

    public void set(int i, int j, int k) {
        long toggle = this.getToggleBit(i, j, k);
        this.bits |= toggle;
    }

    public void unset(int i, int j, int k) {
        long toggle = this.getToggleBit(i, j, k);
        this.bits &= toggle ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean isSet(int i, int j, int k) {
        long toggle = this.getToggleBit(i, j, k);
        return (this.bits & toggle) == toggle;
    }

    public String toString() {
        String value = String.format("%64s", Long.toBinaryString(this.bits));
        value = value.replace(' ', '0');
        return this.getClass().getSimpleName() + "[" + value + "]";
    }
}

