/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.RayHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SphereCollider<K>
implements Collider<K> {
    static Logger log = LoggerFactory.getLogger(SphereCollider.class);
    public static final String DEFAULT_NAME = "box";
    public static final SphereCollider UNIT = new SphereCollider();
    private final Vec3d min;
    private final Vec3d max;
    private final Vec3d center = new Vec3d();
    private final double radius;
    private final String name;

    public SphereCollider() {
        this(new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 1.0), DEFAULT_NAME);
    }

    public SphereCollider(String name) {
        this(new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 1.0), name);
    }

    public SphereCollider(Vec3d min, Vec3d max) {
        this(min, max, DEFAULT_NAME);
    }

    public SphereCollider(Vec3d min, Vec3d max, String name) {
        this.name = name;
        this.min = min.clone();
        this.max = max.clone();
        this.center.set(min);
        this.center.addLocal(max);
        this.center.multLocal(0.5);
        this.radius = (max.x - min.x) * 0.5;
    }

    protected SphereCollider(SphereCollider toClone) {
        this.min = toClone.min.clone();
        this.max = toClone.max.clone();
        this.center.set(toClone.center);
        this.radius = toClone.radius;
        this.name = toClone.name;
    }

    public Vec3d getCenter() {
        return this.center;
    }

    public String getName() {
        return this.name;
    }

    private static Vec3d toNormal(Vec3d delta, double dist) {
        if (dist > 0.0) {
            return delta.mult(1.0 / dist);
        }
        System.out.println("Random deflect.");
        delta.x = Math.random() * 0.1;
        delta.y = Math.random() * 0.1;
        delta.z = Math.random() * 0.1;
        return delta.normalizeLocal();
    }

    @Override
    public MBlockContact<K> getSphereContact(Vec3d cellPos, Vec3d pos, double radius, int dirMask) {
        double both;
        double z;
        double y;
        double x;
        double dSq;
        if (log.isTraceEnabled()) {
            log.trace("getSphereContact(" + cellPos + ", " + pos + ", " + radius + ", " + DirectionMasks.toString((int)dirMask) + ")");
        }
        if ((dSq = (x = pos.x - (cellPos.x + this.center.x)) * x + (y = pos.y - (cellPos.y + this.center.y)) * y + (z = pos.z - (cellPos.z + this.center.z)) * z) > (both = this.radius + radius) * both) {
            return null;
        }
        double dist = Math.sqrt(dSq);
        Vec3d cn = SphereCollider.toNormal(new Vec3d(x, y, z), dist);
        Vec3d cp = cellPos.add(this.center).addLocal(cn.mult(this.radius));
        double penetration = -(dist - both);
        MBlockContact result = new MBlockContact();
        result.contactPoint = cp;
        result.contactNormal = cn;
        result.penetration = penetration;
        return result;
    }

    @Override
    public MBlockContact<K> getCubeContact(Vec3d cellOrigin, Vec3d pos, double radius, int dirMask) {
        return this.getSphereContact(cellOrigin, pos, radius, dirMask);
    }

    @Override
    public RayHit getHit(Vec3d origin, Vec3d dir, int dirMask, RayHit store) {
        log.info("getHit(" + origin + ", " + dir + ")");
        Vec3d relative = this.center.subtract(origin);
        double proj = relative.dot(dir);
        Vec3d closest = origin.add(dir.mult(proj));
        double distSq = this.center.distanceSq(closest);
        log.info("  closest:" + closest + "  distSq:" + distSq);
        if (distSq > this.radius * this.radius) {
            return null;
        }
        if (store == null) {
            store = new RayHit();
        }
        double back = Math.sqrt(this.radius * this.radius - distSq);
        Vec3d cp = closest.subtract(dir.mult(back));
        Vec3d normal = cp.subtract(this.center).normalizeLocal();
        store.point.set(cp);
        store.normal.set(normal);
        return store;
    }

    public String toString() {
        return "SphereCollider[" + this.name + ", " + this.center + ", " + this.radius + "]";
    }
}

