/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import java.util.concurrent.atomic.AtomicLong;

public class ConnectionStats {
    private RollingAverage ping = new RollingAverage(5);
    private RollingAverage messageSize = new RollingAverage(5);
    private MissCounter acks = new MissCounter();

    public final void addPingTime(long time) {
        this.ping.add(time);
    }

    public long getAveragePingTime() {
        return this.ping.average.get();
    }

    public final void addMessageSize(long size) {
        this.messageSize.add(size);
    }

    public long getAverageMessageSize() {
        return this.messageSize.average.get();
    }

    public long getTotalMessageBytes() {
        return this.messageSize.total.get();
    }

    public final void incrementAcks() {
        this.acks.incrementTotal();
    }

    public final void incrementAckMisses() {
        this.acks.incrementMisses();
    }

    public final double getAckMissPercent() {
        return (double)this.acks.percentTimes10.get() / 10.0;
    }

    private class MissCounter {
        private long total;
        private long misses;
        private AtomicLong percentTimes10 = new AtomicLong();

        private MissCounter() {
        }

        public final void incrementTotal() {
            ++this.total;
            this.percentTimes10.set(this.misses * 1000L / this.total);
        }

        public final void incrementMisses() {
            ++this.misses;
            this.percentTimes10.set(this.misses * 1000L / this.total);
        }
    }

    private class RollingAverage {
        private int windowSize;
        private int count;
        private long accumulator;
        private AtomicLong average = new AtomicLong();
        private AtomicLong total = new AtomicLong();

        public RollingAverage(int windowSize) {
            this.windowSize = windowSize;
        }

        public void add(long value) {
            long size = Math.min(this.count, this.windowSize);
            ++this.count;
            long roll = (this.accumulator * size + value) / (size + 1L);
            this.average.set(roll);
            this.total.addAndGet(value);
        }
    }
}

