/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.account.base.HashAuthenticator;
import com.simsilica.fsm.StateMachine;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.PasswordField;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import mythruna.client.MythrunaConfig;
import mythruna.client.net.ConnectionState;
import mythruna.net.client.AccountClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(LoginState.class);
    private String hostIp;
    private String userIdSetting;
    private StateMachine<String, String> fsm;
    private String randomSalt;
    private List<String> caps;
    private HashAuthenticator[] auths = new HashAuthenticator[]{HashAuthenticator.SHA512};
    private Container login;
    private TextField user;
    private PasswordField password;
    private ConnectionState connection;
    private AccountClientService account;

    public LoginState(String hostIp, StateMachine<String, String> fsm) {
        this.hostIp = hostIp;
        this.fsm = fsm;
        this.setEnabled(false);
        this.userIdSetting = "login." + hostIp + ".userId";
    }

    public List<String> getCaps() {
        return this.caps == null ? Collections.emptyList() : this.caps;
    }

    public void challenge(String randomSalt, List<String> caps) {
        log.info("salt:" + randomSalt + " caps:" + caps);
        this.randomSalt = randomSalt;
        this.caps = caps;
    }

    protected void login() {
        log.info("login()");
        String userId = this.user.getText().trim();
        if (userId.length() == 0) {
            return;
        }
        String pw = this.password.getText().trim();
        if (pw.length() == 0) {
            return;
        }
        HashMap<String, String> creds = new HashMap<String, String>();
        for (HashAuthenticator hash : this.auths) {
            if (!this.caps.contains(hash.getName())) continue;
            String pHashed = hash.hash(pw);
            creds.put(hash.getName(), hash.hash(this.randomSalt + pHashed));
        }
        this.fsm.trigger((Object)"login", (Object)userId);
        this.account.login(userId, creds);
    }

    protected void back() {
        log.info("back()");
        this.fsm.trigger((Object)"back");
    }

    protected void createAccount() {
        log.info("createAccount()");
        this.fsm.trigger((Object)"create");
    }

    protected String hash(String s) {
        for (HashAuthenticator hash : this.auths) {
            log.info("checking hash:" + hash.getName());
            if (!this.caps.contains(hash.getName())) continue;
            return hash.hash(s);
        }
        throw new UnsupportedOperationException("Server does not support any configured authenticators");
    }

    protected void accountCreated(String userId, String password) {
        this.user.setText(userId);
    }

    protected void loginSuccessful() {
        String userId;
        String id = MythrunaConfig.getInstance().getStartupSetting(this.userIdSetting, null);
        if (Objects.equals(id, userId = this.user.getText().trim())) {
            return;
        }
        MythrunaConfig.getInstance().getStartupSettings().put(this.userIdSetting, userId);
        MythrunaConfig.save();
    }

    protected void initialize(Application app) {
        this.connection = (ConnectionState)this.getState(ConnectionState.class);
        this.account = this.connection.getService(AccountClientService.class);
        this.login = new Container(new ElementId("window"));
        this.login.addChild((Node)new Label("Enter Login Information...", new ElementId("window.title")), new Object[0]);
        Container props = (Container)this.login.addChild((Node)new Container(), new Object[0]);
        props.addChild((Node)new Label("User ID:"), new Object[0]);
        this.user = (TextField)props.addChild((Node)new TextField(""), new Object[]{1});
        this.user.setPreferredWidth(300.0f);
        props.addChild((Node)new Label("Password:"), new Object[0]);
        this.password = (PasswordField)props.addChild((Node)new PasswordField(""), new Object[]{1});
        this.password.setPreferredWidth(300.0f);
        Container buttons = (Container)this.login.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "login")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "back")), new Object[0]);
        buttons.addChild((Node)new Label("    "), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Create New Account", (Object)this, "createAccount")), new Object[0]);
        String id = MythrunaConfig.getInstance().getStartupSetting(this.userIdSetting, null);
        if (id != null) {
            this.user.setText(id);
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        GuiGlobals globals = GuiGlobals.getInstance();
        globals.getPopupState().centerInGui((Spatial)this.login);
        globals.getPopupState().showModalPopup((Spatial)this.login, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        if (this.user.getText().trim().length() == 0) {
            globals.requestFocus((Spatial)this.user);
        } else {
            globals.requestFocus((Spatial)this.password);
        }
    }

    protected void onDisable() {
        GuiGlobals.getInstance().getPopupState().closePopup((Spatial)this.login);
    }
}

