/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.app.state.BaseAppState;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CharacterViewState.class);
    private ViewPort vp;
    private Node vpRoot;
    private Vector3f pos = new Vector3f();
    private Vector3f size = new Vector3f();
    private DirectionalLight sun;
    private AmbientLight ambient;
    private Geometry test;

    public CharacterViewState() {
        this.setEnabled(false);
    }

    public Node getRoot() {
        return this.vpRoot;
    }

    public void setPosition(Vector3f pos, Vector3f size) {
        log.info("setPosition(" + pos + ", " + size + ")");
        if (this.pos.equals((Object)pos) && this.size.equals((Object)size)) {
            return;
        }
        this.pos.set(pos);
        this.size.set(size);
        this.resetViewport();
    }

    protected void initialize(Application app) {
        Camera cam = this.getApplication().getCamera().clone();
        this.vp = this.getApplication().getRenderManager().createPostView("CharacterView", cam);
        this.vp.setClearFlags(false, true, true);
        this.vp.setBackgroundColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 0.5f));
        this.vp.setEnabled(false);
        this.vpRoot = new Node("VP Root");
        this.vp.attachScene((Spatial)this.vpRoot);
        Vector3f lightDir = new Vector3f(0.2f, -1.0f, -0.5f).normalizeLocal();
        this.sun = new DirectionalLight(lightDir, ColorRGBA.White);
        this.vpRoot.addLight((Light)this.sun);
        this.ambient = new AmbientLight(new ColorRGBA(0.5f, 0.4f, 0.3f, 1.0f));
        this.vpRoot.addLight((Light)this.ambient);
        log.info("camera:" + cam.getLocation() + " dir:" + cam.getDirection());
        this.size.x = cam.getWidth();
        this.size.y = cam.getHeight();
        cam.setLocation(new Vector3f(0.0f, 1.35f, 2.5f));
        cam.setRotation(new Quaternion().fromAngles(0.2f, (float)Math.PI, 0.0f));
        this.resetViewport();
    }

    protected void cleanup(Application app) {
        this.getApplication().getRenderManager().removePostView(this.vp);
        this.vp = null;
    }

    protected void resetViewport() {
        if (this.vp == null) {
            return;
        }
        Camera cam = this.vp.getCamera();
        float width = cam.getWidth();
        float height = cam.getHeight();
        float x1 = this.pos.x;
        float y1 = this.pos.y;
        float x2 = this.pos.x + this.size.x;
        float y2 = this.pos.y + this.size.y;
        cam.setViewPort(x1 / width, x2 / width, y1 / height, y2 / height);
        float fov = cam.getFov();
        cam.setFrustumPerspective(fov, this.size.x / this.size.y, 0.01f, 1000.0f);
    }

    protected void onEnable() {
        log.info("onEnable()");
        this.vp.setEnabled(true);
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.vp.setEnabled(false);
    }

    public void update(float tpf) {
        if (this.vpRoot != null) {
            this.vpRoot.updateLogicalState(tpf);
        }
    }

    public void render(RenderManager rm) {
        if (this.vpRoot != null) {
            this.vpRoot.updateGeometricState();
        }
    }

    public void stateDetached(AppStateManager stateManager) {
        if (this.vp != null) {
            this.vp.detachScene((Spatial)this.vpRoot);
        }
    }
}

