/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.thread;

import com.simsilica.thread.IterationProcessor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterationProcessorThread
extends Thread {
    static Logger log = LoggerFactory.getLogger(IterationProcessorThread.class);
    private Semaphore loopHold = new Semaphore(0);
    private AtomicBoolean go = new AtomicBoolean(true);
    private IterationProcessor processor;
    private boolean matchLoops;

    public IterationProcessorThread(IterationProcessor processor, boolean matchLoops) {
        this.processor = processor;
        this.matchLoops = matchLoops;
    }

    public IterationProcessorThread(String name, IterationProcessor processor, boolean matchLoops) {
        super(name);
        this.processor = processor;
        this.matchLoops = matchLoops;
    }

    public boolean getMatchLoops() {
        return this.matchLoops;
    }

    public void iterate() {
        this.loopHold.release();
    }

    public void close() {
        this.go.set(false);
        this.iterate();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while closing", e);
        }
    }

    @Override
    public void run() {
        this.processor.onStart();
        try {
            while (this.go.get()) {
                this.loopHold.acquire();
                if (!this.matchLoops) {
                    this.loopHold.drainPermits();
                }
                if (!this.go.get()) {
                    return;
                }
                this.processor.onIterate();
            }
        }
        catch (InterruptedException e) {
            if (this.go.get()) {
                throw new RuntimeException("Unexpected interruption", e);
            }
        }
        finally {
            this.processor.onStop();
        }
    }
}

