/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.RayHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeCollider<K>
implements Collider<K> {
    static Logger log = LoggerFactory.getLogger(CubeCollider.class);
    public static final String DEFAULT_NAME = "box";
    public static final CubeCollider UNIT = new CubeCollider();
    private final Vec3d min;
    private final Vec3d max;
    private final Vec3d center = new Vec3d();
    private final Vec3d extents = new Vec3d();
    private final boolean symetric;
    private final String name;
    private int alwaysOnMask;
    private boolean approximate;
    public static boolean debug = false;

    public CubeCollider() {
        this(new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 1.0), DEFAULT_NAME);
    }

    public CubeCollider(String name) {
        this(new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 1.0), name);
    }

    public CubeCollider(Vec3d min, Vec3d max) {
        this(min, max, DEFAULT_NAME);
    }

    public CubeCollider(Vec3d min, Vec3d max, String name) {
        this(min, max, name, false);
    }

    public CubeCollider(Vec3d min, Vec3d max, String name, boolean approximate) {
        this.name = name;
        this.min = min.clone();
        this.max = max.clone();
        this.approximate = approximate;
        this.center.set(min);
        this.center.addLocal(max);
        this.center.multLocal(0.5);
        this.extents.set(max);
        this.extents.subtractLocal(min);
        this.extents.multLocal(0.5);
        this.symetric = this.epsilon(this.center.x) == 0.5 && this.epsilon(this.center.z) == 0.5;
        this.calculateLocalMasks();
    }

    protected CubeCollider(CubeCollider toClone) {
        this.min = toClone.min.clone();
        this.max = toClone.max.clone();
        this.center.set(toClone.center);
        this.extents.set(toClone.extents);
        this.symetric = toClone.symetric;
        this.name = toClone.name;
        this.calculateLocalMasks();
    }

    public boolean isApproximate() {
        return this.approximate;
    }

    public Vec3d getCenter() {
        return this.center;
    }

    public Vec3d getExtents() {
        return this.extents;
    }

    protected void calculateLocalMasks() {
        Vec3d min = this.center.subtract(this.extents);
        Vec3d max = this.center.add(this.extents);
        if (this.epsilon(min.x) > 0.0) {
            this.alwaysOnMask |= 8;
        }
        if (this.epsilon(max.x) < 1.0) {
            this.alwaysOnMask |= 4;
        }
        if (this.epsilon(min.z) > 0.0) {
            this.alwaysOnMask |= 1;
        }
        if (this.epsilon(max.z) < 1.0) {
            this.alwaysOnMask |= 2;
        }
        if (this.epsilon(min.y) > 0.0) {
            this.alwaysOnMask |= 0x20;
        }
        if (this.epsilon(max.y) < 1.0) {
            this.alwaysOnMask |= 0x10;
        }
    }

    public String getName() {
        return this.name;
    }

    protected double epsilon(double d) {
        long i = Math.round(d * 10000.0);
        d = (double)i / 10000.0;
        return d;
    }

    private static final double clamp(double v, double min, double max) {
        return v < min ? min : (v > max ? max : v);
    }

    private static final double clamp(double v, double extent) {
        return CubeCollider.clamp(v, -extent, extent);
    }

    private static Vec3d toNormal(Vec3d delta, double dist) {
        if (dist > 0.0) {
            return delta.mult(1.0 / dist);
        }
        System.out.println("Random deflect.");
        delta.x = Math.random() * 0.1;
        delta.y = Math.random() * 0.1;
        delta.z = Math.random() * 0.1;
        return delta.normalizeLocal();
    }

    private static double absDirClamp(double val, int dirMask, int minMask, int maxMask) {
        if (debug) {
            System.out.println("absDirClamp(" + val + ", " + DirectionMasks.toString((int)dirMask) + ", " + DirectionMasks.toString((int)minMask) + ", " + DirectionMasks.toString((int)maxMask) + ")");
        }
        if (val < 0.0) {
            if (DirectionMasks.hasMask((int)dirMask, (int)minMask)) {
                if (debug) {
                    System.out.println("has min mask");
                }
                return Math.abs(val);
            }
            return 0.0;
        }
        if (val > 0.0) {
            if (DirectionMasks.hasMask((int)dirMask, (int)maxMask)) {
                if (debug) {
                    System.out.println("has max mask");
                }
                return val;
            }
            return 0.0;
        }
        return val;
    }

    @Override
    public MBlockContact<K> getSphereContact(Vec3d cellPos, Vec3d pos, double radius, int dirMask) {
        double penetration;
        double x = pos.x - (cellPos.x + this.center.x);
        double y = pos.y - (cellPos.y + this.center.y);
        double z = pos.z - (cellPos.z + this.center.z);
        if ((dirMask |= this.alwaysOnMask) == 0) {
            return null;
        }
        if (debug) {
            log.info("getSphereContact(" + cellPos + ", " + pos + ", " + radius + ", " + DirectionMasks.toString((int)dirMask) + ")");
        }
        if (debug) {
            log.info("relative:" + x + ", " + y + ", " + z);
        }
        if (debug) {
            log.info("extents:" + this.extents);
        }
        if (x <= -(this.extents.x + radius)) {
            if (debug) {
                log.info("x too low");
            }
            return null;
        }
        if (y <= -(this.extents.y + radius)) {
            if (debug) {
                log.info("y too low");
            }
            return null;
        }
        if (z <= -(this.extents.z + radius)) {
            if (debug) {
                log.info("z too low");
            }
            return null;
        }
        if (x >= this.extents.x + radius) {
            if (debug) {
                log.info("x too high");
            }
            return null;
        }
        if (y >= this.extents.y + radius) {
            if (debug) {
                log.info("y too high");
            }
            return null;
        }
        if (z >= this.extents.z + radius) {
            if (debug) {
                log.info("z too high");
            }
            return null;
        }
        if (x <= -this.extents.x && !DirectionMasks.hasWest((int)dirMask)) {
            if (debug) {
                log.info("x is low and no west mask... x:" + x + "  -extents.x:" + -this.extents.x);
            }
            return null;
        }
        if (y <= -this.extents.y && !DirectionMasks.hasDown((int)dirMask)) {
            if (debug) {
                log.info("y is low and no down mask... y:" + y + "  -extents.y:" + -this.extents.y);
            }
            return null;
        }
        if (z <= -this.extents.z && !DirectionMasks.hasNorth((int)dirMask)) {
            if (debug) {
                log.info("z is low and no north mask... z:" + z + "  -extents.z:" + -this.extents.z);
            }
            return null;
        }
        if (x > this.extents.x && !DirectionMasks.hasEast((int)dirMask)) {
            if (debug) {
                log.info("x is high and no east mask... x:" + x + "  extents.x:" + this.extents.x);
            }
            return null;
        }
        if (y > this.extents.y && !DirectionMasks.hasUp((int)dirMask)) {
            if (debug) {
                log.info("y is high and no up mask... y:" + y + "  extents.y:" + this.extents.y);
            }
            return null;
        }
        if (z > this.extents.z && !DirectionMasks.hasSouth((int)dirMask)) {
            if (debug) {
                log.info("z is high and no south mask... z:" + z + "  extents.z:" + this.extents.z);
            }
            return null;
        }
        Vec3d cn = new Vec3d();
        int edgeOrFaceHit = 0;
        if (x > this.extents.x) {
            x = this.extents.x;
            cn.x = 1.0;
            if (debug) {
                log.info("clamp x");
            }
        } else if (x < -this.extents.x) {
            x = -this.extents.x;
            cn.x = -1.0;
            if (debug) {
                log.info("clamp -x");
            }
        } else {
            cn.x = 0.0;
            ++edgeOrFaceHit;
            if (debug) {
                log.info("x inside");
            }
        }
        if (y > this.extents.y) {
            y = this.extents.y;
            cn.y = 1.0;
            if (debug) {
                log.info("clamp y");
            }
        } else if (y < -this.extents.y) {
            y = -this.extents.y;
            cn.y = -1.0;
            if (debug) {
                log.info("clamp -y");
            }
        } else {
            cn.y = 0.0;
            ++edgeOrFaceHit;
            if (debug) {
                log.info("y inside");
            }
        }
        if (z > this.extents.z) {
            z = this.extents.z;
            cn.z = 1.0;
            if (debug) {
                log.info("clamp z");
            }
        } else if (z < -this.extents.z) {
            z = -this.extents.z;
            cn.z = -1.0;
            if (debug) {
                log.info("clamp -z");
            }
        } else {
            cn.z = 0.0;
            ++edgeOrFaceHit;
            if (debug) {
                log.info("z inside");
            }
        }
        if (debug) {
            log.info("clamped:" + x + ", " + y + ", " + z);
        }
        Vec3d cp = cellPos.add(this.center).addLocal(x, y, z);
        if (debug) {
            log.info("cp:" + cp);
        }
        if (edgeOrFaceHit > 2) {
            double bestExtent = 0.0;
            if (debug) {
                System.out.println("edgeOrFaceHit:" + edgeOrFaceHit);
            }
            if (edgeOrFaceHit == 3) {
                if (debug) {
                    System.out.println("Fully Inside. cn:" + cn + "  body:" + pos + "  static:" + cellPos);
                }
                if (debug) {
                    System.out.println("unfiltered:" + x + ", " + y + ", " + z + " dirs:" + DirectionMasks.toString((int)dirMask));
                }
                double ax = CubeCollider.absDirClamp(x, dirMask, 8, 4);
                double ay = CubeCollider.absDirClamp(y, dirMask, 32, 16);
                double az = CubeCollider.absDirClamp(z, dirMask, 1, 2);
                if (debug) {
                    System.out.println("filtered:" + ax + ", " + ay + ", " + az);
                }
                double flip = 1.0;
                if (ax == 0.0 && ay == 0.0 && az == 0.0) {
                    if (debug) {
                        System.out.println("no good exits");
                    }
                    ax = Math.abs(x) + this.extents.x * Math.signum(x) * -1.0;
                    ay = Math.abs(y) + this.extents.y * Math.signum(y) * -1.0;
                    az = Math.abs(z) + this.extents.z * Math.signum(z) * -1.0;
                    if (debug) {
                        System.out.println("reprojected:" + ax + ", " + ay + ", " + az);
                    }
                    ax = CubeCollider.absDirClamp(ax, dirMask, 8, 4);
                    ay = CubeCollider.absDirClamp(ay, dirMask, 8, 4);
                    az = CubeCollider.absDirClamp(az, dirMask, 8, 4);
                    if (debug) {
                        System.out.println("refiltered:" + ax + ", " + ay + ", " + az);
                    }
                    flip = -1.0;
                }
                if (ax > ay) {
                    if (ax > az) {
                        cn.x = Math.signum(x) * flip;
                        bestExtent = this.extents.x;
                        if (debug) {
                            System.out.println("x is best");
                        }
                    } else {
                        cn.z = Math.signum(z) * flip;
                        bestExtent = this.extents.z;
                        if (debug) {
                            System.out.println("z is best");
                        }
                    }
                } else if (ay > az) {
                    cn.y = Math.signum(y) * flip;
                    bestExtent = this.extents.y;
                    if (debug) {
                        System.out.println("y is best");
                    }
                } else {
                    cn.z = Math.signum(z) * flip;
                    bestExtent = this.extents.z;
                    if (debug) {
                        System.out.println("z is best");
                    }
                }
            }
            Vec3d delta = pos.subtract(cellPos).subtractLocal(this.center);
            if (debug) {
                System.out.println("cn:" + cn + "  delta:" + delta);
            }
            double dist = cn.dot(delta);
            if (debug) {
                System.out.println("dist:" + dist + "  bestExtent:" + bestExtent + "  radius:" + radius);
            }
            penetration = bestExtent - dist + radius;
            double project = bestExtent - dist;
            if (debug) {
                System.out.println("project:" + project);
            }
            cp.addLocal(cn.x * project, cn.y * project, cn.z * project);
        } else {
            double distSq = cp.distanceSq(pos);
            if (debug) {
                System.out.println("cp:" + cp + "  pos:" + pos + "  distSq:" + distSq + "  radius:" + radius);
            }
            if (distSq > radius * radius) {
                return null;
            }
            double dist = Math.sqrt(distSq);
            if (dist > 0.0) {
                cn = pos.subtract(cp).mult(1.0 / dist);
            } else {
                Vec3d delta = pos.subtract(cellPos).subtractLocal(this.center);
                if (debug) {
                    System.out.println("Deflect. cn:" + cn + "  edgeOrFaceHit:" + edgeOrFaceHit + "  body:" + pos + "  static:" + cellPos);
                }
                cn = CubeCollider.toNormal(delta, delta.length());
            }
            penetration = radius - dist;
        }
        MBlockContact result = new MBlockContact();
        result.contactPoint = cp;
        result.contactNormal = cn;
        result.penetration = penetration;
        return result;
    }

    @Override
    public MBlockContact<K> getCubeContact(Vec3d cellPos, Vec3d pos, double radius, int dirMask) {
        double p;
        if (debug) {
            log.info("getCubeContact(" + cellPos + ", " + pos + ", " + radius + ", " + DirectionMasks.toString((int)dirMask) + ")");
        }
        double x = pos.x - (cellPos.x + this.center.x);
        double y = pos.y - (cellPos.y + this.center.y);
        double z = pos.z - (cellPos.z + this.center.z);
        if (debug) {
            log.info("  pos -> center relative:" + x + ", " + y + ", " + z);
        }
        dirMask |= this.alwaysOnMask;
        if (x <= -(this.extents.x + radius)) {
            if (debug) {
                log.info("x too low");
            }
            return null;
        }
        if (y <= -(this.extents.y + radius)) {
            if (debug) {
                log.info("y too low");
            }
            return null;
        }
        if (z <= -(this.extents.z + radius)) {
            if (debug) {
                log.info("z too low");
            }
            return null;
        }
        if (x >= this.extents.x + radius) {
            if (debug) {
                log.info("x too high");
            }
            return null;
        }
        if (y >= this.extents.y + radius) {
            if (debug) {
                log.info("y too high");
            }
            return null;
        }
        if (z >= this.extents.z + radius) {
            if (debug) {
                log.info("z too high");
            }
            return null;
        }
        if (x <= -this.extents.x && !DirectionMasks.hasWest((int)dirMask)) {
            if (debug) {
                log.info("x is low and no west mask... x:" + x + "  -extents.x:" + -this.extents.x);
            }
            return null;
        }
        if (y <= -this.extents.y && !DirectionMasks.hasDown((int)dirMask)) {
            if (debug) {
                log.info("y is low and no down mask... y:" + y + "  -extents.y:" + -this.extents.y);
            }
            return null;
        }
        if (z <= -this.extents.z && !DirectionMasks.hasNorth((int)dirMask)) {
            if (debug) {
                log.info("z is low and no north mask... z:" + z + "  -extents.z:" + -this.extents.z);
            }
            return null;
        }
        if (x > this.extents.x && !DirectionMasks.hasEast((int)dirMask)) {
            if (debug) {
                log.info("x is high and no east mask... x:" + x + "  extents.x:" + this.extents.x);
            }
            return null;
        }
        if (y > this.extents.y && !DirectionMasks.hasUp((int)dirMask)) {
            if (debug) {
                log.info("y is high and no up mask... y:" + y + "  extents.y:" + this.extents.y);
            }
            return null;
        }
        if (z > this.extents.z && !DirectionMasks.hasSouth((int)dirMask)) {
            if (debug) {
                log.info("z is high and no south mask... z:" + z + "  extents.z:" + this.extents.z);
            }
            return null;
        }
        Vec3d cp = new Vec3d();
        Vec3d normal = new Vec3d();
        double pen = Double.POSITIVE_INFINITY;
        int hitMask = 0;
        if (DirectionMasks.hasEast((int)dirMask) && (p = this.extents.x + radius - x) > 0.0 && p < pen) {
            pen = p;
            normal.set(1.0, 0.0, 0.0);
            cp.set(this.extents.x, CubeCollider.clamp(y, this.extents.y), CubeCollider.clamp(z, this.extents.z));
            hitMask = 4;
        }
        if (DirectionMasks.hasWest((int)dirMask) && (p = x + (this.extents.x + radius)) > 0.0 && p < pen) {
            pen = p;
            normal.set(-1.0, 0.0, 0.0);
            cp.set(-this.extents.x, CubeCollider.clamp(y, this.extents.y), CubeCollider.clamp(z, this.extents.z));
            hitMask = 8;
        }
        if (DirectionMasks.hasSouth((int)dirMask) && (p = this.extents.z + radius - z) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, 0.0, 1.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), CubeCollider.clamp(y, this.extents.y), this.extents.z);
            hitMask = 2;
        }
        if (DirectionMasks.hasNorth((int)dirMask) && (p = z + (this.extents.z + radius)) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, 0.0, -1.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), CubeCollider.clamp(y, this.extents.y), -this.extents.z);
            hitMask = 1;
        }
        if (DirectionMasks.hasUp((int)dirMask) && (p = this.extents.y + radius - y) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, 1.0, 0.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), this.extents.y, CubeCollider.clamp(z, this.extents.z));
            hitMask = 16;
        }
        if (DirectionMasks.hasDown((int)dirMask) && (p = y + (this.extents.y + radius)) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, -1.0, 0.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), -this.extents.y, CubeCollider.clamp(z, this.extents.z));
            hitMask = 32;
        }
        if (pen == Double.POSITIVE_INFINITY) {
            System.out.println("no penetrations detected: getCubeContact(" + cellPos + ", " + pos + ", " + radius + ", " + dirMask + ")");
            return null;
        }
        MBlockContact result = new MBlockContact();
        result.contactPoint = cp.addLocal(cellPos).addLocal(this.center);
        result.contactNormal = normal;
        result.penetration = pen;
        return result;
    }

    @Override
    public RayHit getHit(Vec3d origin, Vec3d dir, int dirMask, RayHit store) {
        int i;
        int i2;
        boolean inside = true;
        int[] quadrant = new int[3];
        double[] maxT = new double[3];
        double[] candidatePlane = new double[3];
        for (i2 = 0; i2 < 3; ++i2) {
            if (origin.get(i2) < this.min.get(i2)) {
                quadrant[i2] = 1;
                candidatePlane[i2] = this.min.get(i2);
                inside = false;
                continue;
            }
            if (origin.get(i2) > this.max.get(i2)) {
                quadrant[i2] = 0;
                candidatePlane[i2] = this.max.get(i2);
                inside = false;
                continue;
            }
            quadrant[i2] = 2;
        }
        if (inside) {
            return null;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            maxT[i2] = quadrant[i2] != 2 && dir.get(i2) != 0.0 ? (candidatePlane[i2] - origin.get(i2)) / dir.get(i2) : -1.0;
        }
        int whichPlane = 0;
        for (i = 1; i < 3; ++i) {
            if (!(maxT[i] > maxT[whichPlane])) continue;
            whichPlane = i;
        }
        if (maxT[whichPlane] < 0.0) {
            return null;
        }
        if (store == null) {
            store = new RayHit();
        }
        for (i = 0; i < 3; ++i) {
            if (whichPlane != i) {
                store.point.set(i, origin.get(i) + maxT[whichPlane] * dir.get(i));
                store.normal.set(i, 0.0);
                if (!(store.point.get(i) < this.min.get(i)) && !(store.point.get(i) > this.max.get(i))) continue;
                return null;
            }
            store.point.set(i, candidatePlane[i]);
            store.normal.set(i, quadrant[i] == 0 ? 1.0 : -1.0);
        }
        return store;
    }

    public String toString() {
        return "CubeCollider[" + this.name + ", " + this.center + ", " + this.extents + "]";
    }
}

