/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.google.common.base.Throwables;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.PersistentEntityData;
import com.simsilica.es.sql.SqlEntityData;
import com.simsilica.ext.mphys.Gravity;
import com.simsilica.ext.mphys.Impulse;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.IntCombiner;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.DataUpdater;
import com.simsilica.mblock.io.FluidTypeData;
import com.simsilica.mblock.io.UpdateableData;
import com.simsilica.mod.ModManager;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.DefaultWorld;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnPostProcessor;
import com.simsilica.mworld.db.DefaultCellArrayStorage;
import com.simsilica.mworld.db.GeneratedColumnDb;
import com.simsilica.mworld.db.InitialSunlightProcessor;
import com.simsilica.mworld.db.InternalLightingProcessor;
import com.simsilica.mworld.db.LightingPostProcessor;
import com.simsilica.mworld.db.MaskPostProcessor;
import com.simsilica.mworld.db.ObservableColumnDb;
import com.simsilica.mworld.db.ObservableColumnDbAdapter;
import com.simsilica.mworld.db.PostProcColumnDb;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.tile.ColumnStates;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageDb;
import com.simsilica.mworld.tile.TerrainImageManager;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TerrainTypeFunction;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileBasedColumnGenerator;
import com.simsilica.mworld.tile.TileColumnProcessor;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.TileManager;
import com.simsilica.mworld.tile.insert.ApplyInsertsFunction;
import com.simsilica.mworld.tile.insert.InsertColumnProcessor;
import com.simsilica.mworld.tile.insert.InsertLayer;
import com.simsilica.mworld.tile.insert.InsertLayerDb;
import com.simsilica.mworld.tile.insert.InsertLayerProtocol;
import com.simsilica.mworld.tile.morph.ApplyMorphologyFunction;
import com.simsilica.mworld.tile.morph.BoxFill;
import com.simsilica.mworld.tile.morph.BoxFillProtocol;
import com.simsilica.mworld.tile.morph.MorphologyColumnProcessor;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import com.simsilica.mworld.tile.morph.MorphologyLayerDb;
import com.simsilica.mworld.tile.morph.MorphologyLayerProtocol;
import com.simsilica.mworld.tile.morph.SphereFill;
import com.simsilica.mworld.tile.morph.SphereFillProtocol;
import com.simsilica.mworld.tile.pc.PointCloudManager;
import com.simsilica.mworld.tile.pc.PointIndexFunction;
import com.simsilica.mworld.tile.tree.ApplyTreeSplatsFunction;
import com.simsilica.mworld.tile.tree.TreeColumnProcessor;
import com.simsilica.mworld.tile.tree.TreeLayerDb;
import com.simsilica.mworld.tile.tree.TreeLayerProtocol;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.imageio.ImageIO;
import mythruna.GameConstants;
import mythruna.assembly.db.DefaultSubassemblyStorage;
import mythruna.assembly.db.SubassemblyStorage;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimMarker;
import mythruna.es.ClaimType;
import mythruna.es.ContainedIn;
import mythruna.es.MapMarker;
import mythruna.es.ObjectName;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.OwnedBy;
import mythruna.fabric.FabricConfig;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.ShapeConfig;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.text.CompositeTextDb;
import mythruna.text.FileTextDb;
import mythruna.text.MultipartTextDb;
import mythruna.text.ResourceTextDb;
import mythruna.text.TextDb;
import mythruna.world.BaseColumnProcessor;
import mythruna.world.BuildTypes;
import mythruna.world.FloraColumnProcessor;
import mythruna.world.ImageTypeFunction;
import mythruna.world.InsertBlockMerge;
import mythruna.world.InsertTerrainMerge;
import mythruna.world.InsertTypeFunction;
import mythruna.world.PhysicalWorld;
import mythruna.world.PointTypeMapping;
import mythruna.world.TerrainElevationGenerator;
import mythruna.world.TerrainTypeGenerator;
import mythruna.world.TreeGenerator;
import mythruna.world.WorldFractal;
import mythruna.world.WorldFractalFactory;
import mythruna.world.WorldInfo;
import mythruna.world.WorldLibrary;
import mythruna.world.WorldStringInitializer;
import mythruna.world.WorldTime;
import mythruna.world.WorldUtils;
import mythruna.world.cave.CaveNetworkGenerator;
import mythruna.world.cave.CaveTileFunction;
import mythruna.world.cave.LineInfluencer;
import mythruna.world.cave.LineInfluencerProtocol;
import mythruna.world.cave.PointInfluencer;
import mythruna.world.cave.PointInfluencerProtocol;
import mythruna.world.cave.WallInfluencer;
import mythruna.world.cave.WallInfluencerProtocol;
import mythruna.world.es.WorldAge;
import mythruna.world.es.WorldSeed;
import mythruna.world.path.RoadFileTileFunction;
import mythruna.world.path.RoadSection;
import mythruna.world.path.RoadSectionProtocol;
import mythruna.world.river.RiverFileTileFunction;
import mythruna.world.river.RiverSection;
import mythruna.world.river.RiverSectionProtocol;
import mythruna.world.river.WaterBody;
import mythruna.world.river.WaterBodyFileTileFunction;
import mythruna.world.river.WaterBodyProtocol;
import mythruna.world.tile.RegionGenerator;
import mythruna.world.tile.SeaCostGenerator;
import mythruna.world.tile.SedectileDataGenerator;
import mythruna.world.tile.SedectileManager;
import mythruna.world.tile.TestPoiGenerator;
import mythruna.world.tile.WorkspaceFunction;
import mythruna.world.town.TestBlockRegistry;
import mythruna.world.town.TestPoiTileFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldManager {
    static Logger log = LoggerFactory.getLogger(WorldManager.class);
    private WorldInfo info;
    private WorldFractal worldFractal;
    private DefaultWorld world;
    private TileManager tileManager;
    private SedectileManager sedectileManager;
    private TreeLayerDb treeDb;
    private MorphologyLayerDb morphDb;
    private InsertLayerDb insertDb;
    private ObservableEntityData ed;
    private EntityId worldEntity;
    private TextDb textDb;
    private ModManager modManager;
    private ColumnDb rawColDb;
    private PhysicalWorld physWorld;
    private CellArrayStorage cellArrayDb;
    private SubassemblyStorage subassemblyDb;

    public WorldManager(WorldInfo info) {
        this(info, null);
    }

    public WorldManager(WorldInfo info, ObservableEntityData ed) {
        this.info = info;
        this.ed = ed;
        this.modManager = new ModManager();
    }

    public WorldInfo getInfo() {
        return this.info;
    }

    public World getWorld() {
        return this.world;
    }

    public World getPhysicalWorld() {
        return this.physWorld;
    }

    public TextDb getTextDb() {
        return this.textDb;
    }

    public EntityId getWorldEntity() {
        Long id = this.info.getWorldEntity();
        return id == null ? null : new EntityId(id.longValue());
    }

    public CellArrayStorage getCellArrayStorage() {
        return this.cellArrayDb;
    }

    public SubassemblyStorage getSubassemblyStorage() {
        return this.subassemblyDb;
    }

    public SedectileManager getSedectileManager() {
        return this.sedectileManager;
    }

    public TileManager getTileManager() {
        return this.tileManager;
    }

    public ModManager getModManager() {
        return this.modManager;
    }

    public int getElevation(int x, int z) {
        double elevation = this.worldFractal.getElevation(x, z);
        int e = (int)Math.floor(elevation);
        if (e == 0) {
            e = 1;
        }
        return e;
    }

    public ObservableEntityData getEntityData() {
        return this.ed;
    }

    public EntityId findNamedEntity(String name) {
        ComponentFilter filter = Filters.fieldEquals(Name.class, (String)"name", (Object)name);
        return this.ed.findEntity(filter, new Class[]{Name.class});
    }

    public String getName(EntityId entity) {
        Name name = (Name)this.ed.getComponent(entity, Name.class);
        return name == null ? null : name.getName();
    }

    @SafeVarargs
    public final Set<EntityId> findWorldItems(Class<? extends EntityComponent> ... types) {
        ComponentFilter filter = Filters.fieldEquals(ContainedIn.class, (String)"container", (Object)this.worldEntity);
        return this.ed.findEntities(filter, (Class[])types);
    }

    protected void initialize(ProgressTracker tracker) {
        File testFile3;
        File indexFile;
        Object updater;
        boolean changed;
        File indexFile2;
        BlockTypeData lastGlobal;
        boolean changed2;
        BlockTypeData local;
        Object global;
        tracker.setMax(18.0);
        if (this.info.getWorldDbVersions() == null) {
            log.info("Initializing world DB versions...");
            this.info.setWorldDbVersions(GameConstants.WORLD_DB_VERSIONS);
            WorldLibrary.store(this.info);
        } else {
            log.info("Checking world DB versions...");
            if (!Objects.equals(this.info.getWorldDbVersions(), GameConstants.WORLD_DB_VERSIONS)) {
                throw new RuntimeException("This world DB is incompatible with this software version.\nGame code versions:" + GameConstants.WORLD_DB_VERSIONS + "\nFile versions:" + this.info.getWorldDbVersions());
            }
        }
        tracker.increment();
        this.modManager.loadFromResource("/mythruna/base-includes.json");
        this.modManager.loadFromResource("/mythruna/base-apis.json");
        this.modManager.loadFromResource("/mythruna/base-object-api.json");
        this.modManager.loadFromResource("/mythruna/base-hooks-api.json");
        this.modManager.loadFromResource("/mythruna/base-time-api.json");
        this.modManager.loadFromResource("/mythruna/base-encounter-api.json");
        this.modManager.loadFromResource("/mythruna/objects/standard-objects.json");
        this.modManager.loadFromResource("/mythruna/quests/standard-quests.json");
        this.modManager.loadFromResource("/mythruna/triggers/standard-triggers.json");
        this.modManager.loadFromResource("/mythruna/clothing/standard-clothing.json");
        this.modManager.loadFromResource("/mythruna/encounters/standard-encounters.json");
        this.modManager.loadFromResource("/mythruna/property/base-property.json");
        this.modManager.loadFromResource("/mythruna/world/world-apis.json");
        this.modManager.loadFromResource("/mythruna/mobs/standard-mobs.json");
        this.modManager.loadFromResource("/mythruna/base-accounts.json");
        this.modManager.loadFromResource("/mythruna/prototype/dungeon-prototype.json");
        tracker.increment();
        this.worldFractal = WorldFractalFactory.create(this.info);
        if (this.info.getFractalHash() == null) {
            log.info("Resetting fractal hash...");
            this.info.setFractalHash(this.worldFractal.getFractalHash());
            WorldLibrary.store(this.info);
        } else {
            log.info("Checking fractal hash...");
            if (this.info.getFractalHash().longValue() != this.worldFractal.getFractalHash()) {
                log.warn("Current world fractal does not match stored world data.");
            }
        }
        tracker.increment();
        this.textDb = new MultipartTextDb(new CompositeTextDb(new FileTextDb(this.info.getFile("text-db")), new ResourceTextDb("text-db")));
        if (this.ed == null) {
            try {
                log.info("DB URI:" + this.info.getFile("entities").toURI().toString());
                this.ed = new SqlEntityData(this.info.getFile("entities"), 1000L, 256);
                this.setupPersistentComponents((PersistentEntityData)this.ed);
            }
            catch (Exception e) {
                Throwable root = Throwables.getRootCause((Throwable)e);
                if (String.valueOf(root.getMessage()).contains("Database lock acquisition failure")) {
                    throw new RuntimeException("World database already in use.", e);
                }
                throw new RuntimeException("Error starting entity database", e);
            }
        }
        tracker.increment();
        if (this.info.getSpawnPoint() == null) {
            log.warn("World is missing spawn location:" + this.info);
            long start = System.nanoTime();
            Vec3d spawn = WorldUtils.findSpawn(this.worldFractal);
            long end = System.nanoTime();
            log.info("Calculated spawn, new style:" + spawn + "  in:" + (double)(end - start) / 1000000.0 + " ms");
            spawn.y = this.getElevation((int)spawn.x, (int)spawn.z);
            spawn.y += 1.0;
            this.info.setSpawnPoint(spawn);
            WorldLibrary.store(this.info);
        }
        tracker.increment();
        if (this.info.getWorldEntity() == null) {
            Random rand = new Random(this.info.getSeed());
            int worldYears = 400 + rand.nextInt(100);
            int months = 0;
            WorldTime wt = new WorldTime(worldYears, months, 0, 6, 0);
            log.info("Generating world time offset:" + wt.asFullString() + "  realNanos:" + wt.getRealTimeNanos());
            this.worldEntity = this.ed.createEntity();
            this.ed.setComponent(this.worldEntity, (EntityComponent)new WorldAge(wt.getRealTimeNanos()));
            this.ed.setComponent(this.worldEntity, (EntityComponent)new Name(this.info.getName()));
            this.ed.setComponent(this.worldEntity, (EntityComponent)new WorldSeed(this.info.getSeed()));
            this.info.setWorldEntity(this.worldEntity.getId());
            WorldLibrary.store(this.info);
        } else {
            this.worldEntity = new EntityId(this.info.getWorldEntity().longValue());
        }
        tracker.increment();
        try {
            global = BlockTypeData.load((String)"/blocks.bset");
            if (global == null) {
                throw new RuntimeException("No base blockset data found for resource: blocks.bset");
            }
            File bsetFile = this.info.getFile("blocks.bset");
            File lastBsetFile = this.info.getFile("last-global-blocks.bset");
            local = BlockTypeData.load((File)bsetFile);
            changed2 = false;
            if (local == null) {
                log.info("Initializing world blockset file.");
                local = global;
                changed2 = true;
            } else {
                log.info("Checking for blockset upgrades.");
                lastGlobal = BlockTypeData.load((File)lastBsetFile);
                if (lastGlobal != null) {
                    log.info("Comparing global blockset snapshot...");
                    changed2 = lastGlobal.update(global);
                } else {
                    changed2 = true;
                }
                if (changed2) {
                    log.info("Upgrading local version to latest global...");
                    local.update(global);
                }
            }
            if (changed2) {
                log.info("Storing world blockset:" + bsetFile);
                BlockTypeData.store((BlockTypeData)local, (File)bsetFile);
                log.info("Storing global blockset snapshot:" + lastBsetFile);
                BlockTypeData.store((BlockTypeData)global, (File)lastBsetFile);
                indexFile2 = this.info.getFile("block.index");
                log.info("Writing block.index:" + indexFile2);
                local.writeIndex(indexFile2);
            }
            BlockTypeIndex.reset();
            BlockTypeIndex.initialize((BlockTypeData)local);
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing world blockset", e);
        }
        tracker.increment();
        try {
            global = FluidTypeData.load((String)"/fluids.fset");
            if (global == null) {
                throw new RuntimeException("No base fluidset data found for resource: fluids.fset");
            }
            File fsetFile = this.info.getFile("fluids.fset");
            File lastFsetFile = this.info.getFile("last-global-fluids.fset");
            local = FluidTypeData.load((File)fsetFile);
            changed2 = false;
            if (local == null) {
                log.info("Initializing world fluidset file.");
                local = global;
                changed2 = true;
            } else {
                log.info("Checking for fluidset upgrades.");
                lastGlobal = FluidTypeData.load((File)lastFsetFile);
                if (lastGlobal != null) {
                    log.info("Comparing global fluidset snapshot...");
                    changed2 = lastGlobal.update((FluidTypeData)global);
                } else {
                    changed2 = true;
                }
                if (changed2) {
                    log.info("Upgrading local version to latest global...");
                    local.update((FluidTypeData)global);
                }
            }
            if (changed2) {
                log.info("Storing world fluidset:" + fsetFile);
                FluidTypeData.store((FluidTypeData)local, (File)fsetFile);
                log.info("Storing global fluidset snapshot:" + lastFsetFile);
                FluidTypeData.store((FluidTypeData)global, (File)lastFsetFile);
                indexFile2 = this.info.getFile("fluid.index");
                log.info("Writing fluid.index:" + indexFile2);
                local.writeIndex(indexFile2);
            }
            FluidTypeIndex.reset();
            FluidTypeIndex.initialize((FluidTypeData)local);
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing world fluidset", e);
        }
        tracker.increment();
        try {
            global = FabricTypeData.load("/fabrics.fabs");
            if (global == null) {
                log.warn("No base fabricset data found for resource: fabrics.fabs, using default config");
                global = FabricConfig.initialize();
            }
            if (changed = (updater = new DataUpdater<FabricTypeData>(this.info.getFile("fabrics.fabs")){

                public FabricTypeData read(InputStream in) throws IOException {
                    return FabricTypeData.load(in);
                }

                public void write(FabricTypeData data, OutputStream out) throws IOException {
                    FabricTypeData.store(data, out);
                }
            }).update((UpdateableData)global)) {
                indexFile = this.info.getFile("fabrics.index");
                log.info("Writing fabrics.index:" + indexFile);
                ((FabricTypeData)updater.getData()).writeIndex(indexFile);
            }
            FabricTypeIndex.reset();
            FabricTypeIndex.initialize((FabricTypeData)updater.getData());
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing world fabric set", e);
        }
        tracker.increment();
        try {
            global = SwatchShapeData.load("/swatch.shapes");
            if (global == null) {
                log.warn("No base swatchet data found for resource: swatch.shapes, using default config");
                global = ShapeConfig.initialize();
            }
            if (changed = (updater = new DataUpdater<SwatchShapeData>(this.info.getFile("swatch.shapes")){

                public SwatchShapeData read(InputStream in) throws IOException {
                    return SwatchShapeData.load(in);
                }

                public void write(SwatchShapeData data, OutputStream out) throws IOException {
                    SwatchShapeData.store(data, out);
                }
            }).update((UpdateableData)global)) {
                indexFile = this.info.getFile("swatch.index");
                log.info("Writing swatch.index:" + indexFile);
                ((SwatchShapeData)updater.getData()).writeIndex(indexFile);
            }
            SwatchShapeIndex.reset();
            SwatchShapeIndex.initialize((SwatchShapeData)updater.getData());
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing world shape set", e);
        }
        tracker.increment();
        EntityId spawnClaim = null;
        updater = this.findWorldItems(ContainedIn.class, ClaimArea.class).iterator();
        if (updater.hasNext()) {
            EntityId child = (EntityId)updater.next();
            log.info("Found spawnClaim:" + child);
            spawnClaim = child;
        }
        tracker.increment();
        if (spawnClaim == null) {
            log.info("**** Creating spawn tower claim area ***");
            spawnClaim = this.ed.createEntity();
        } else {
            ComponentFilter filter = Filters.fieldEquals(ClaimMarker.class, (String)"claim", spawnClaim);
            for (EntityId child : this.ed.findEntities(filter, new Class[]{ClaimMarker.class})) {
                this.ed.removeEntity(child);
            }
        }
        tracker.increment();
        Vec3i center = this.info.getSpawnPoint().floor();
        Vec3d pos = center.toVec3d().addLocal(0.5, 0.0, 0.5);
        Vec3i min = center.subtract(10, 0, 10);
        min.y = this.getElevation(min.x, min.z);
        Vec3i max = center.add(10, 0, 10);
        max.y = this.getElevation(max.x, max.z);
        this.ed.setComponents(spawnClaim, new EntityComponent[]{new Name("En'dael"), ObjectName.create("Claim Area", (EntityData)this.ed), ObjectTypeInfo.create("Claim", (EntityData)this.ed), new SpawnPosition(GameConstants.PHYSICS_GRID, pos), new LargeGridCell(GameConstants.LARGE_OBJECT_GRID.worldToId(pos)), new ClaimArea(min, center.add(10, 0, 10)), ClaimMarker.create(spawnClaim, "/Models/symbols/property-marker.blocks", (EntityData)this.ed), new ContainedIn(this.worldEntity, this.worldEntity, 0, 0), new OwnedBy(this.worldEntity), ClaimType.createStandard((byte)1, null), MapMarker.create("spawn", 10, pos, (EntityData)this.ed)});
        Vec3d offset = new Vec3d(0.5, 0.0, 0.5);
        this.ed.setComponents(this.ed.createEntity(), new EntityComponent[]{new Name("En'dael Corner Marker"), ObjectTypeInfo.create("CornerMarker", (EntityData)this.ed), ClaimMarker.create(spawnClaim, "/Models/symbols/property-corner.blocks", (EntityData)this.ed), new SpawnPosition(GameConstants.PHYSICS_GRID, offset.add(min))});
        this.ed.setComponents(this.ed.createEntity(), new EntityComponent[]{new Name("En'dael Corner Marker"), ObjectTypeInfo.create("CornerMarker", (EntityData)this.ed), ClaimMarker.create(spawnClaim, "/Models/symbols/property-corner.blocks", (EntityData)this.ed), new SpawnPosition(GameConstants.PHYSICS_GRID, offset.add(max))});
        Vec3i v = new Vec3i();
        v.set(min.x, 0, max.z);
        v.y = this.getElevation(v.x, v.z);
        this.ed.setComponents(this.ed.createEntity(), new EntityComponent[]{new Name("En'dael Corner Marker"), ObjectTypeInfo.create("CornerMarker", (EntityData)this.ed), ClaimMarker.create(spawnClaim, "/Models/symbols/property-corner.blocks", (EntityData)this.ed), new SpawnPosition(GameConstants.PHYSICS_GRID, offset.add(v))});
        v.set(max.x, 0, min.z);
        v.y = this.getElevation(v.x, v.z);
        this.ed.setComponents(this.ed.createEntity(), new EntityComponent[]{new Name("En'dael Corner Marker"), ObjectTypeInfo.create("CornerMarker", (EntityData)this.ed), ClaimMarker.create(spawnClaim, "/Models/symbols/property-corner.blocks", (EntityData)this.ed), new SpawnPosition(GameConstants.PHYSICS_GRID, offset.add(v))});
        tracker.increment();
        File tileRoot = this.info.getFile("tile.db");
        TerrainImageDb terrainImageDb = new TerrainImageDb(tileRoot);
        this.tileManager = new TileManager(terrainImageDb);
        this.sedectileManager = new SedectileManager(tileRoot, new WorkspaceFunction[0]);
        this.sedectileManager.addWorkspaceFunction(new SedectileDataGenerator(this.worldFractal, this.info.getSeed(), (EntityData)this.ed));
        this.sedectileManager.addWorkspaceFunction(new CaveNetworkGenerator(this.worldFractal, this.worldEntity, this.info.getSeed(), (EntityData)this.ed));
        this.sedectileManager.addWorkspaceFunction(new RegionGenerator());
        this.sedectileManager.addWorkspaceFunction(new SeaCostGenerator());
        this.sedectileManager.addWorkspaceFunction(new TestPoiGenerator(this.info.getSeed(), spawnClaim, this.worldFractal, this.worldEntity, (EntityData)this.ed));
        this.tileManager.addTileFunction(new TileFunction[]{new TerrainElevationGenerator(this.worldFractal)});
        this.tileManager.addTileFunction(new TileFunction[]{new TerrainTypeGenerator(this.worldFractal)});
        TestBlockRegistry blocksFunction = new TestBlockRegistry();
        this.morphDb = new MorphologyLayerDb(tileRoot, new MorphologyLayerProtocol());
        this.morphDb.getProtocol().registerProtocol(BoxFill.class, (ObjectProtocol)new BoxFillProtocol());
        this.morphDb.getProtocol().registerProtocol(SphereFill.class, (ObjectProtocol)new SphereFillProtocol());
        this.morphDb.getProtocol().registerProtocol(RiverSection.class, (ObjectProtocol)new RiverSectionProtocol());
        this.morphDb.getProtocol().registerProtocol(WaterBody.class, (ObjectProtocol)new WaterBodyProtocol());
        this.morphDb.getProtocol().registerProtocol(RoadSection.class, (ObjectProtocol)new RoadSectionProtocol());
        this.morphDb.getProtocol().registerProtocol(PointInfluencer.class, (ObjectProtocol)new PointInfluencerProtocol());
        this.morphDb.getProtocol().registerProtocol(LineInfluencer.class, (ObjectProtocol)new LineInfluencerProtocol());
        this.morphDb.getProtocol().registerProtocol(WallInfluencer.class, (ObjectProtocol)new WallInfluencerProtocol());
        BuildTypes buildTypes = new BuildTypes();
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{tile -> tile.put(BuildTypes.class, (Object)buildTypes)});
        this.tileManager.addTileFunction(new TileFunction[]{this.morphDb.getLoadFunction()});
        this.tileManager.addTileFunction(new TileFunction[]{new CaveTileFunction(this.sedectileManager)});
        File testFile = new File(this.info.getSeed() + "-rivers.json");
        File testFile2 = new File(this.info.getSeed() + "-ponds.json");
        if (testFile.exists()) {
            log.info("Adding test river function for file:" + testFile);
            this.tileManager.addTileFunction(new TileFunction[]{new WaterBodyFileTileFunction(testFile2), new RiverFileTileFunction(testFile)});
        }
        if ((testFile3 = new File(this.info.getSeed() + "-roads.json")).exists()) {
            log.info("Adding test road function for file:" + testFile3);
            this.tileManager.addTileFunction(new TileFunction[]{new RoadFileTileFunction(testFile3)});
        }
        this.tileManager.addTileFunction(new TileFunction[]{new ApplyMorphologyFunction()});
        this.insertDb = new InsertLayerDb(tileRoot, new InsertLayerProtocol());
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.insertDb.getLoadFunction()});
        this.treeDb = new TreeLayerDb(tileRoot, new TreeLayerProtocol());
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.treeDb.getLoadFunction()});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{new TreeGenerator(this.worldFractal), new ApplyTreeSplatsFunction()});
        this.tileManager.addTileFunction(new TileFunction[]{new TestPoiTileFunction(this.sedectileManager, (EntityData)this.ed, blocksFunction, this.info.getSpawnPoint(), this.worldFractal)});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{new ApplyInsertsFunction((Function)blocksFunction, (TerrainTypeFunction)new InsertTypeFunction(), (IntCombiner)new InsertTerrainMerge())});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.treeDb.getSaveFunction()});
        this.tileManager.addTileFunction(new TileFunction[]{this.morphDb.getSaveFunction()});
        this.tileManager.addTileFunction(Resolution.High, new TileFunction[]{this.insertDb.getSaveFunction()});
        this.tileManager.addTileFunction(new TileFunction[]{terrainImageDb.getSaveFunction()});
        File worldDb = this.info.getFile("world.db");
        int leafCount = 21;
        TileBasedColumnGenerator colGenerator = new TileBasedColumnGenerator(this.tileManager, leafCount, new TileColumnProcessor[]{new BaseColumnProcessor(this.worldFractal, this.tileManager), new MorphologyColumnProcessor(), new InsertColumnProcessor((Function)blocksFunction, (IntCombiner)new InsertBlockMerge(), null), new TreeColumnProcessor(), new FloraColumnProcessor(this.info.getSeed(), this.worldFractal)});
        GeneratedColumnDb cdb = new GeneratedColumnDb(worldDb, (Function)colGenerator);
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new MaskPostProcessor()});
        this.rawColDb = cdb;
        this.physWorld = new PhysicalWorld(this.rawColDb, 672);
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new InitialSunlightProcessor()});
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new InternalLightingProcessor()});
        cdb = new PostProcColumnDb((ColumnDb)cdb, new ColumnPostProcessor[]{new LightingPostProcessor()});
        ObservableColumnDbAdapter colDb = new ObservableColumnDbAdapter((ColumnDb)cdb);
        final TerrainImageManager terrainImageManager = new TerrainImageManager(tileRoot, terrainImageDb, (ObservableColumnDb)colDb, this.tileManager, (TerrainTypeFunction)new ImageTypeFunction());
        PointCloudManager pointCloudManager = new PointCloudManager(tileRoot, (ObservableColumnDb)colDb, this.tileManager, terrainImageManager){

            protected boolean initializeStates(TileId id, ColumnStates states) {
                boolean changed = false;
                Tile tile = this.getTileManager().getTile(id, Resolution.High);
                InsertLayer inserts = (InsertLayer)tile.get(InsertLayer.class);
                if (log.isTraceEnabled()) {
                    log.trace("PointCloud total active morph bins:" + inserts.getActiveBinIds().size());
                }
                for (Short s : inserts.getActiveBinIds()) {
                    if (!states.markDirty(s.shortValue())) continue;
                    changed = true;
                }
                MorphologyLayer morph = (MorphologyLayer)tile.get(MorphologyLayer.class);
                if (morph.hasMorphology(RoadSection.class)) {
                    for (Short s : morph.getActiveBinIds()) {
                        if (!states.markDirty(s.shortValue())) continue;
                        changed = true;
                    }
                }
                if (changed) {
                    TerrainImage terrainImage = terrainImageManager.getTerrainImage(id, TerrainImageType.Terrain, Resolution.High);
                }
                return changed;
            }
        };
        pointCloudManager.setPointIndexFunction((PointIndexFunction)new PointTypeMapping());
        this.cellArrayDb = new DefaultCellArrayStorage(this.info.getFile("blueprints"));
        this.subassemblyDb = new DefaultSubassemblyStorage(this.info.getFile("assemblies"));
        tracker.increment();
        this.treeDb.initialize();
        this.morphDb.initialize();
        this.insertDb.initialize();
        tracker.increment();
        this.sedectileManager.initialize();
        tracker.increment();
        this.world = new DefaultWorld((ColumnDb)colDb, this.tileManager, terrainImageManager, pointCloudManager, 672);
        this.world.initialize();
        tracker.increment();
        this.modManager.setGlobalBinding("world", (Object)this.world);
        WorldStringInitializer.initializeStrings(this);
        tracker.increment();
    }

    protected void setupPersistentComponents(PersistentEntityData ped) {
        ped.markPersistentType(LargeGridCell.class);
        ped.markPersistentType(LargeObject.class);
        ped.markPersistentType(Gravity.class);
        ped.markPersistentType(Impulse.class);
        ped.markPersistentType(Mass.class);
    }

    public void close() {
        this.world.terminate();
        this.treeDb.terminate();
        this.morphDb.terminate();
        this.insertDb.terminate();
        this.sedectileManager.terminate();
        BlockTypeIndex.reset();
        FluidTypeIndex.reset();
        FabricTypeIndex.reset();
        SwatchShapeIndex.reset();
    }

    public static WorldManager loadWorld(WorldInfo info) {
        WorldManager result = new WorldManager(info);
        ProgressTracker tracker = ProgressTrackers.openTracker((String)"Loading world...");
        try {
            result.initialize(tracker);
        }
        finally {
            tracker.close(true);
        }
        return result;
    }

    public static WorldManager createWorld(WorldInfo info) {
        WorldManager result = new WorldManager(info);
        ProgressTracker tracker = ProgressTrackers.openTracker((String)"Creating world...");
        try {
            result.initialize(tracker);
        }
        finally {
            tracker.close(true);
        }
        Vec3d spawn = info.getSpawnPoint();
        log.info("Generating preview image...");
        double previewSize = 65536.0;
        Vec3d corner = spawn.subtract(previewSize * 0.5, 0.0, previewSize * 0.5);
        BufferedImage image = WorldUtils.createMapImage(result.worldFractal, 512, corner.x, corner.z, previewSize);
        try {
            File imgFile = info.getFile("preview.png");
            ImageIO.write((RenderedImage)image, "png", imgFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating preview", e);
        }
        WorldLibrary.store(info);
        return result;
    }
}

