/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import mythruna.text.md.BulletElement;
import mythruna.text.md.HeaderElement;
import mythruna.text.md.HighlightElement;
import mythruna.text.md.MarkdownBuffer;
import mythruna.text.md.MdElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownUtil {
    static Logger log = LoggerFactory.getLogger(MarkdownUtil.class);

    public static GuiLayout createLayout() {
        return new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.None);
    }

    public static Container createContainer(ElementId elementId) {
        return new Container(MarkdownUtil.createLayout(), elementId);
    }

    public static void populateContainer(Container container, float maxTextWidth, String text) {
        MarkdownUtil.populateContainer(container, maxTextWidth, new MarkdownBuffer(text));
    }

    public static void populateContainer(Container container, float maxTextWidth, MarkdownBuffer md) {
        container.clearChildren();
        ElementId baseId = container.getElementId();
        for (MdElement el : md) {
            Label label;
            Label label2;
            if (el instanceof HeaderElement) {
                HeaderElement header = (HeaderElement)el;
                label2 = new Label(el.getText(), baseId.child("h" + header.getLevel() + ".label"));
                label2.setMaxWidth(maxTextWidth);
                container.addChild((Node)label2, new Object[0]);
                continue;
            }
            if (el instanceof BulletElement) {
                BulletElement bullet = (BulletElement)el;
                label2 = new Label(el.getText(), baseId.child("b" + bullet.getLevel() + ".label"));
                label2.setMaxWidth(maxTextWidth);
                container.addChild((Node)label2, new Object[0]);
                continue;
            }
            if (el instanceof HighlightElement) {
                label = new Label(el.getText(), baseId.child("highlight.label"));
                label.setMaxWidth(maxTextWidth);
                container.addChild((Node)label, new Object[0]);
                continue;
            }
            label = new Label(el.getText(), baseId.child("text.label"));
            label.setMaxWidth(maxTextWidth);
            container.addChild((Node)label, new Object[0]);
        }
    }
}

