/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.state.DebugHudState;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCounts {
    static Logger log = LoggerFactory.getLogger(ModelCounts.class);
    private DebugHudState debugHud;
    private Map<String, CountView> views = new HashMap<String, CountView>();
    private VersionedHolder<String> mobCountView;
    private VersionedHolder<String> modelCountView;
    private VersionedHolder<String> largeModelCountView;
    private VersionedHolder<String> spatialCountView;

    public void updateCount(String name, int count) {
        CountView view = this.getView(name, true);
        view.setCount(count);
    }

    public CountView createView(String name) {
        return this.getView(name, true);
    }

    public void initialize(DebugHudState debugHud) {
        this.debugHud = debugHud;
        for (CountView view : this.views.values()) {
            view.initialize(debugHud);
        }
    }

    public void terminate() {
        for (CountView view : this.views.values()) {
            view.terminate(this.debugHud);
        }
    }

    protected CountView getView(String name, boolean create) {
        CountView view = this.views.get(name);
        if (view == null && create) {
            view = new CountView(name);
            view.initialize(this.debugHud);
            this.views.put(name, view);
        }
        return view;
    }

    public class CountView {
        private String name;
        private int count;
        private VersionedHolder<String> view;

        public CountView(String name) {
            this.name = name;
            this.count = -1;
        }

        protected void initialize(DebugHudState debugHud) {
            if (debugHud != null) {
                this.view = debugHud.createDebugValue(this.name, DebugHudState.Location.Right);
                if (this.count >= 0) {
                    this.view.setObject((Object)String.valueOf(this.count));
                }
            }
        }

        protected void terminate(DebugHudState debugHud) {
            debugHud.removeDebugValue(this.name);
        }

        public void setCount(int count) {
            if (this.count == count) {
                return;
            }
            this.count = count;
            if (this.view != null) {
                this.view.setObject((Object)String.valueOf(count));
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

