/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Predicate;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.text.DefaultDocumentModel;
import com.simsilica.lemur.text.DocumentModel;
import com.simsilica.lemur.text.DocumentModelFilter;
import com.simsilica.lemur.text.TextFilters;

public class PasswordField
extends TextField {
    public static final String ELEMENT_ID = "password.textField";
    private DocumentModel delegate;
    private DocumentModelFilter wrapper;
    private Predicate<Character> allowed;
    private char outputChar;

    public PasswordField(String text) {
        this(new DefaultDocumentModel(text), true, new ElementId(ELEMENT_ID), null);
    }

    public PasswordField(DocumentModel model) {
        this(model, true, new ElementId(ELEMENT_ID), null);
    }

    public PasswordField(String text, String style) {
        this(new DefaultDocumentModel(text), true, new ElementId(ELEMENT_ID), style);
    }

    public PasswordField(String text, ElementId elementId) {
        this(new DefaultDocumentModel(text), true, elementId, null);
    }

    public PasswordField(String text, ElementId elementId, String style) {
        this(new DefaultDocumentModel(text), true, elementId, style);
    }

    public PasswordField(DocumentModel model, String style) {
        this(model, true, new ElementId(ELEMENT_ID), style);
    }

    protected PasswordField(DocumentModel model, boolean applyStyles, ElementId elementId, String style) {
        super(model, applyStyles, elementId, style);
    }

    @Override
    protected void setDocumentModel(DocumentModel model) {
        this.delegate = model;
        this.wrapper = new DocumentModelFilter(model);
        this.wrapper.setOutputTransform(TextFilters.constantTransform('*'));
        super.setDocumentModel(this.wrapper);
    }

    @Override
    public DocumentModel getDocumentModel() {
        return this.delegate;
    }

    @Override
    @StyleAttribute(value="text", lookupDefault=false)
    public void setText(String s) {
        this.delegate.setText(s);
    }

    @Override
    public String getText() {
        return this.delegate == null ? null : this.delegate.getText();
    }

    public String getDisplayText() {
        return this.wrapper == null ? null : this.wrapper.getText();
    }

    @StyleAttribute(value="outputCharacter", lookupDefault=false)
    public void setOutputCharacter(Character c) {
        this.outputChar = (char)(c == null ? 42 : (int)c.charValue());
        this.wrapper.setOutputTransform(TextFilters.constantTransform(this.outputChar));
    }

    public char getOutputCharacter() {
        return this.outputChar;
    }

    @StyleAttribute(value="allowedCharacters", lookupDefault=false)
    public void setAllowedCharacters(Predicate<Character> allowed) {
        this.allowed = allowed;
        this.wrapper.setInputTransform(TextFilters.charFilter(allowed));
    }

    public Predicate<Character> getAllowedCharacters() {
        return this.allowed;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[text=" + this.getDisplayText() + ", color=" + this.getColor() + ", elementId=" + this.getElementId() + "]";
    }
}

