/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Platform;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLPlatform;

public final class LwjglPlatform
implements Platform {
    final CLPlatform platform;
    List<LwjglDevice> devices;

    public LwjglPlatform(CLPlatform platform) {
        this.platform = platform;
    }

    public CLPlatform getPlatform() {
        return this.platform;
    }

    public List<LwjglDevice> getDevices() {
        if (this.devices == null) {
            this.devices = new ArrayList<LwjglDevice>();
            for (CLDevice d : this.platform.getDevices(-1)) {
                this.devices.add(new LwjglDevice(d, this));
            }
        }
        return this.devices;
    }

    public String getProfile() {
        return this.platform.getInfoString(2304);
    }

    public boolean isFullProfile() {
        return this.getProfile().contains("FULL_PROFILE");
    }

    public boolean isEmbeddedProfile() {
        return this.getProfile().contains("EMBEDDED_PROFILE");
    }

    public String getVersion() {
        return this.platform.getInfoString(2305);
    }

    public int getVersionMajor() {
        return Utils.getMajorVersion(this.getVersion(), "OpenCL ");
    }

    public int getVersionMinor() {
        return Utils.getMinorVersion(this.getVersion(), "OpenCL ");
    }

    public String getName() {
        return this.platform.getInfoString(2306);
    }

    public String getVendor() {
        return this.platform.getInfoString(2307);
    }

    public boolean hasExtension(String extension) {
        return this.getExtensions().contains(extension);
    }

    public boolean hasOpenGLInterop() {
        return this.hasExtension("cl_khr_gl_sharing");
    }

    public Collection<? extends String> getExtensions() {
        return Arrays.asList(this.platform.getInfoString(2308).split(" "));
    }

    public String toString() {
        return this.getName();
    }
}

