/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys.debug;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.debug.DebugShapeFactory;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mathd.AaBBox;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.BinIndex;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyDebugState<S extends AbstractShape>
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(BodyDebugState.class);
    private MPhysSystem<S> mphys;
    private PhysicsSpace<EntityId, S> space;
    private Grid grid;
    private ObjectObserver observer = new ObjectObserver();
    private Node objectRoot;
    private Vec3i lastCenter = new Vec3i();
    private Vec3i lastCenterWorld = new Vec3i();
    private Vec3d viewOrigin = new Vec3d();
    private Camera camera;
    private Vec3d eyeLocation = new Vec3d();
    private Map<EntityId, BodyView> bodyIndex = new HashMap<EntityId, BodyView>();
    private DynArray bodies = new DynArray(BodyView.class);
    private Queue<RigidBody<EntityId, S>> addedBodies = new ConcurrentLinkedQueue<RigidBody<EntityId, S>>();
    private Queue<RigidBody<EntityId, S>> removedBodies = new ConcurrentLinkedQueue<RigidBody<EntityId, S>>();
    private Map<EntityId, StaticBodyView> staticBodyIndex = new HashMap<EntityId, StaticBodyView>();
    private DynArray staticBodies = new DynArray(StaticBodyView.class);
    private Queue<StaticBody<EntityId, S>> addedStaticBodies = new ConcurrentLinkedQueue<StaticBody<EntityId, S>>();
    private Queue<StaticBody<EntityId, S>> removedStaticBodies = new ConcurrentLinkedQueue<StaticBody<EntityId, S>>();
    private DynArray<DebugShapeFactory> debugFactories = new DynArray(DebugShapeFactory.class);
    private Mesh axesMesh;
    private Geometry axesTemplate;
    private Mesh cogMesh;
    private Mesh boundsSphere;
    private static ColorRGBA HOTTEST = new ColorRGBA(1.0f, 1.0f, 0.5f, 1.0f);
    private static ColorRGBA HOT = ColorRGBA.Yellow;
    private static ColorRGBA WARM = ColorRGBA.Red;
    private static ColorRGBA COOLING = new ColorRGBA(0.5f, 0.0f, 0.0f, 1.0f);
    private static ColorRGBA COLD = ColorRGBA.Cyan;

    public BodyDebugState(MPhysSystem<S> mphys) {
        this.mphys = mphys;
        this.space = mphys.getPhysicsSpace();
        this.grid = this.space.getGrid();
        this.setEnabled(false);
    }

    public void addDebugShapeFactory(DebugShapeFactory<S> factory) {
        if (this.isInitialized()) {
            factory.initialize(this);
        }
        this.debugFactories.add(factory);
    }

    public void removeDebugShapeFactory(DebugShapeFactory<S> factory) {
        if (this.isInitialized()) {
            factory.terminate(this);
        }
        this.debugFactories.remove(factory);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    public void setViewOrigin(double x, double y, double z) {
        this.viewOrigin.set(x, y, z);
    }

    public void setViewOrigin(Vec3d origin) {
        this.setViewOrigin(origin.x, origin.y, origin.z);
    }

    public Vec3d getViewOrigin() {
        return this.viewOrigin;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected Camera getCamera() {
        if (this.camera == null) {
            this.camera = this.getApplication().getCamera();
        }
        return this.camera;
    }

    protected void initialize(Application app) {
        this.objectRoot = new Node("objectRoot");
        float axesSize = 0.1f;
        this.axesMesh = new Mesh();
        this.axesMesh.setMode(Mesh.Mode.Lines);
        this.axesMesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, axesSize, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, axesSize, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, axesSize});
        this.axesMesh.setBuffer(VertexBuffer.Type.Color, 4, new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f});
        this.axesTemplate = new Geometry("axes", this.axesMesh);
        this.axesTemplate.setQueueBucket(RenderQueue.Bucket.Translucent);
        Material mat = GuiGlobals.getInstance().createMaterial(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.5f), false).getMaterial();
        mat.setBoolean("VertexColor", true);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.axesTemplate.setMaterial(mat);
        float cogSize = axesSize * 0.1f;
        this.cogMesh = new WireBox(cogSize, cogSize, cogSize);
        this.boundsSphere = new Sphere(24, 24, 1.0f);
        for (DebugShapeFactory factory : this.debugFactories) {
            factory.initialize(this);
        }
    }

    protected void cleanup(Application app) {
        for (DebugShapeFactory factory : this.debugFactories) {
            factory.terminate(this);
        }
    }

    protected void onEnable() {
        StaticBody body;
        this.mphys.getBinEntityManager().addObjectStatusListener(this.observer);
        this.getRoot().attachChild((Spatial)this.objectRoot);
        PhysicsSpace<EntityId, S> space = this.mphys.getPhysicsSpace();
        BinIndex bins = space.getBinIndex();
        for (EntityId id : bins.getBodyIds()) {
            log.info("Loading existing ID:" + id);
            body = bins.getRigidBody((Object)id);
            this.bodyAdded((RigidBody<EntityId, S>)body);
        }
        for (EntityId id : bins.getStaticBodyIds()) {
            body = bins.getStaticBody((Object)id);
            this.staticBodyAdded(body);
        }
    }

    protected void onDisable() {
        this.objectRoot.removeFromParent();
        this.mphys.getBinEntityManager().removeObjectStatusListener(this.observer);
        this.clearBodies();
    }

    public void update(float tpf) {
        RigidBody<EntityId, S> body = null;
        while ((body = this.addedBodies.poll()) != null) {
            this.bodyAdded(body);
        }
        while ((body = this.removedBodies.poll()) != null) {
            this.bodyRemoved(body);
        }
        StaticBody<EntityId, S> sb = null;
        while ((sb = this.addedStaticBodies.poll()) != null) {
            this.staticBodyAdded(sb);
        }
        while ((sb = this.removedStaticBodies.poll()) != null) {
            this.staticBodyRemoved(sb);
        }
        this.updateCenter();
    }

    protected void updateCenter() {
        Vector3f cameraPos = this.getCamera().getLocation();
        Vec3d world = this.viewOrigin.add(new Vec3d(cameraPos));
        this.eyeLocation.set(world);
        Vec3i center = this.grid.worldToCell(world.x, 0.0, world.z);
        if (!center.equals((Object)this.lastCenter)) {
            this.lastCenter.set(center);
            this.updateVisibility();
        }
        this.updatePositions();
    }

    protected void updateVisibility() {
        for (Object view : this.bodies.getArray()) {
            ((BodyView)view).updateVisibility();
        }
        for (Object view : this.staticBodies.getArray()) {
            ((StaticBodyView)view).updateVisibility();
        }
    }

    protected void updatePositions() {
        for (Object view : this.bodies.getArray()) {
            ((BodyView)view).updatePosition();
        }
        for (Object view : this.staticBodies.getArray()) {
            ((StaticBodyView)view).updatePosition();
        }
    }

    public static ColorRGBA temperatureToColor(double temperature, ColorRGBA target, float alpha) {
        if (temperature > 0.75) {
            double t = (temperature - 0.75) * 4.0;
            target.interpolateLocal(HOT, HOTTEST, (float)t);
        } else if (temperature > 0.5) {
            double t = (temperature - 0.5) * 4.0;
            target.interpolateLocal(WARM, HOT, (float)t);
        } else if (temperature > 0.25) {
            double t = (temperature - 0.25) * 4.0;
            target.interpolateLocal(COOLING, WARM, (float)t);
        } else {
            double t = temperature * 4.0;
            target.interpolateLocal(COLD, COOLING, (float)t);
        }
        target.a = alpha;
        return target;
    }

    protected void clearBodies() {
        for (BodyView bodyView : this.bodyIndex.values()) {
            this.bodies.remove((Object)bodyView);
            bodyView.release();
        }
        this.bodyIndex.clear();
        for (StaticBodyView staticBodyView : this.staticBodyIndex.values()) {
            this.staticBodies.remove((Object)staticBodyView);
            staticBodyView.release();
        }
        this.staticBodyIndex.clear();
    }

    protected void bodyAdded(RigidBody<EntityId, S> body) {
        log.info("bodyAdded(" + body.id + ")");
        BodyView view = this.bodyIndex.get(body.id);
        if (view != null) {
            log.error("Added entity body already has a view:" + body.id + ", view:" + view);
            return;
        }
        view = new BodyView(body);
        this.bodyIndex.put((EntityId)body.id, view);
        this.bodies.add((Object)view);
        view.updateVisibility();
    }

    protected void bodyRemoved(RigidBody<EntityId, S> body) {
        log.info("bodyRemoved(" + body.id + ")");
        BodyView view = this.bodyIndex.remove(body.id);
        if (view == null) {
            log.error("Removed entity body has no view:" + body.id);
            return;
        }
        this.bodies.remove((Object)view);
        view.release();
    }

    protected void staticBodyAdded(StaticBody<EntityId, S> body) {
        log.info("staticBodyAdded(" + body.id + ")");
        StaticBodyView view = this.staticBodyIndex.get(body.id);
        if (view != null) {
            log.error("Added entity body already has a view:" + body.id + ", view:" + view);
            return;
        }
        view = new StaticBodyView(body);
        this.staticBodies.add((Object)view);
        this.staticBodyIndex.put((EntityId)body.id, view);
        view.updateVisibility();
    }

    protected void staticBodyRemoved(StaticBody<EntityId, S> body) {
        log.info("staticBodyRemoved(" + body.id + ")");
        StaticBodyView view = this.staticBodyIndex.remove(body.id);
        if (view == null) {
            log.error("Removed entity body has no view:" + body.id);
            return;
        }
        this.staticBodies.remove((Object)view);
        view.release();
    }

    private class StaticBodyView {
        EntityId entity;
        StaticBody<EntityId, S> body;
        Vec3d pos = new Vec3d();
        Quatd orient = new Quatd();
        Node view;
        Node orientedView;
        Spatial axes;
        Mesh aabbMesh;
        ColorRGBA color;
        long lastShapeVersion;

        public StaticBodyView(StaticBody<EntityId, S> body) {
            this.entity = (EntityId)body.id;
            this.body = body;
            this.view = new Node("StaticBodyView:" + this.entity);
            this.orientedView = new Node("OrientedView:" + this.entity);
            this.view.attachChild((Spatial)this.orientedView);
            this.axes = BodyDebugState.this.axesTemplate.clone();
            this.orientedView.attachChild(this.axes);
            this.color = ColorRGBA.Black.clone();
            Geometry geom = new Geometry("cog", BodyDebugState.this.cogMesh);
            geom.setMaterial(GuiGlobals.getInstance().createMaterial(this.color, false).getMaterial());
            geom.setQueueBucket(RenderQueue.Bucket.Translucent);
            this.view.attachChild((Spatial)geom);
            geom = new Geometry("boundSphere", BodyDebugState.this.boundsSphere);
            Material mat = GuiGlobals.getInstance().createMaterial(this.color, false).getMaterial();
            mat.getAdditionalRenderState().setWireframe(true);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            geom.setMaterial(mat);
            geom.setQueueBucket(RenderQueue.Bucket.Translucent);
            geom.setLocalScale((float)body.shape.getMass().getRadius());
            this.orientedView.attachChild((Spatial)geom);
            this.lastShapeVersion = body.shape.getVersion();
            this.updatePosition();
        }

        public void updatePosition() {
            if (this.lastShapeVersion < this.body.shape.getVersion()) {
                // empty if block
            }
            this.pos.set(this.body.position);
            this.orient.set(this.body.orientation);
            float x = (float)(this.pos.x - ((BodyDebugState)BodyDebugState.this).viewOrigin.x);
            float y = (float)(this.pos.y - ((BodyDebugState)BodyDebugState.this).viewOrigin.y);
            float z = (float)(this.pos.z - ((BodyDebugState)BodyDebugState.this).viewOrigin.z);
            this.view.setLocalTranslation(x, y, z);
            this.orientedView.setLocalRotation(this.orient.toQuaternion());
            double dist = this.pos.distance(BodyDebugState.this.eyeLocation) - this.body.shape.getMass().getRadius();
            dist *= dist;
            double fade = 1.0;
            if (dist > 0.0) {
                fade = Math.min(1.0, 64.0 / dist);
            }
            this.color.a = (float)Math.min(0.5, fade);
        }

        public void updateVisibility() {
            if (this.view.getParent() == null) {
                BodyDebugState.this.objectRoot.attachChild((Spatial)this.view);
            }
        }

        public void release() {
            this.view.removeFromParent();
        }
    }

    private class BodyView {
        EntityId entity;
        RigidBody<EntityId, S> body;
        Vec3d pos = new Vec3d();
        Quatd orient = new Quatd();
        Node view;
        Node orientedView;
        Spatial axes;
        ColorRGBA temperature = new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f);
        Mesh aabbMesh;
        long lastShapeVersion;

        public BodyView(RigidBody<EntityId, S> body) {
            this.entity = (EntityId)body.id;
            this.body = body;
            this.view = new Node("BodyView:" + this.entity);
            this.orientedView = new Node("OrientedView:" + this.entity);
            this.view.attachChild((Spatial)this.orientedView);
            this.axes = BodyDebugState.this.axesTemplate.clone();
            this.orientedView.attachChild(this.axes);
            Geometry geom = new Geometry("cog", BodyDebugState.this.cogMesh);
            geom.setMaterial(GuiGlobals.getInstance().createMaterial(this.temperature, false).getMaterial());
            geom.setQueueBucket(RenderQueue.Bucket.Translucent);
            this.view.attachChild((Spatial)geom);
            geom = new Geometry("boundSphere", BodyDebugState.this.boundsSphere);
            Material mat = GuiGlobals.getInstance().createMaterial(this.temperature, false).getMaterial();
            mat.getAdditionalRenderState().setWireframe(true);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            geom.setMaterial(mat);
            geom.setQueueBucket(RenderQueue.Bucket.Translucent);
            geom.setLocalScale((float)body.shape.getMass().getRadius());
            this.orientedView.attachChild((Spatial)geom);
            AaBBox bounds = body.getWorldBounds();
            Vector3f min = bounds.getMin().subtract(body.position).toVector3f();
            Vector3f max = bounds.getMax().subtract(body.position).toVector3f();
            this.aabbMesh = new Box(min, max);
            geom = new Geometry("boundBox", this.aabbMesh);
            mat = mat.clone();
            geom.setMaterial(mat);
            geom.setQueueBucket(RenderQueue.Bucket.Translucent);
            this.view.attachChild((Spatial)geom);
            for (DebugShapeFactory factory : (DebugShapeFactory[])BodyDebugState.this.debugFactories.getArray()) {
                factory.addDebugShape(body, this.orientedView, this.temperature);
            }
            this.lastShapeVersion = body.shape.getVersion();
        }

        public void updatePosition() {
            if (this.lastShapeVersion < this.body.shape.getVersion()) {
                for (DebugShapeFactory factory : (DebugShapeFactory[])BodyDebugState.this.debugFactories.getArray()) {
                    factory.updateDebugShape(this.body, this.orientedView, this.temperature);
                }
                this.lastShapeVersion = this.body.shape.getVersion();
            }
            this.pos.set(this.body.position);
            this.orient.set(this.body.orientation);
            float x = (float)(this.pos.x - ((BodyDebugState)BodyDebugState.this).viewOrigin.x);
            float y = (float)(this.pos.y - ((BodyDebugState)BodyDebugState.this).viewOrigin.y);
            float z = (float)(this.pos.z - ((BodyDebugState)BodyDebugState.this).viewOrigin.z);
            this.view.setLocalTranslation(x, y, z);
            this.orientedView.setLocalRotation(this.orient.toQuaternion());
            double dist = this.pos.distance(BodyDebugState.this.eyeLocation) - this.body.shape.getMass().getRadius();
            dist *= dist;
            double fade = 1.0;
            if (dist > 0.0) {
                fade = Math.min(1.0, 256.0 / dist);
            }
            BodyDebugState.temperatureToColor(this.body.getTemperature(), this.temperature, 0.25f * (float)fade);
        }

        public void updateVisibility() {
            if (this.view.getParent() == null) {
                BodyDebugState.this.objectRoot.attachChild((Spatial)this.view);
            }
        }

        public void release() {
            this.view.removeFromParent();
            for (DebugShapeFactory factory : (DebugShapeFactory[])BodyDebugState.this.debugFactories.getArray()) {
                factory.releaseDebugShape(this.body, this.orientedView);
            }
        }
    }

    private class ObjectObserver
    extends ObjectStatusAdapter<S> {
        @Override
        public void objectLoaded(EntityId entity, RigidBody<EntityId, S> body) {
            BodyDebugState.this.addedBodies.add(body);
        }

        @Override
        public void objectUnloaded(EntityId entity, RigidBody<EntityId, S> body) {
            BodyDebugState.this.removedBodies.add(body);
        }

        @Override
        public void staticObjectLoaded(EntityId entity, StaticBody<EntityId, S> body) {
            log.info("staticObjectLoaded(" + entity + ")");
            BodyDebugState.this.addedStaticBodies.add(body);
        }

        @Override
        public void staticObjectUnloaded(EntityId entity, StaticBody<EntityId, S> body) {
            log.info("staticObjectUNloaded(" + entity + ")");
            BodyDebugState.this.removedStaticBodies.add(body);
        }
    }
}

