/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;

public class DragHandler
extends DefaultCursorListener {
    private Vector2f drag = null;
    private Vector3f basePosition;
    private boolean consumeDrags = false;
    private boolean consumeDrops = false;
    private Function<Spatial, Spatial> draggableLocator = Functions.identity();

    public DragHandler() {
    }

    public DragHandler(Function<Spatial, Spatial> draggableLocator) {
        this.draggableLocator = draggableLocator;
    }

    public void setDraggableLocator(Function<Spatial, Spatial> draggableLocator) {
        this.draggableLocator = draggableLocator;
    }

    public Function<Spatial, Spatial> getDraggableLocator() {
        return this.draggableLocator;
    }

    public boolean isDragging() {
        return this.drag != null;
    }

    protected Vector2f getDragStartLocation() {
        return this.drag;
    }

    protected Spatial findDraggable(Spatial capture) {
        return (Spatial)this.draggableLocator.apply((Object)capture);
    }

    protected void startDrag(CursorButtonEvent event, Spatial target, Spatial capture) {
        this.drag = new Vector2f(event.getX(), event.getY());
        this.basePosition = this.findDraggable(capture).getWorldTranslation().clone();
        event.setConsumed();
    }

    protected void endDrag(CursorButtonEvent event, Spatial target, Spatial capture) {
        if (this.consumeDrops) {
            event.setConsumed();
        }
        this.drag = null;
        this.basePosition = null;
    }

    @Override
    public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
        if (event.getButtonIndex() != 0) {
            return;
        }
        if (event.isPressed()) {
            this.startDrag(event, target, capture);
        } else if (this.drag != null) {
            this.endDrag(event, target, capture);
        }
    }

    @Override
    public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
        if (this.drag == null || capture == null) {
            return;
        }
        ViewPort vp = event.getViewPort();
        Camera cam = vp.getCamera();
        if (this.consumeDrags) {
            event.setConsumed();
        }
        if (cam.isParallelProjection() || capture.getQueueBucket() == RenderQueue.Bucket.Gui) {
            Vector2f current = new Vector2f(event.getX(), event.getY());
            Vector2f delta = current.subtract(this.drag);
            Spatial draggable = this.findDraggable(capture);
            this.basePosition.z = draggable.getWorldTranslation().z;
            Vector3f localPos = this.basePosition.add(delta.x, delta.y, 0.0f);
            if (draggable.getParent() != null) {
                localPos = draggable.getParent().worldToLocal(localPos, null);
            }
            draggable.setLocalTranslation(localPos);
            return;
        }
        Vector3f pos = this.basePosition;
        Vector3f localPos = pos.subtract(cam.getLocation());
        float dist = cam.getDirection().dot(localPos);
        Vector3f v1 = cam.getScreenCoordinates(pos, null);
        Vector3f right = cam.getScreenCoordinates(pos.add(cam.getLeft().negate()), null);
        Vector3f up = cam.getScreenCoordinates(pos.add(cam.getUp()), null);
        Vector2f units = new Vector2f(right.x - v1.x, up.y - v1.y);
        Vector2f current = new Vector2f(event.getX(), event.getY());
        Vector2f delta = current.subtract(this.drag);
        delta.x /= Math.abs(units.x);
        delta.y /= Math.abs(units.y);
        Vector3f newPos = pos.add(cam.getLeft().mult(-delta.x));
        newPos.addLocal(cam.getUp().mult(delta.y));
        Spatial draggable = this.findDraggable(capture);
        Vector3f local = draggable.getParent().worldToLocal(newPos, null);
        draggable.setLocalTranslation(local);
    }

    public void setConsumeDrags(boolean consumeDrags) {
        this.consumeDrags = consumeDrags;
    }

    public boolean getConsumeDrags() {
        return this.consumeDrags;
    }

    public void setConsumeDrops(boolean consumeDrops) {
        this.consumeDrops = consumeDrops;
    }

    public boolean getConsumeDrops() {
        return this.consumeDrops;
    }
}

