/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import mythruna.es.Morph;
import mythruna.es.MorphAnimation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphAnimationSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(MorphAnimationSystem.class);
    private EntityData ed;
    private AnimatorContainer animators;
    private long timeStep;
    private long nextRunTime;

    protected void initialize() {
        log.info("initialize()");
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.animators = new AnimatorContainer(this.ed);
        this.timeStep = this.getManager().getStepTime().toSimTime(0.05);
    }

    protected void terminate() {
        log.info("terminate()");
    }

    public void start() {
        log.info("start()");
        this.animators.start();
    }

    public void update(SimTime time) {
        long frameTime = time.getTime();
        this.animators.update();
        for (Animator anim : this.animators.getArray()) {
            anim.updateMorph(frameTime);
        }
    }

    public void stop() {
        this.animators.stop();
    }

    protected final double smoothStep(double t) {
        if (t < 0.0) {
            return 0.0;
        }
        if (t > 1.0) {
            return 1.0;
        }
        return t * t * (3.0 - 2.0 * t);
    }

    private class AnimatorContainer
    extends EntityContainer<Animator> {
        public AnimatorContainer(EntityData ed) {
            super(ed, new Class[]{Morph.class, MorphAnimation.class});
        }

        public Animator[] getArray() {
            return (Animator[])super.getArray();
        }

        protected Animator addObject(Entity entity) {
            log.info("addObject(" + entity + ")");
            Animator anim = new Animator(entity);
            this.updateObject(anim, entity);
            return anim;
        }

        protected void updateObject(Animator anim, Entity entity) {
        }

        protected void removeObject(Animator anim, Entity entity) {
            anim.release();
        }
    }

    private class Animator {
        private Entity entity;

        public Animator(Entity entity) {
            this.entity = entity;
        }

        public void updateMorph(long time) {
            Morph morph = (Morph)this.entity.get(Morph.class);
            MorphAnimation ma = (MorphAnimation)this.entity.get(MorphAnimation.class);
            double part = (double)(time - ma.getStartTime()) / (double)(ma.getEndTime() - ma.getStartTime());
            if (part < 0.0) {
                part = 0.0;
            }
            if (part > 1.0) {
                part = 1.0;
                this.release();
            }
            double mix = ma.getStartMix() + (ma.getEndMix() - ma.getStartMix()) * part;
            morph = morph.changeMix(MorphAnimationSystem.this.smoothStep(mix));
            this.entity.set((EntityComponent)morph);
        }

        public void release() {
            log.info("release():" + this.entity);
            MorphAnimationSystem.this.ed.removeComponent(this.entity.getId(), MorphAnimation.class);
        }
    }
}

